/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.main.GolemItems;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class GolemColorized
extends GolemBase {
    private long color;
    protected float colorRed;
    protected float colorBlue;
    protected float colorGreen;
    protected float colorAlpha;
    protected final ResourceLocation base;
    protected final ResourceLocation overlay;
    protected final boolean hasBase;

    public GolemColorized(World world, float attack, ItemStack pickBlock, long initial, ResourceLocation rBase, ResourceLocation rOverlay) {
        super(world, attack, pickBlock);
        this.setColor(initial);
        this.base = rBase;
        this.overlay = rOverlay;
        this.hasBase = this.base != null;
    }

    public GolemColorized(World world, float attack, long initial, ResourceLocation rBase, ResourceLocation rOverlay) {
        this(world, attack, new ItemStack(GolemItems.golemHead), initial, rBase, rOverlay);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return GolemColorized.makeGolemTexture("clay");
    }

    public ResourceLocation getTextureBase() {
        return this.base;
    }

    public ResourceLocation getTextureToColor() {
        return this.overlay;
    }

    public boolean hasBase() {
        return this.hasBase;
    }

    public void setColor(long toSet) {
        this.color = toSet;
        long tmpColor = toSet;
        if ((tmpColor & 0xFFFFFFFFFC000000L) == 0L) {
            tmpColor |= 0xFFFFFFFFFF000000L;
        }
        this.colorRed = (float)(tmpColor >> 16 & 0xFFL) / 255.0f;
        this.colorGreen = (float)(tmpColor >> 8 & 0xFFL) / 255.0f;
        this.colorBlue = (float)(tmpColor & 0xFFL) / 255.0f;
        this.colorAlpha = (float)(tmpColor >> 24 & 0xFFL) / 255.0f;
    }

    public long getColor() {
        return this.color;
    }

    public float getColorRed() {
        return this.colorRed;
    }

    public float getColorGreen() {
        return this.colorGreen;
    }

    public float getColorBlue() {
        return this.colorBlue;
    }

    public float getColorAlpha() {
        return this.colorAlpha;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasTransparency() {
        return false;
    }
}

