/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemColorized;
import net.minecraft.block.Block;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public abstract class GolemColorizedMultiTextured
extends GolemColorized {
    protected static final DataParameter<Byte> DATA_TEXTURE = EntityDataManager.func_187226_a(GolemColorizedMultiTextured.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final String NBT_TEXTURE = "GolemTextureData";
    protected final int[] colors;

    public GolemColorizedMultiTextured(World world, float damage, ItemStack pick, ResourceLocation BASE, ResourceLocation OVERLAY, int[] lColors) {
        super(world, damage, pick, 0L, BASE, OVERLAY);
        this.colors = lColors;
    }

    public GolemColorizedMultiTextured(World world, float damage, Block pick, ResourceLocation BASE, ResourceLocation OVERLAY, int[] lColors) {
        this(world, damage, new ItemStack(pick), BASE, OVERLAY, lColors);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_TEXTURE, (Object)0);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (stack != null) {
            return super.func_184645_a(player, hand, stack);
        }
        int incremented = (this.getTextureNum() + 1) % this.colors.length;
        this.setTextureNum((byte)incremented);
        this.updateTextureByData(this.getTextureNum());
        this.func_70014_b(this.getEntityData());
        player.func_184609_a(hand);
        return true;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa == 2) {
            this.updateTextureByData(this.getTextureNum());
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a(NBT_TEXTURE, (byte)this.getTextureNum());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setTextureNum(nbt.func_74771_c(NBT_TEXTURE));
        this.updateTextureByData(this.getTextureNum());
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        this.setTextureNum((byte)this.field_70146_Z.nextInt(this.colors.length));
        this.updateTextureByData(this.getTextureNum());
        return super.func_180482_a(difficulty, data);
    }

    @Override
    public boolean doesInteractChangeTexture() {
        return true;
    }

    public void setTextureNum(byte toSet) {
        this.func_184212_Q().func_187227_b(DATA_TEXTURE, (Object)new Byte(toSet));
    }

    public int getTextureNum() {
        return ((Byte)this.func_184212_Q().func_187225_a(DATA_TEXTURE)).intValue();
    }

    public int[] getColorArray() {
        return this.colors;
    }

    protected void updateTextureByData(int data) {
        this.setColor(this.colors[data]);
    }
}

