/*
 * Decompiled with CFR 0.152.
 */
package com.golems.events;

import com.golems.entity.GolemBase;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.eventhandler.Event;

@Event.HasResult
public class IceGolemFreezeEvent
extends Event {
    public Map<BlockPos, IBlockState> affectedBlocks;
    public final GolemBase iceGolem;
    public final BlockPos iceGolemPos;
    public final int range;
    public int iceChance = 62;
    public int cobbleChance = 39;

    public IceGolemFreezeEvent(GolemBase golem, BlockPos center, int RADIUS) {
        this.setResult(Event.Result.ALLOW);
        this.iceGolem = golem;
        this.iceGolemPos = center;
        this.range = RADIUS;
        this.initAffectedBlockList();
    }

    protected void initAffectedBlockList() {
        this.affectedBlocks = new HashMap<BlockPos, IBlockState>(this.range * this.range * 2 * 4);
        int x = this.iceGolemPos.func_177958_n();
        int y = this.iceGolemPos.func_177956_o();
        int z = this.iceGolemPos.func_177952_p();
        for (int i = -this.range; i <= this.range; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -this.range; k <= this.range; ++k) {
                    BlockPos pos;
                    IBlockState state;
                    if (!(this.iceGolemPos.func_177954_c((double)(x + i), (double)y, (double)(z + k)) <= (double)(this.range * this.range)) || !(state = this.iceGolem.field_70170_p.func_180495_p(pos = new BlockPos(x + i, y + j, z + k))).func_185904_a().func_76224_d()) continue;
                    IBlockState toBecome = null;
                    if (state.func_177230_c() == Blocks.field_150355_j) {
                        boolean isNotPacked = this.iceGolem.func_70681_au().nextInt(100) < this.iceChance;
                        toBecome = isNotPacked ? Blocks.field_150432_aD.func_176223_P() : Blocks.field_150403_cj.func_176223_P();
                    } else if (state.func_177230_c() == Blocks.field_150358_i) {
                        toBecome = Blocks.field_150432_aD.func_176223_P();
                    } else if (state.func_177230_c() == Blocks.field_150356_k) {
                        toBecome = Blocks.field_150347_e.func_176223_P();
                    } else if (state.func_177230_c() == Blocks.field_150353_l) {
                        boolean isNotObsidian = this.iceGolem.func_70681_au().nextInt(100) < this.cobbleChance;
                        IBlockState iBlockState = toBecome = isNotObsidian ? Blocks.field_150347_e.func_176223_P() : Blocks.field_150343_Z.func_176223_P();
                    }
                    if (toBecome == null) continue;
                    this.add(pos, toBecome);
                }
            }
        }
    }

    public boolean freezeBlocks() {
        boolean flag = false;
        BlockPos[] positions = this.makeBlockPosArray();
        IBlockState[] states = this.makeStateArray(positions);
        int len = this.affectedBlocks.size();
        for (int i = 0; i < len; ++i) {
            flag &= this.iceGolem.field_70170_p.func_175656_a(positions[i], states[i]);
        }
        return flag;
    }

    public IBlockState add(BlockPos pos, IBlockState state) {
        return this.affectedBlocks.put(pos, state);
    }

    public boolean removeBlockPos(BlockPos toRemove) {
        return this.affectedBlocks.remove(toRemove) != null;
    }

    public void clearMap() {
        this.affectedBlocks.clear();
    }

    public BlockPos[] makeBlockPosArray() {
        return this.affectedBlocks.keySet().toArray(new BlockPos[this.affectedBlocks.size()]);
    }

    public IBlockState[] makeStateArray(BlockPos[] keys) {
        IBlockState[] states = new IBlockState[keys.length];
        int len = keys.length;
        for (int i = 0; i < len; ++i) {
            states[i] = this.affectedBlocks.get(keys[i]);
        }
        return states;
    }
}

