/*
 * Decompiled with CFR 0.152.
 */
package com.golems.integration;

import com.golems.entity.EntityBedrockGolem;
import com.golems.entity.EntityBookshelfGolem;
import com.golems.entity.EntityCoalGolem;
import com.golems.entity.EntityCraftingGolem;
import com.golems.entity.EntityEndstoneGolem;
import com.golems.entity.EntityIceGolem;
import com.golems.entity.EntityLapisGolem;
import com.golems.entity.EntityLeafGolem;
import com.golems.entity.EntityMagmaGolem;
import com.golems.entity.EntityMelonGolem;
import com.golems.entity.EntityMushroomGolem;
import com.golems.entity.EntityNetherBrickGolem;
import com.golems.entity.EntityNetherWartGolem;
import com.golems.entity.EntityRedstoneGolem;
import com.golems.entity.EntitySlimeGolem;
import com.golems.entity.EntitySpongeGolem;
import com.golems.entity.EntityTNTGolem;
import com.golems.entity.GolemBase;
import com.golems.entity.GolemLightProvider;
import com.golems.entity.GolemMultiTextured;
import com.golems.main.Config;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.text.TextFormatting;

public abstract class GolemDescriptionManager {
    protected boolean showSpecial = true;
    protected boolean showMultiTexture = true;
    protected boolean showAttack = true;
    protected boolean showFireproof = true;
    protected boolean showKnockbackResist = false;

    public List<String> getEntityDescription(GolemBase golem) {
        LinkedList<String> list = new LinkedList<String>();
        if (this.showAttack) {
            float attack = golem.getBaseAttackDamage();
            String sAttack = TextFormatting.GRAY + this.trans("attack", new Object[0]) + " : " + TextFormatting.WHITE + attack;
            list.add(sAttack);
        }
        if (this.showMultiTexture && (golem instanceof GolemMultiTextured || golem.doesInteractChangeTexture())) {
            String sColor = TextFormatting.BLUE + this.trans("click_change_texture", new Object[0]);
            list.add(sColor);
        }
        if (this.showFireproof && golem.func_70045_F() && !(golem instanceof EntityBedrockGolem)) {
            String sFire = TextFormatting.GOLD + this.trans("is_fireproof", new Object[0]);
            list.add(sFire);
        }
        if (this.showKnockbackResist && golem.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111125_b() > 0.8999) {
            String sResist = TextFormatting.GRAY + this.trans("knockback_resist", new Object[0]);
            list.add(sResist);
        }
        if (this.showSpecial) {
            if (golem instanceof GolemLightProvider) {
                String sLight = TextFormatting.YELLOW + this.trans("lights_area", new Object[0]);
                list.add(sLight);
            }
            if (((Object)((Object)golem)).getClass() == EntityBedrockGolem.class) {
                String sIndestructible = TextFormatting.WHITE + "" + TextFormatting.BOLD + this.trans("indestructible", new Object[0]);
                list.add(sIndestructible);
            }
            if (((Object)((Object)golem)).getClass() == EntityBookshelfGolem.class) {
                String sPotion = TextFormatting.LIGHT_PURPLE + this.trans("grants_self_potion_effects", new Object[0]);
                if (Config.BOOKSHELF.getBoolean("Allow Special: Potion Effects")) {
                    list.add(sPotion);
                }
            }
            if (((Object)((Object)golem)).getClass() == EntityCoalGolem.class) {
                String sPotion = TextFormatting.GRAY + this.trans("blinds_creatures", new Object[0]);
                if (Config.COAL.getBoolean("Allow Special: Blindness")) {
                    list.add(sPotion);
                }
            }
            if (((Object)((Object)golem)).getClass() == EntityCraftingGolem.class) {
                String sCraft = TextFormatting.BLUE + this.trans("click_open_crafting", new Object[0]);
                list.add(sCraft);
            }
            if (((Object)((Object)golem)).getClass() == EntityEndstoneGolem.class) {
                String sTeleport = TextFormatting.DARK_AQUA + this.trans("can_teleport", new Object[0]);
                if (Config.ENDSTONE.getBoolean("Allow Special: Teleporting")) {
                    list.add(sTeleport);
                }
            }
            if (((Object)((Object)golem)).getClass() == EntityIceGolem.class) {
                String sFreeze = TextFormatting.AQUA + this.trans("freezes_blocks", new Object[0]);
                if (Config.ICE.getBoolean("Allow Special: Freeze Blocks")) {
                    list.add(sFreeze);
                }
            }
            if (((Object)((Object)golem)).getClass() == EntityLapisGolem.class) {
                String sPotion = TextFormatting.LIGHT_PURPLE + this.trans("attacks_use_potion_effects", new Object[0]);
                if (Config.LAPIS.getBoolean("Allow Special: Potion Effects")) {
                    list.add(sPotion);
                }
            }
            if (((Object)((Object)golem)).getClass() == EntityLeafGolem.class) {
                String sPotion = TextFormatting.DARK_GREEN + this.trans("has_regen_1", new Object[0]);
                if (Config.LEAF.getBoolean("Allow Special: Regeneration")) {
                    list.add(sPotion);
                }
            }
            if (((Object)((Object)golem)).getClass() == EntityMagmaGolem.class) {
                String sLava = TextFormatting.RED + this.trans("slowly_melts", this.trans("tile.stonebrick.name", new Object[0]));
                if (Config.MAGMA.getBoolean("Allow Special: Melt Cobblestone")) {
                    list.add(sLava);
                }
            }
            if (((Object)((Object)golem)).getClass() == EntityMelonGolem.class) {
                String sPlant = TextFormatting.GREEN + this.trans("plants_flowers", new Object[0]);
                if (Config.MELON.getBoolean("Allow Special: Plant Flowers")) {
                    list.add(sPlant);
                }
            }
            if (((Object)((Object)golem)).getClass() == EntityMushroomGolem.class) {
                String sPlant = TextFormatting.DARK_GREEN + this.trans("plants_shrooms", new Object[0]);
                if (Config.MUSHROOM.getBoolean("Allow Special: Plant Mushrooms")) {
                    list.add(sPlant);
                }
            }
            if (((Object)((Object)golem)).getClass() == EntityNetherBrickGolem.class) {
                String sFire = TextFormatting.RED + this.trans("lights_mobs_on_fire", new Object[0]);
                if (Config.NETHERBRICK.getBoolean("Allow Special: Burn Enemies")) {
                    list.add(sFire);
                }
            }
            if (((Object)((Object)golem)).getClass() == EntityNetherWartGolem.class) {
                String sPlant = TextFormatting.RED + this.trans("plants_warts", new Object[0]);
                if (Config.NETHERWART.getBoolean("Allow Special: Plant Netherwart")) {
                    list.add(sPlant);
                }
            }
            if (((Object)((Object)golem)).getClass() == EntityRedstoneGolem.class) {
                String sRed = TextFormatting.RED + this.trans("emits_redstone_signal", new Object[0]);
                if (Config.REDSTONE.getBoolean("Allow Special: Redstone Power")) {
                    list.add(sRed);
                }
            }
            if (((Object)((Object)golem)).getClass() == EntitySlimeGolem.class) {
                String sKnock = TextFormatting.GREEN + this.trans("has_knockback", new Object[0]);
                if (Config.SLIME.getBoolean("Allow Special: Extra Knockback")) {
                    list.add(sKnock);
                }
            }
            if (((Object)((Object)golem)).getClass() == EntitySpongeGolem.class) {
                String sWater = TextFormatting.YELLOW + this.trans("absorbs_water", new Object[0]);
                if (Config.SPONGE.getBoolean("Allow Special: Absorb Water")) {
                    list.add(sWater);
                }
            }
            if (((Object)((Object)golem)).getClass() == EntityTNTGolem.class) {
                String sBoom = TextFormatting.RED + this.trans("explodes", new Object[0]);
                if (Config.TNT.getBoolean("Allow Special: Explode")) {
                    list.add(sBoom);
                }
            }
        }
        return list;
    }

    protected String trans(String s, Object ... strings) {
        return I18n.func_135052_a((String)"entitytip.".concat(s), (Object[])strings);
    }
}

