/*
 * Decompiled with CFR 0.152.
 */
package com.golems.integration.waila;

import com.golems.entity.GolemBase;
import com.golems.integration.GolemDescriptionManager;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="mcp.mobius.waila.api.IWailaEntityProvider", modid="Waila")
public class WailaExtraGolems
extends GolemDescriptionManager
implements IWailaEntityProvider {
    public static final String configShowAttackDamage = "extragolems.show_attack_damage_tip";
    public static final String configShowSpecialAbilities = "extragolems.show_special_abilities_tip";
    public static final String configShowKnockbackResist = "extragolems.show_knockback_resistance_tip";
    public static final String configShowMultiTexture = "extragolems.show_multitexture_tip";
    public static final String configShowFireproof = "extragolems.show_fireproof_tip";

    @Optional.Method(modid="Waila")
    public static void callbackRegister(IWailaRegistrar register) {
        WailaExtraGolems instance = new WailaExtraGolems();
        register.registerBodyProvider((IWailaEntityProvider)instance, GolemBase.class);
        register.addConfig("Extra-Golems", configShowAttackDamage, true);
        register.addConfig("Extra-Golems", configShowSpecialAbilities, true);
        register.addConfig("Extra-Golems", configShowKnockbackResist, false);
        register.addConfig("Extra-Golems", configShowMultiTexture, true);
        register.addConfig("Extra-Golems", configShowFireproof, true);
    }

    @Optional.Method(modid="Waila")
    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity entity, NBTTagCompound tag, World world) {
        NBTTagCompound tag2 = new NBTTagCompound();
        entity.func_189511_e(tag2);
        return tag2;
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaBody(Entity entity, List<String> tip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        if (entity instanceof GolemBase) {
            GolemBase golem = (GolemBase)entity;
            this.showAttack = config.getConfig(configShowAttackDamage);
            this.showMultiTexture = config.getConfig(configShowMultiTexture);
            this.showSpecial = config.getConfig(configShowSpecialAbilities);
            this.showFireproof = config.getConfig(configShowFireproof);
            this.showKnockbackResist = config.getConfig(configShowKnockbackResist);
            tip.addAll(this.getEntityDescription(golem));
        }
        return tip;
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaHead(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Optional.Method(modid="Waila")
    public Entity getWailaOverride(IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return accessor.getEntity();
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaTail(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }
}

