/*
 * Decompiled with CFR 0.152.
 */
package com.golems.renders;

import com.golems.entity.GolemBase;
import com.golems.entity.GolemColorized;
import com.golems.renders.ModelGolem;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;

public class RenderColoredGolem
extends RenderLiving<GolemColorized> {
    private static final ResourceLocation fallbackTexture = GolemBase.makeGolemTexture("clay");
    private ResourceLocation texture;

    public RenderColoredGolem(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)new ModelGolem(), 0.5f);
    }

    public void doRender(GolemColorized golem, double x, double y, double z, float f0, float f1) {
        float colorRed = golem.getColorRed();
        float colorGreen = golem.getColorGreen();
        float colorBlue = golem.getColorBlue();
        float colorAlpha = golem.getColorAlpha();
        if (golem.hasBase()) {
            this.texture = golem.getTextureBase();
            if (this.texture != null) {
                super.func_76986_a((EntityLiving)golem, x, y, z, f0, f1);
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)colorRed, (float)colorGreen, (float)colorBlue, (float)colorAlpha);
        if (golem.hasTransparency()) {
            GlStateManager.func_179108_z();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
        }
        this.texture = golem.getTextureToColor();
        if (this.texture != null) {
            super.func_76986_a((EntityLiving)golem, x, y, z, f0, f1);
        }
        if (golem.hasTransparency()) {
            GlStateManager.func_179084_k();
            GlStateManager.func_179133_A();
        }
        GlStateManager.func_179121_F();
    }

    protected void rotateCorpse(GolemColorized golem, float p_77043_2_, float p_77043_3_, float partialTicks) {
        super.func_77043_a((EntityLivingBase)golem, p_77043_2_, p_77043_3_, partialTicks);
        if ((double)golem.field_70721_aZ >= 0.01) {
            float f = 13.0f;
            float f1 = golem.field_184619_aG - golem.field_70721_aZ * (1.0f - partialTicks) + 6.0f;
            float f2 = (Math.abs(f1 % f - f * 0.5f) - f * 0.25f) / (f * 0.25f);
            GlStateManager.func_179114_b((float)(6.5f * f2), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected ResourceLocation getEntityTexture(GolemColorized golem) {
        return this.texture != null ? this.texture : fallbackTexture;
    }
}

