/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.blocks.ContainerPortableWorkbench;
import com.golems.entity.GolemBase;
import com.golems.main.Config;
import com.golems.util.WeightedItem;
import java.util.List;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;

public class EntityCraftingGolem
extends GolemBase {
    public EntityCraftingGolem(World world) {
        super(world, Config.CRAFTING.getBaseAttack(), Blocks.field_150462_ai);
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.CRAFTING.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityCraftingGolem.makeGolemTexture("crafting");
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack itemstack) {
        if (!player.field_70170_p.field_72995_K && itemstack == null) {
            player.func_180468_a((IInteractionObject)new InterfaceCraftingGrid(player.field_70170_p, player.field_71081_bT));
            player.func_71029_a(StatList.field_188062_ab);
            player.func_184609_a(hand);
        }
        return super.func_184645_a(player, hand, itemstack);
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        this.addDrop(dropList, new ItemStack(Blocks.field_150462_ai, 1 + this.field_70146_Z.nextInt(2)), 100);
        this.addDrop(dropList, Blocks.field_150344_f, 0, 1, 6, 70 + lootingLevel * 10);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187897_gY;
    }

    public static class InterfaceCraftingGrid
    extends BlockWorkbench.InterfaceCraftingTable {
        private final World world2;
        private final BlockPos position2;

        public InterfaceCraftingGrid(World worldIn, BlockPos pos) {
            super(worldIn, pos);
            this.world2 = worldIn;
            this.position2 = pos;
        }

        public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
            return new ContainerPortableWorkbench(playerInventory, this.world2, this.position2);
        }
    }
}

