/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.main.Config;
import com.golems.main.GolemItems;
import com.golems.util.WeightedItem;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityEndstoneGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Teleporting";
    public static final String ALLOW_WATER_HURT = "Can Take Water Damage";
    protected int teleportDelay;
    protected double range;
    protected boolean canTeleport;
    protected boolean isHurtByWater;
    protected boolean hasAmbientParticles;
    protected int ticksBetweenIdleTeleports = 200;
    protected int chanceToTeleportWhenHurt = 15;

    public EntityEndstoneGolem(World world) {
        this(world, Config.ENDSTONE.getBaseAttack(), new ItemStack(Blocks.field_150377_bs), 32.0, Config.ENDSTONE.getBoolean(ALLOW_SPECIAL), Config.ENDSTONE.getBoolean(ALLOW_WATER_HURT), true);
    }

    public EntityEndstoneGolem(World world, float attack, ItemStack pick, double teleportRange, boolean teleportingAllowed, boolean hurtByWater, boolean ambientParticles) {
        super(world, attack, pick);
        this.range = teleportRange;
        this.canTeleport = teleportingAllowed;
        this.isHurtByWater = hurtByWater;
        this.hasAmbientParticles = ambientParticles;
    }

    public EntityEndstoneGolem(World world, float attack, double teleportRange, boolean teleportingAllowed, boolean hurtByWater, boolean ambientParticles) {
        this(world, attack, new ItemStack(GolemItems.golemHead, 1), teleportRange, teleportingAllowed, hurtByWater, ambientParticles);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityEndstoneGolem.makeGolemTexture("end_stone");
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.ENDSTONE.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        this.addDrop(dropList, Blocks.field_150377_bs, 0, 2, 2 + lootingLevel, 90);
        this.addDrop(dropList, Items.field_151079_bi, 0, 2, 4 + lootingLevel, 40);
        this.addDrop(dropList, Items.field_151061_bv, 0, 1, 1 + lootingLevel, 6);
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * this.range;
        double d1 = this.field_70163_u + (this.field_70146_Z.nextDouble() - 0.5) * this.range * 0.5;
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * this.range;
        return this.teleportTo(d0, d1, d2);
    }

    @Override
    public void func_70619_bc() {
        super.func_70619_bc();
        if (this.isHurtByWater && this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
            for (int i = 0; i < 16 && !this.teleportRandomly(); ++i) {
            }
        }
        if (this.func_70643_av() != null) {
            this.func_70625_a((Entity)this.func_70643_av(), 100.0f, 100.0f);
            if (this.field_70146_Z.nextInt(5) == 0) {
                this.teleportToEntity((Entity)this.func_70643_av());
            }
        } else if (this.field_70146_Z.nextInt(this.ticksBetweenIdleTeleports) == 0) {
            this.teleportRandomly();
        }
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; this.hasAmbientParticles && i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.func_70643_av() != null) {
                if (this.func_70643_av() instanceof EntityMob) {
                    if (this.func_70643_av().func_70068_e((Entity)this) < 16.0) {
                        this.teleportRandomly();
                    }
                    this.teleportDelay = 0;
                } else if (this.func_70643_av().func_70068_e((Entity)this) > 256.0 && this.teleportDelay++ >= 30 && this.teleportToEntity((Entity)this.func_70643_av())) {
                    this.teleportDelay = 0;
                }
            } else {
                this.teleportDelay = 0;
            }
        }
        this.field_70703_bu = false;
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource src, float amnt) {
        if (this.func_180431_b(src)) {
            return false;
        }
        if (src instanceof EntityDamageSourceIndirect) {
            for (int i = 0; i < 32; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
            return super.func_70097_a(src, amnt);
        }
        if (this.field_70146_Z.nextInt(this.chanceToTeleportWhenHurt) == 0 || this.func_70643_av() != null && this.field_70146_Z.nextBoolean()) {
            this.teleportRandomly();
        }
        return super.func_70097_a(src, amnt);
    }

    protected boolean teleportToEntity(Entity p_70816_1_) {
        Vec3d vec3d = new Vec3d(this.field_70165_t - p_70816_1_.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - p_70816_1_.field_70163_u + (double)p_70816_1_.func_70047_e(), this.field_70161_v - p_70816_1_.field_70161_v);
        vec3d = vec3d.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * d0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3d.field_72448_b * d0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * d0;
        return this.teleportTo(d1, d2, d3);
    }

    private boolean teleportTo(double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (!this.canTeleport || MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = this.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        if (flag) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187902_gb;
    }
}

