/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.events.IceGolemFreezeEvent;
import com.golems.main.Config;
import com.golems.util.WeightedItem;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityIceGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Freeze Blocks";
    public static final String CAN_USE_REGULAR_ICE = "Can Use Regular Ice";
    public static final String AOE = "Area of Effect";

    public EntityIceGolem(World world) {
        super(world, Config.ICE.getBaseAttack(), Blocks.field_150403_cj);
        this.setCanSwim(true);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityIceGolem.makeGolemTexture("ice");
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 2 == 0) {
            int z;
            int y;
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            BlockPos below = new BlockPos(x, y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), z = MathHelper.func_76128_c((double)this.field_70161_v));
            if (this.field_70170_p.func_180494_b(below).func_180626_a(below) > 1.0f) {
                this.func_70097_a(DamageSource.field_76370_b, 1.0f);
            }
            if (Config.ICE.getBoolean(ALLOW_SPECIAL)) {
                IceGolemFreezeEvent event = new IceGolemFreezeEvent(this, below, Config.ICE.getInt(AOE));
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.getResult() != Event.Result.DENY) {
                    event.freezeBlocks();
                }
            }
        }
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity.func_70027_ad()) {
                this.func_70097_a(DamageSource.field_76377_j, 0.5f);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.ICE.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 1 + lootingLevel;
        this.addDrop(dropList, new ItemStack(Blocks.field_150432_aD, size > 4 ? 4 : size), 100);
        if (lootingLevel > 0 || !Config.ICE.getBoolean(CAN_USE_REGULAR_ICE)) {
            this.addDrop(dropList, Blocks.field_150403_cj, 0, 0, size > 2 ? 2 : size, 80);
        }
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187561_bM;
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187569_bQ;
    }
}

