/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.main.Config;
import com.golems.util.WeightedItem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityNetherBrickGolem
extends GolemBase {
    public static final String ALLOW_LAVA_SPECIAL = "Allow Special: Melt Cobblestone";
    public static final String ALLOW_FIRE_SPECIAL = "Allow Special: Burn Enemies";
    public static final String MELT_DELAY = "Melting Delay";
    private int ticksStandingStill = 0;

    public EntityNetherBrickGolem(World world) {
        super(world, Config.NETHERBRICK.getBaseAttack(), Blocks.field_150385_bj);
        this.field_70178_ae = true;
        this.field_70138_W = 1.0f;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityNetherBrickGolem.makeGolemTexture("nether_brick");
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (Config.NETHERBRICK.getBoolean(ALLOW_FIRE_SPECIAL)) {
                entity.func_70015_d(2 + this.field_70146_Z.nextInt(5));
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (Config.NETHERBRICK.getBoolean(ALLOW_LAVA_SPECIAL)) {
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            int y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
            int z = MathHelper.func_76128_c((double)this.field_70161_v);
            BlockPos below = new BlockPos(x, y, z);
            Block b1 = this.field_70170_p.func_180495_p(below).func_177230_c();
            if (x == MathHelper.func_76128_c((double)this.field_70142_S) && z == MathHelper.func_76128_c((double)this.field_70136_U)) {
                if (++this.ticksStandingStill >= Config.NETHERBRICK.getInt(MELT_DELAY) && b1 == Blocks.field_150347_e && this.field_70146_Z.nextInt(16) == 0) {
                    this.field_70170_p.func_180501_a(below, Blocks.field_150353_l.func_176223_P(), 3);
                    this.ticksStandingStill = 0;
                }
            } else {
                this.ticksStandingStill = 0;
            }
        }
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.NETHERBRICK.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 4 + this.field_70146_Z.nextInt(8 + lootingLevel);
        this.addDrop(dropList, new ItemStack(Items.field_151130_bT, size), 100);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187902_gb;
    }
}

