/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class GolemMultiTextured
extends GolemBase {
    protected static final DataParameter<Byte> DATA_TEXTURE = EntityDataManager.func_187226_a(GolemMultiTextured.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final String NBT_TEXTURE = "GolemTextureData";
    public final String[] textures;
    public final String texturePrefix;

    public GolemMultiTextured(World world, float attack, ItemStack pick, String prefix, String[] textureNames) {
        super(world, attack, pick);
        this.textures = textureNames;
        this.texturePrefix = prefix;
    }

    public GolemMultiTextured(World world, float attack, Block pick, String prefix, String[] textureNames) {
        this(world, attack, new ItemStack(pick), prefix, textureNames);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return GolemMultiTextured.makeGolemTexture("clay");
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_TEXTURE, (Object)0);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (stack != null) {
            return super.func_184645_a(player, hand, stack);
        }
        int incremented = (this.getTextureNum() + 1) % this.textures.length;
        this.setTextureNum((byte)incremented);
        this.setTextureType(this.getSpecialGolemTexture(this.getTextureStringFromArray()));
        this.func_70014_b(this.getEntityData());
        player.func_184609_a(hand);
        return true;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa == 2) {
            this.setTextureType(this.getSpecialGolemTexture(this.getTextureStringFromArray()));
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a(NBT_TEXTURE, (byte)this.getTextureNum());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setTextureNum(nbt.func_74771_c(NBT_TEXTURE));
        this.setTextureType(this.getSpecialGolemTexture(this.getTextureStringFromArray()));
    }

    @Override
    public boolean doesInteractChangeTexture() {
        return true;
    }

    public void setTextureNum(byte toSet) {
        this.func_184212_Q().func_187227_b(DATA_TEXTURE, (Object)new Byte(toSet));
    }

    public byte getTextureByte() {
        return (Byte)this.func_184212_Q().func_187225_a(DATA_TEXTURE);
    }

    public int getTextureNum() {
        return ((Byte)this.func_184212_Q().func_187225_a(DATA_TEXTURE)).byteValue();
    }

    public int getNumTextures() {
        return this.textures != null ? Integer.valueOf(this.textures.length) : null;
    }

    public int getMaxTextureNum() {
        return this.getNumTextures() - 1;
    }

    public ResourceLocation getSpecialGolemTexture() {
        return this.getSpecialGolemTexture(this.getTextureStringFromArray());
    }

    public ResourceLocation getSpecialGolemTexture(String s) {
        return GolemBase.makeGolemTexture(this.getModId(), this.getTexturePrefix() + "_" + s);
    }

    public String getTextureStringFromArray() {
        return this.textures[this.getTextureNum()];
    }

    public String getTexturePrefix() {
        return this.texturePrefix;
    }

    public String[] getTextureStringArray() {
        return this.textures;
    }

    public abstract String getModId();
}

