/*
 * Decompiled with CFR 0.152.
 */
package com.golems.util;

import java.util.List;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class WeightedItem {
    public final Item item;
    public final int meta;
    public final int maxAmount;
    public final int minAmount;
    public final int dropChance;

    public WeightedItem(Item itemIn, int metadata, int min, int max, int percentChance) {
        this.item = itemIn;
        this.meta = metadata;
        this.minAmount = min;
        this.maxAmount = max;
        this.dropChance = percentChance > 100 ? 100 : percentChance;
    }

    public WeightedItem(ItemStack stack, int percentChance) {
        this(stack.func_77973_b(), stack.func_77960_j(), stack.field_77994_a, stack.field_77994_a, percentChance);
    }

    public boolean shouldDrop(Random rand) {
        return this.item != null && rand.nextInt(100) < this.dropChance;
    }

    public int getRandomSize(Random rand) {
        return this.maxAmount > this.minAmount ? this.minAmount + rand.nextInt(this.maxAmount - this.minAmount + 1) : this.minAmount;
    }

    public ItemStack makeStack(Random rand) {
        int size = this.getRandomSize(rand);
        return new ItemStack(this.item, size, this.meta);
    }

    public static boolean removeFromList(List<WeightedItem> list, Item in, int meta) {
        boolean flag = false;
        for (WeightedItem w : list) {
            if (w.item != in || meta != Short.MAX_VALUE && w.meta != meta) continue;
            list.remove(w);
            flag = true;
        }
        return flag;
    }
}

