/*
 * Decompiled with CFR 0.152.
 */
package com.golems.blocks;

import com.golems.blocks.BlockUtility;
import com.golems.entity.GolemBase;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockUtilityGlow
extends BlockUtility {
    public static final PropertyInteger LIGHT_LEVEL = PropertyInteger.func_177719_a((String)"light", (int)0, (int)15);
    private final IBlockState REPLACE_WITH;
    private final int TICK_RATE;

    public BlockUtilityGlow(Material m, float defaultLight, int tickRate, IBlockState replaceWith) {
        super(m);
        int light = (int)(defaultLight * 15.0f);
        this.func_149675_a(true);
        this.func_149715_a(defaultLight);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LIGHT_LEVEL, (Comparable)Integer.valueOf(light)));
        this.TICK_RATE = tickRate;
        this.REPLACE_WITH = replaceWith;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        boolean hasLightGolem;
        AxisAlignedBB toCheck = new AxisAlignedBB(pos).func_186662_g(0.5);
        List list = worldIn.func_72872_a(GolemBase.class, toCheck);
        boolean bl = hasLightGolem = list != null && !list.isEmpty() && this.hasLightGolem(list);
        if (!hasLightGolem) {
            worldIn.func_180501_a(pos, this.REPLACE_WITH, 3);
        } else {
            worldIn.func_175684_a(pos, (Block)this, this.TICK_RATE);
        }
    }

    @Override
    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public int func_149738_a(World worldIn) {
        return this.TICK_RATE;
    }

    public boolean func_149698_L() {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LIGHT_LEVEL});
    }

    @Override
    public IBlockState func_176203_a(int metaIn) {
        int meta = metaIn;
        if (meta < 0) {
            meta = 0;
        }
        if (meta > 15) {
            meta = 15;
        }
        return this.func_176223_P().func_177226_a((IProperty)LIGHT_LEVEL, (Comparable)Integer.valueOf(meta));
    }

    public int func_149750_m(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LIGHT_LEVEL);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LIGHT_LEVEL);
    }

    protected boolean hasLightGolem(List<GolemBase> list) {
        for (GolemBase golem : list) {
            if (!golem.isProvidingLight()) continue;
            return true;
        }
        return false;
    }
}

