/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.items.ItemBedrockGolem;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class EntityFurnaceGolem
extends GolemBase {
    private static final DataParameter<Integer> FUEL = EntityDataManager.func_187226_a(EntityFurnaceGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final String KEY_FUEL = "FuelRemaining";
    private static final ResourceLocation LIT = EntityFurnaceGolem.makeTexture("golems", "golem_furnace_lit");
    private static final ResourceLocation UNLIT = EntityFurnaceGolem.makeTexture("golems", "golem_furnace_unlit");
    public static final String FUEL_FACTOR = "Burn Time";
    public static final int MAX_FUEL = 102400;
    public final int fuelBurnFactor = Math.max(1, EntityFurnaceGolem.getConfig(this).getInt("Burn Time"));

    public EntityFurnaceGolem(World world) {
        super(world);
        this.setImmuneToFire(true);
        this.addHealItem(new ItemStack(Blocks.field_150347_e), 0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(FUEL, (Object)0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new InertGoal(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new UseFuelGoal(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITempt((EntityCreature)this, 0.7, Items.field_151044_h, false));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(24) == 0) {
            double pMotion = 0.03;
            this.field_70170_p.func_175688_a(this.hasFuel() ? EnumParticleTypes.FLAME : EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + this.field_70170_p.field_73012_v.nextDouble() * 0.4 - 0.2 + this.field_70159_w * 8.0, this.field_70163_u + this.field_70170_p.field_73012_v.nextDouble() * 0.5 + (double)this.field_70131_O / 2.0, this.field_70161_v + this.field_70170_p.field_73012_v.nextDouble() * 0.4 - 0.2 + this.field_70179_y * 8.0, this.field_70170_p.field_73012_v.nextDouble() * 0.03 - 0.015, this.field_70170_p.field_73012_v.nextDouble() * 0.03 * 0.75, this.field_70170_p.field_73012_v.nextDouble() * 0.03 - 0.015, new int[0]);
        }
        if (!this.hasFuel() && this.func_70638_az() != null) {
            this.func_70624_b(null);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.setFuel(tag.func_74762_e(KEY_FUEL));
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a(KEY_FUEL, this.getFuel());
    }

    public void func_70108_f(Entity entityIn) {
        if (this.hasFuel()) {
            super.func_70108_f(entityIn);
        }
    }

    public float func_70111_Y() {
        return this.hasFuel() ? super.func_70111_Y() : 0.0f;
    }

    @Override
    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return this.hasFuel() && super.func_70686_a(cls);
    }

    public void func_70624_b(EntityLivingBase target) {
        if (this.hasFuel()) {
            super.func_70624_b(target);
        }
    }

    @Override
    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int burnTime = EntityFurnaceGolem.getBurnAmount(stack) * (player.func_70093_af() ? stack.func_190916_E() : 1);
        if (burnTime > 0 && this.getFuel() + burnTime <= 102400) {
            this.addFuel(burnTime);
            if (stack.func_190916_E() > 1 && !player.func_70093_af()) {
                stack.func_190918_g(1);
            } else {
                stack = stack.func_77973_b().getContainerItem(stack);
            }
            player.func_184611_a(hand, stack);
            ItemBedrockGolem.spawnParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v, 0.03, EnumParticleTypes.FLAME, 10);
            return true;
        }
        if (stack.func_77973_b() == Items.field_151131_as) {
            this.setFuel(0);
            player.func_184611_a(hand, stack.func_77973_b().getContainerItem(stack));
            ItemBedrockGolem.spawnParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v, 0.1, EnumParticleTypes.SMOKE_LARGE, 15);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    private static int getBurnAmount(ItemStack i) {
        return TileEntityFurnace.func_145952_a((ItemStack)i);
    }

    @Override
    public ResourceLocation getTextureType() {
        return this.hasFuel() ? LIT : UNLIT;
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityFurnaceGolem.makeTexture("golems", "golem_clay");
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187902_gb;
    }

    public boolean hasFuel() {
        return this.getFuel() > 0;
    }

    public int getFuel() {
        return (Integer)this.func_184212_Q().func_187225_a(FUEL);
    }

    public float getFuelPercentage() {
        return (float)this.getFuel() / 102400.0f;
    }

    public void setFuel(int fuel) {
        if (this.getFuel() != fuel) {
            this.func_184212_Q().func_187227_b(FUEL, (Object)fuel);
        }
    }

    public void addFuel(int toAdd) {
        if (toAdd != 0) {
            this.func_184212_Q().func_187227_b(FUEL, (Object)(this.getFuel() + toAdd));
        }
    }

    public void func_70034_d(float rotation) {
        if (this.hasFuel()) {
            super.func_70034_d(rotation);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70082_c(float yaw, float pitch) {
        if (this.hasFuel()) {
            super.func_70082_c(yaw, pitch);
        }
    }

    @Override
    public List<String> addSpecialDesc(List<String> list) {
        list.add(TextFormatting.GRAY + EntityFurnaceGolem.trans("entitytip.use_fuel", new Object[0]));
        int fuel = this.getFuel();
        if (fuel > 0) {
            int percentFuel = (int)Math.ceil(this.getFuelPercentage() * 100.0f);
            TextFormatting color = percentFuel < 6 ? TextFormatting.RED : (percentFuel < 16 ? TextFormatting.YELLOW : TextFormatting.WHITE);
            String fuelString = GuiScreen.func_146272_n() ? Integer.toString(fuel) : Integer.toString(percentFuel) + "%";
            list.add(TextFormatting.GRAY + EntityFurnaceGolem.trans("entitytip.fuel", new Object[0]) + ": " + color + fuelString);
        }
        return list;
    }

    class InertGoal
    extends EntityAIBase {
        private final EntityFurnaceGolem golem;

        protected InertGoal(EntityFurnaceGolem entity) {
            this.func_75248_a(7);
            this.golem = entity;
        }

        public boolean func_75250_a() {
            return !this.golem.hasFuel();
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            this.func_75246_d();
        }

        public void func_75246_d() {
            this.golem.field_70159_w = 0.0;
            this.golem.field_70179_y = 0.0;
            this.golem.func_191989_p(0.0f);
            this.golem.func_184646_p(0.0f);
            this.golem.func_70605_aq().func_75642_a(this.golem.field_70165_t, this.golem.field_70163_u, this.golem.field_70161_v, 0.1);
            this.golem.func_70637_d(false);
            this.golem.func_70661_as().func_75499_g();
            this.golem.field_70126_B = -15.0f;
            this.golem.func_70101_b(this.golem.field_70126_B, EntityFurnaceGolem.this.field_70126_B);
            double lookX = this.golem.func_70040_Z().field_72450_a;
            double lookY = Math.toRadians(-15.0);
            double lookZ = this.golem.func_70040_Z().field_72449_c;
            this.golem.func_70671_ap().func_75650_a(lookX, lookY, lookZ, (float)this.golem.func_184649_cE(), (float)this.golem.func_70646_bf());
        }
    }

    class UseFuelGoal
    extends EntityAIBase {
        private final EntityFurnaceGolem golem;

        protected UseFuelGoal(EntityFurnaceGolem entity) {
            this.golem = entity;
        }

        public boolean func_75250_a() {
            return this.golem.func_70613_aW() && this.golem.getFuel() > 0 && this.golem.field_70173_aa % this.golem.fuelBurnFactor == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            this.golem.addFuel(-1);
        }
    }
}

