/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.entity.GolemColorized;
import com.golems.util.GolemConfigSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public final class EntityLeafGolem
extends GolemColorized {
    public static final String ALLOW_SPECIAL = "Allow Special: Regeneration";
    private static final ResourceLocation TEXTURE_BASE = GolemBase.makeTexture("golems", "golem_leaves");
    private static final ResourceLocation TEXTURE_OVERLAY = GolemBase.makeTexture("golems", "golem_leaves_grayscale");

    public EntityLeafGolem(World world) {
        super(world, 6262858L, TEXTURE_BASE, TEXTURE_OVERLAY);
        this.setCanSwim(true);
        this.setLootTableLoc("golem_leaves");
        this.addHealItem(new ItemStack((Block)Blocks.field_150362_t, 1, Short.MAX_VALUE), 0.75);
        this.addHealItem(new ItemStack((Block)Blocks.field_150361_u, 1, Short.MAX_VALUE), 0.75);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.31);
    }

    public void func_70636_d() {
        super.func_70636_d();
        GolemConfigSet cfg = EntityLeafGolem.getConfig(this);
        if (cfg.getBoolean(ALLOW_SPECIAL) && this.func_70660_b(MobEffects.field_76428_l) == null && this.field_70146_Z.nextInt(40) == 0) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200 + 20 * (1 + this.field_70146_Z.nextInt(8)), 1));
        }
        if (this.field_70173_aa % 10 == 2 && this.field_70170_p.field_72995_K) {
            Biome biome = this.field_70170_p.func_180494_b(this.func_180425_c());
            long color = biome.func_180625_c(this.func_180425_c());
            this.setColor(color);
        }
        if (this.field_70181_x < -0.1) {
            this.field_70181_x *= 0.8;
        }
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187579_bV;
    }

    @Override
    public List<String> addSpecialDesc(List<String> list) {
        if (EntityLeafGolem.getConfig(this).getBoolean(ALLOW_SPECIAL)) {
            list.add(TextFormatting.DARK_GREEN + EntityLeafGolem.trans("effect.regeneration", new Object[0]) + " " + TextFormatting.DARK_GREEN + EntityLeafGolem.trans("enchantment.level.1", new Object[0]));
        }
        return list;
    }
}

