/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.entity.ai.EntityAIPlaceRandomBlocksStrictly;
import com.golems.util.GolemConfigSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public final class EntityNetherWartGolem
extends GolemBase {
    public static final Block NETHERWART = Blocks.field_189878_dg;
    public static final String ALLOW_SPECIAL = "Allow Special: Plant Netherwart";
    public static final String FREQUENCY = "Netherwart Frequency";
    public static final String ALLOW_HEALING = "Allow Special: Random Healing";

    public EntityNetherWartGolem(World world) {
        super(world);
        this.setCanSwim(true);
        this.setLootTableLoc("golem_nether_wart");
        this.addHealItem(new ItemStack(Items.field_151075_bm), 0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if ((!this.func_130014_f_().func_72935_r() || this.func_130014_f_().field_73011_w.func_177495_o()) && this.field_70146_Z.nextInt(450) == 0 && EntityNetherWartGolem.getConfig(this).getBoolean(ALLOW_HEALING)) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 20, 2));
        }
    }

    protected void func_184651_r() {
        super.func_184651_r();
        IBlockState[] flowers = new IBlockState[]{Blocks.field_150388_bm.func_176223_P().func_177226_a((IProperty)BlockNetherWart.field_176486_a, (Comparable)Integer.valueOf(0)), Blocks.field_150388_bm.func_176223_P().func_177226_a((IProperty)BlockNetherWart.field_176486_a, (Comparable)Integer.valueOf(1)), Blocks.field_150388_bm.func_176223_P().func_177226_a((IProperty)BlockNetherWart.field_176486_a, (Comparable)Integer.valueOf(2))};
        Block[] soils = new Block[]{Blocks.field_150425_aM};
        GolemConfigSet cfg = EntityNetherWartGolem.getConfig(this);
        boolean spawn = cfg.getBoolean(ALLOW_SPECIAL);
        int freq = cfg.getInt(FREQUENCY);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPlaceRandomBlocksStrictly((GolemBase)this, freq, flowers, soils, spawn));
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityNetherWartGolem.makeTexture("golems", "golem_nether_wart");
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187897_gY;
    }

    @Override
    public List<String> addSpecialDesc(List<String> list) {
        if (EntityNetherWartGolem.getConfig(this).getBoolean(ALLOW_SPECIAL)) {
            list.add(TextFormatting.RED + EntityNetherWartGolem.trans("entitytip.plants_warts", new Object[0]));
        }
        if (EntityNetherWartGolem.getConfig(this).getBoolean(ALLOW_HEALING)) {
            String sHeals = TextFormatting.RED + EntityNetherWartGolem.trans("entitytip.heals", new Object[0]);
            list.add(sHeals);
        }
        return list;
    }
}

