/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import java.util.List;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockStem;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public final class EntityStrawGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Crop Boost";
    public static final String SPECIAL_FREQ = "Crop Boost Frequency";
    private int range;
    private int boostFreq;
    private boolean allowed;

    public EntityStrawGolem(World world) {
        super(world);
        this.setCanSwim(true);
        this.addHealItem(new ItemStack(Items.field_151015_O), 0.25);
        this.addHealItem(new ItemStack(Items.field_151014_N), 0.025);
        this.setLootTableLoc("golem_straw");
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.boostFreq = EntityStrawGolem.getConfig(this).getInt(SPECIAL_FREQ);
        this.boostFreq += this.field_70146_Z.nextInt(Math.max(10, this.boostFreq / 2));
        this.range = 4;
        this.allowed = EntityStrawGolem.getConfig(this).getBoolean(ALLOW_SPECIAL);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.allowed && this.field_70146_Z.nextInt(this.boostFreq) == 0) {
            this.tryBoostCrop();
        }
    }

    private boolean tryBoostCrop() {
        int maxAttempts = 25;
        int variationY = 2;
        for (int attempts = 0; attempts <= 25; ++attempts) {
            IGrowable crop;
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            int y = MathHelper.func_76128_c((double)this.field_70163_u);
            int z = MathHelper.func_76128_c((double)this.field_70161_v);
            int x1 = this.field_70146_Z.nextInt(this.range * 2) - this.range;
            int y1 = this.field_70146_Z.nextInt(4) - 2;
            int z1 = this.field_70146_Z.nextInt(this.range * 2) - this.range;
            BlockPos blockpos = new BlockPos(x + x1, y + y1, z + z1);
            IBlockState state = this.func_130014_f_().func_180495_p(blockpos);
            if (!(state.func_177230_c() instanceof BlockCrops) && !(state.func_177230_c() instanceof BlockStem) || !(crop = (IGrowable)state.func_177230_c()).func_176473_a(this.field_70170_p, blockpos, state, this.field_70170_p.field_72995_K)) continue;
            crop.func_176474_b(this.field_70170_p, this.field_70146_Z, blockpos, state);
            if (this.field_70170_p.field_72995_K) {
                ItemDye.func_180617_a((World)this.field_70170_p, (BlockPos)blockpos, (int)0);
            }
            return true;
        }
        return false;
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityStrawGolem.makeTexture("golems", "golem_straw");
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187668_ca;
    }

    @Override
    public List<String> addSpecialDesc(List<String> list) {
        if (this.allowed) {
            String sCrops = TextFormatting.GREEN + EntityStrawGolem.trans("entitytip.grows_crops", new Object[0]);
            list.add(sCrops);
        }
        return list;
    }
}

