/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemColorized;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class GolemColorizedMultiTextured
extends GolemColorized {
    protected static final DataParameter<Byte> DATA_TEXTURE = EntityDataManager.func_187226_a(GolemColorizedMultiTextured.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final String NBT_TEXTURE = "GolemTextureData";
    protected final int[] colors;
    protected final ResourceLocation[] lootTables;

    public GolemColorizedMultiTextured(World world, @Nullable ResourceLocation base, @Nullable ResourceLocation overlay, int[] lColors) {
        super(world, 0L, base, overlay);
        this.colors = lColors;
        this.lootTables = new ResourceLocation[this.colors.length];
        int len = this.colors.length;
        for (int n = 0; n < len; ++n) {
            this.lootTables[n] = new ResourceLocation(this.getModId(), "entities/" + this.func_70022_Q().replaceAll(this.getModId() + ":", "") + "/" + n);
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (DATA_TEXTURE.equals(key)) {
            this.updateTextureByData(this.getTextureNum());
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_TEXTURE, (Object)0);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() || !this.doesInteractChangeTexture()) {
            return super.func_184645_a(player, hand);
        }
        int incremented = (this.getTextureNum() + 1) % this.colors.length;
        this.setTextureNum((byte)incremented);
        this.updateTextureByData(this.getTextureNum());
        this.func_70014_b(this.getEntityData());
        player.func_184609_a(hand);
        return true;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa == 2) {
            this.updateTextureByData(this.getTextureNum());
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a(NBT_TEXTURE, (byte)this.getTextureNum());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setTextureNum(nbt.func_74771_c(NBT_TEXTURE));
        this.updateTextureByData(this.getTextureNum());
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return this.lootTables[this.getTextureNum() % this.lootTables.length];
    }

    public void setTextureNum(byte toSet) {
        this.func_184212_Q().func_187227_b(DATA_TEXTURE, (Object)new Byte(toSet));
    }

    public int getTextureNum() {
        return ((Byte)this.func_184212_Q().func_187225_a(DATA_TEXTURE)).intValue();
    }

    public int[] getColorArray() {
        return this.colors;
    }

    protected void updateTextureByData(int data) {
        this.setColor(this.colors[data]);
    }

    public String getModId() {
        return "golems";
    }
}

