/*
 * Decompiled with CFR 0.152.
 */
package com.golems.events;

import com.golems.entity.GolemBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

@Event.HasResult
@Cancelable
public final class IceGolemFreezeEvent
extends Event {
    protected List<BlockPos> affectedBlocks;
    protected Function<IBlockState, IBlockState> freezeFunction;
    public final GolemBase iceGolem;
    public final BlockPos iceGolemPos;
    public static final int ICE_CHANCE = 52;
    public static final int COBBLE_CHANCE = 29;
    public int updateFlag;

    public IceGolemFreezeEvent(GolemBase golem, BlockPos center, int radius) {
        this.setResult(Event.Result.ALLOW);
        this.iceGolem = golem;
        this.iceGolemPos = center;
        this.updateFlag = 3;
        this.initAffectedBlockList(radius);
        this.setFunction(new DefaultFreezeFunction(golem.func_70681_au(), 52, 29));
    }

    public void initAffectedBlockList(int range) {
        this.affectedBlocks = new ArrayList<BlockPos>(range * range * 2 * 4);
        int maxDis = range * range;
        for (int i = -range; i <= range; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -range; k <= range; ++k) {
                    BlockPos currentPos = this.iceGolemPos.func_177982_a(i, j, k);
                    if (!(this.iceGolemPos.func_177951_i((Vec3i)currentPos) <= (double)maxDis)) continue;
                    this.affectedBlocks.add(currentPos);
                }
            }
        }
    }

    public Function<IBlockState, IBlockState> getFunction() {
        return this.freezeFunction;
    }

    public void setFunction(Function<IBlockState, IBlockState> toSet) {
        this.freezeFunction = toSet;
    }

    public List<BlockPos> getAffectedPositions() {
        return this.affectedBlocks;
    }

    public boolean add(BlockPos pos) {
        return this.affectedBlocks.add(pos);
    }

    public boolean remove(BlockPos toRemove) {
        return this.affectedBlocks.remove(toRemove);
    }

    public static class DefaultFreezeFunction
    implements Function<IBlockState, IBlockState> {
        public final Random random;
        public final int iceChance;
        public final int cobbleChance;

        public DefaultFreezeFunction(Random randomIn, int iceChanceIn, int cobbleChanceIn) {
            this.random = randomIn;
            this.iceChance = iceChanceIn;
            this.cobbleChance = cobbleChanceIn;
        }

        @Override
        public IBlockState apply(IBlockState input) {
            IBlockState cobbleState = Blocks.field_150347_e.func_176223_P();
            IBlockState iceState = Blocks.field_150432_aD.func_176223_P();
            Material material = input.func_185904_a();
            if (material.func_76224_d()) {
                Block block = input.func_177230_c();
                if (block == Blocks.field_150355_j) {
                    boolean isNotPacked = this.random.nextInt(100) < this.iceChance;
                    return isNotPacked ? iceState : Blocks.field_150403_cj.func_176223_P();
                }
                if (block == Blocks.field_150353_l) {
                    boolean isNotObsidian = this.random.nextInt(100) < this.cobbleChance;
                    return isNotObsidian ? cobbleState : Blocks.field_150343_Z.func_176223_P();
                }
                if (block == Blocks.field_150358_i) {
                    return iceState;
                }
                if (block == Blocks.field_150356_k) {
                    return cobbleState;
                }
            }
            return input;
        }
    }
}

