/*
 * Decompiled with CFR 0.152.
 */
package com.golems.events;

import com.golems.entity.GolemBase;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

@Event.HasResult
@Cancelable
public final class SpongeGolemSoakEvent
extends Event {
    protected List<BlockPos> affectedBlocks;
    protected Predicate<IBlockState> waterPredicate;
    public final GolemBase spongeGolem;
    public final BlockPos spongeGolemPos;
    public final int range;
    protected IBlockState replacesWater;
    public int updateFlag = 3;

    public SpongeGolemSoakEvent(GolemBase golem, BlockPos center, int radius) {
        this.setResult(Event.Result.ALLOW);
        this.spongeGolem = golem;
        this.spongeGolemPos = center;
        this.range = radius;
        this.setReplacementState(Blocks.field_150350_a.func_176223_P());
        this.setWaterPredicate(state -> state.func_185904_a() == Material.field_151586_h || state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i);
        this.initAffectedBlockList(radius);
    }

    public void initAffectedBlockList(int range) {
        this.affectedBlocks = new ArrayList<BlockPos>(range * range * range * 4);
        int MAX_DIS = range * range;
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                for (int k = -range; k <= range; ++k) {
                    IBlockState state;
                    BlockPos current = this.spongeGolemPos.func_177982_a(i, j, k);
                    if (!(this.spongeGolemPos.func_177951_i((Vec3i)current) <= (double)MAX_DIS) || !this.waterPredicate.test(state = this.spongeGolem.field_70170_p.func_180495_p(current))) continue;
                    this.affectedBlocks.add(current);
                }
            }
        }
    }

    public List<BlockPos> getPositionList() {
        return this.affectedBlocks;
    }

    public Predicate<IBlockState> getWaterPredicate() {
        return this.waterPredicate;
    }

    public void setWaterPredicate(Predicate<IBlockState> waterPred) {
        this.waterPredicate = waterPred;
    }

    public void setReplacementState(IBlockState toReplaceWater) {
        this.replacesWater = toReplaceWater;
    }

    public IBlockState getReplacementState() {
        return this.replacesWater;
    }

    public boolean removeBlockPos(BlockPos toRemove) {
        return this.affectedBlocks.remove(toRemove);
    }
}

