/*
 * Decompiled with CFR 0.152.
 */
package com.golems.main;

import com.golems.entity.EntityBedrockGolem;
import com.golems.entity.EntityBoneGolem;
import com.golems.entity.EntityBookshelfGolem;
import com.golems.entity.EntityClayGolem;
import com.golems.entity.EntityCoalGolem;
import com.golems.entity.EntityConcreteGolem;
import com.golems.entity.EntityCraftingGolem;
import com.golems.entity.EntityDiamondGolem;
import com.golems.entity.EntityDispenserGolem;
import com.golems.entity.EntityEmeraldGolem;
import com.golems.entity.EntityEndstoneGolem;
import com.golems.entity.EntityFurnaceGolem;
import com.golems.entity.EntityGlassGolem;
import com.golems.entity.EntityGlowstoneGolem;
import com.golems.entity.EntityGoldGolem;
import com.golems.entity.EntityHardenedClayGolem;
import com.golems.entity.EntityIceGolem;
import com.golems.entity.EntityLapisGolem;
import com.golems.entity.EntityLeafGolem;
import com.golems.entity.EntityMagmaGolem;
import com.golems.entity.EntityMelonGolem;
import com.golems.entity.EntityMushroomGolem;
import com.golems.entity.EntityNetherBrickGolem;
import com.golems.entity.EntityNetherWartGolem;
import com.golems.entity.EntityObsidianGolem;
import com.golems.entity.EntityPrismarineGolem;
import com.golems.entity.EntityQuartzGolem;
import com.golems.entity.EntityRedSandstoneGolem;
import com.golems.entity.EntityRedstoneGolem;
import com.golems.entity.EntityRedstoneLampGolem;
import com.golems.entity.EntitySandstoneGolem;
import com.golems.entity.EntitySeaLanternGolem;
import com.golems.entity.EntitySlimeGolem;
import com.golems.entity.EntitySpongeGolem;
import com.golems.entity.EntityStainedClayGolem;
import com.golems.entity.EntityStainedGlassGolem;
import com.golems.entity.EntityStrawGolem;
import com.golems.entity.EntityTNTGolem;
import com.golems.entity.EntityWoodenGolem;
import com.golems.entity.EntityWoolGolem;
import com.golems.entity.GolemBase;
import com.golems.main.ExtraGolems;
import com.golems.util.GolemConfigSet;
import com.golems.util.GolemLookup;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class Config {
    public static final String CATEGORY_OTHER = "_other_";
    private static boolean pumpkinBuildsGolem;
    private static boolean bedrockGolemCreativeOnly;
    private static boolean useOreDictName;
    private static boolean enableInteractTexture;
    private static boolean enableFriendlyFire;
    private static boolean enableHealGolems;
    private static int villageGolemSpawnChance;
    private static String[] villageGolemSpawnsDesert;
    private static String[] villageGolemSpawnsPlains;
    private static final List<Class<? extends GolemBase>> desertGolems;
    private static final List<Class<? extends GolemBase>> plainsGolems;
    public static final int RANDOM_HEAL_TIMER = 450;
    public static final Set<String> SECRET;

    private Config() {
    }

    public static void mainRegistry(Configuration config) {
        config.load();
        GolemConfigSet.EMPTY = new GolemConfigSet(config, "test", false, 0.0, 0.0f);
        Config.initGolemConfigSets(config);
        Config.loadOther(config);
        config.save();
        SECRET.add(Config.decode(new int[]{127, 119, 133, 118, 109, 133, 61}));
    }

    private static void initGolemConfigSets(Configuration config) {
        int randomHealSec = 22;
        GolemLookup.addConfig(EntityBedrockGolem.class, new GolemConfigSet(config, "Bedrock Golem", 999.0, 32.0f));
        GolemLookup.addConfig(EntityBoneGolem.class, new GolemConfigSet(config, "Bone Golem", 54.0, 9.5f));
        GolemLookup.addConfig(EntityBookshelfGolem.class, new GolemConfigSet(config, "Bookshelf Golem", 28.0, 1.5f).addKey("Allow Special: Potion Effects", true, "Whether this golem can give itself potion effects"));
        GolemLookup.addConfig(EntityClayGolem.class, new GolemConfigSet(config, "Clay Golem", 20.0, 2.0f));
        GolemLookup.addConfig(EntityCoalGolem.class, new GolemConfigSet(config, "Coal Golem", 14.0, 2.5f).addKey("Allow Special: Blindness", false, "Whether this golem can inflict blindness"));
        GolemLookup.addConfig(EntityConcreteGolem.class, new GolemConfigSet(config, "Concrete Golem", 38.0, 6.0f).addKey("Allow Special: Resistance", true, "Whether this golem reduces damage it takes"));
        GolemLookup.addConfig(EntityCraftingGolem.class, new GolemConfigSet(config, "Crafting Golem", 24.0, 2.0f).addKey("Allow Special: Crafting", true, "Whether this golem can open a crafting grid"));
        GolemLookup.addConfig(EntityDiamondGolem.class, new GolemConfigSet(config, "Diamond Golem", 220.0, 20.0f));
        GolemLookup.addConfig(EntityDispenserGolem.class, new GolemConfigSet(config, "Dispenser Golem", 78.0, 5.2f).addKey("Allow Special: Shoot Arrows", true, "Whether the golem can shoot arrows").addKey("Arrow Damage", 4.25f, 0.0f, 50.0f, "Base amount of damage dealt per arrow").addKey("Arrow Speed", 30, 1, 12000, "Number of ticks between shooting arrows"));
        GolemLookup.addConfig(EntityEmeraldGolem.class, new GolemConfigSet(config, "Emerald Golem", 190.0, 18.0f));
        GolemLookup.addConfig(EntityEndstoneGolem.class, new GolemConfigSet(config, "Endstone Golem", 50.0, 8.0f).addKey("Allow Special: Teleporting", true, "Whether this golem can teleport").addKey("Can Take Water Damage", true, "Whether the Endstone Golem takes damage from water"));
        GolemLookup.addConfig(EntityFurnaceGolem.class, new GolemConfigSet(config, "Furnace Golem", 88.0, 6.5f).addKey("Burn Time", 8, 1, 24000, "Higher values make fuel last longer"));
        GolemLookup.addConfig(EntityGlassGolem.class, new GolemConfigSet(config, "Glass Golem", 8.0, 13.0f));
        GolemLookup.addConfig(EntityGlowstoneGolem.class, new GolemConfigSet(config, "Glowstone Golem", 8.0, 12.0f).addKey("Allow Special: Emit Light", true, "Whether this golem can light the area").addKey("Light Frequency", 2, 1, 24000, "Number of ticks between updating light"));
        GolemLookup.addConfig(EntityGoldGolem.class, new GolemConfigSet(config, "Gold Golem", 80.0, 8.0f));
        GolemLookup.addConfig(EntityHardenedClayGolem.class, new GolemConfigSet(config, "Hardened Clay Golem", 22.0, 4.0f));
        GolemLookup.addConfig(EntityIceGolem.class, new GolemConfigSet(config, "Ice Golem", 18.0, 6.0f).addKey("Allow Special: Freeze Blocks", true, "Whether this golem can freeze water and cool lava nearby").addKey("Can Use Regular Ice", true, "When true, the Ice Golem can be built with regular ice as well as packed ice").addKey("Area of Effect", 3, 1, 8, "Radial distance at which this golem can freeze / cool liquids"));
        GolemLookup.addConfig(EntityLapisGolem.class, new GolemConfigSet(config, "Lapis Lazuli Golem", 50.0, 1.5f).addKey("Allow Special: Potion Effects", true, "Whether this golem can inflict harmful potion effects"));
        GolemLookup.addConfig(EntityLeafGolem.class, new GolemConfigSet(config, "Leaf Golem", 6.0, 0.5f).addKey("Allow Special: Regeneration", true, "Whether this golem can heal itself"));
        GolemLookup.addConfig(EntityMagmaGolem.class, new GolemConfigSet(config, "Magma Golem", 46.0, 4.5f).addKey("Allow Special: Split", true, "When true, this golem will split into 2 mini-golems upon death").addKey("Allow Special: Melt Cobblestone", false, "Whether this golem can slowly melt cobblestone").addKey("Melting Delay", 240, 1, 24000, "Number of ticks it takes to melt cobblestone if enabled (12 sec * 20 t/sec = 240 t)").addKey("Allow Special: Burn Enemies", true, "Whether this golem can light creatures on fire").addKey("Enable Water Damage", true, "When true, water will hurt this golem"));
        GolemLookup.addConfig(EntityMelonGolem.class, new GolemConfigSet(config, "Melon Golem", 18.0, 1.5f).addKey("Allow Special: Random Healing", true, "Whether this golem can randomly heal (about every " + randomHealSec + " sec)").addKey("Allow Special: Plant Flowers", true, "Whether this golem can plant flowers randomly").addKey("Flower Frequency", 240, 1, 24000, "Average number of ticks between planting flowers"));
        GolemLookup.addConfig(EntityMushroomGolem.class, new GolemConfigSet(config, "Mushroom Golem", 30.0, 3.0f).addKey("Allow Special: Random Healing", true, "Whether this golem can randomly heal at night (about every " + randomHealSec + " sec)").addKey("Allow Special: Plant Mushrooms", true, "Whether this golem can plant mushrooms randomly").addKey("Mushroom Frequency", 420, 1, 24000, "Average number of ticks between planting mushrooms"));
        GolemLookup.addConfig(EntityNetherBrickGolem.class, new GolemConfigSet(config, "Nether Brick Golem", 25.0, 6.5f).addKey("Allow Special: Burn Enemies", true, "Whether this golem can light creatures on fire"));
        GolemLookup.addConfig(EntityNetherWartGolem.class, new GolemConfigSet(config, "Nether Wart Golem", 22.0, 1.5f).addKey("Allow Special: Random Healing", true, "Whether this golem can randomly heal at night (about every " + randomHealSec + " sec)").addKey("Allow Special: Plant Netherwart", true, "Whether this golem can plant netherwart randomly").addKey("Netherwart Frequency", 880, 1, 24000, "Average number of ticks between planting nether wart if enabled"));
        GolemLookup.addConfig(EntityObsidianGolem.class, new GolemConfigSet(config, "Obsidian Golem", 120.0, 18.0f));
        GolemLookup.addConfig(EntityPrismarineGolem.class, new GolemConfigSet(config, "Prismarine Golem", 24.0, 8.0f));
        GolemLookup.addConfig(EntityQuartzGolem.class, new GolemConfigSet(config, "Quartz Golem", 85.0, 8.5f));
        GolemLookup.addConfig(EntityRedSandstoneGolem.class, new GolemConfigSet(config, "Red Sandstone Golem", 15.0, 4.0f));
        GolemLookup.addConfig(EntityRedstoneGolem.class, new GolemConfigSet(config, "Redstone Golem", 18.0, 2.0f).addKey("Allow Special: Redstone Power", true, "Whether this golem can emit redstone power"));
        GolemLookup.addConfig(EntityRedstoneLampGolem.class, new GolemConfigSet(config, "Redstone Lamp Golem", 28.0, 6.0f).addKey("Allow Special: Emit Light", true, "Whether this golem can light up the area").addKey("Light Frequency", 2, 1, 24000, "Number of ticks between updating light"));
        GolemLookup.addConfig(EntitySandstoneGolem.class, new GolemConfigSet(config, "Sandstone Golem", 15.0, 4.0f));
        GolemLookup.addConfig(EntitySeaLanternGolem.class, new GolemConfigSet(config, "Sea Lantern Golem", 24.0, 6.0f).addKey("Allow Special: Emit Light", true, "Whether this golem lights up the area").addKey("Light Frequency", 5, 1, 24000, "Number of ticks between updating light"));
        GolemLookup.addConfig(EntitySlimeGolem.class, new GolemConfigSet(config, "Slime Golem", 58.0, 2.5f).addKey("Allow Special: Split", true, "When true, this golem will split into 2 mini-golems upon death").addKey("Allow Special: Extra Knockback", true, "Whether this golem can apply extra knockback when attacking").addKey("Knockback Factor", 1.9412f, 0.001f, 10.0f, "How powerful the Slime Golem knockback is (Higher Value = Further Knockback)"));
        GolemLookup.addConfig(EntitySpongeGolem.class, new GolemConfigSet(config, "Sponge Golem", 20.0, 1.5f).addKey("Allow Special: Absorb Water", true, "Whether this golem can absorb water").addKey("Can Render Sponge Particles", true, "Whether this golem should always drip water").addKey("Water Soaking Range", 4, 2, 8, "Radial distance at which this golem can absorb water (Warning: larger values cause lag)").addKey("Water Soaking Frequency", 20, 1, 24000, "Number of ticks between each water-check; increase to reduce lag"));
        GolemLookup.addConfig(EntityStainedClayGolem.class, new GolemConfigSet(config, "Stained Clay Golem", 26.0, 3.0f));
        GolemLookup.addConfig(EntityStainedGlassGolem.class, new GolemConfigSet(config, "Stained Glass Golem", 9.0, 12.0f));
        GolemLookup.addConfig(EntityStrawGolem.class, new GolemConfigSet(config, "Straw Golem", 10.0, 1.0f).addKey("Allow Special: Crop Boost", true, "Whether this golem can speed up crop growth").addKey("Crop Boost Frequency", 460, 1, 24000, "Minimum number of ticks between crop-boosts"));
        GolemLookup.addConfig(EntityTNTGolem.class, new GolemConfigSet(config, "TNT Golem", 14.0, 2.5f).addKey("Allow Special: Explode", true, "Whether this golem can explode when fighting or dying"));
        GolemLookup.addConfig(EntityWoodenGolem.class, new GolemConfigSet(config, "Wooden Golem", 20.0, 3.0f));
        GolemLookup.addConfig(EntityWoolGolem.class, new GolemConfigSet(config, "Wool Golem", 10.0, 1.0f));
    }

    private static void loadOther(Configuration config) {
        enableHealGolems = config.getBoolean("Heal Golems", CATEGORY_OTHER, true, "When enabled, giving blocks to golems can restore health");
        enableFriendlyFire = config.getBoolean("Friendly Fire", CATEGORY_OTHER, true, "When false, attacking a player-built golem will not make it attack you");
        bedrockGolemCreativeOnly = config.getBoolean("Bedrock Golem Creative Only", CATEGORY_OTHER, true, "When true, only players in creative mode can use a Bedrock Golem spawn item");
        pumpkinBuildsGolem = config.getBoolean("Pumpkin Builds Golems", CATEGORY_OTHER, false, "(Experimental) When true, pumpkins can be used to build this mod's golems");
        useOreDictName = config.getBoolean("Use OreDict Blocks", CATEGORY_OTHER, true, "When true, building a golem will work with any OreDictionary-registered blocks");
        enableInteractTexture = config.getBoolean("Interact Changes Texture", CATEGORY_OTHER, false, "When true, some golems will change their texture when right clicked");
        villageGolemSpawnsDesert = config.getStringList("Desert Village Golem Spawns", CATEGORY_OTHER, villageGolemSpawnsDesert, "The following golems will appear in villages in Desert biomes. (Duplicate entries increase chances)");
        villageGolemSpawnsPlains = config.getStringList("Plains Village Golem Spawns", CATEGORY_OTHER, villageGolemSpawnsPlains, "The following golems will appear in villages in Plains biomes. (Duplicate entries increase chances)");
        villageGolemSpawnChance = config.getInt("Village Golem Spawn Chance", CATEGORY_OTHER, 60, 0, 100, "Percent chance for each village chunk to include an Extra Golems golem. Set to 0 to disable");
    }

    public static boolean doesPumpkinBuildGolem() {
        return pumpkinBuildsGolem;
    }

    public static boolean isBedrockGolemCreativeOnly() {
        return bedrockGolemCreativeOnly;
    }

    public static int getVillageGolemSpawnChance() {
        return villageGolemSpawnChance;
    }

    public static boolean getUseOreDictBlocks() {
        return useOreDictName;
    }

    public static boolean interactChangesTexture() {
        return enableInteractTexture;
    }

    public static boolean enableFriendlyFire() {
        return enableFriendlyFire;
    }

    public static boolean enableHealGolems() {
        return enableHealGolems;
    }

    public static List<Class<? extends GolemBase>> getDesertGolems() {
        if (desertGolems.isEmpty()) {
            for (String s : villageGolemSpawnsDesert) {
                ResourceLocation name = new ResourceLocation("golems", s);
                EntityEntry entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(name);
                if (entityEntry != null && GolemBase.class.isAssignableFrom(entityEntry.getEntityClass())) {
                    desertGolems.add(entityEntry.getEntityClass());
                    continue;
                }
                ExtraGolems.LOGGER.error("Tried to parse an unknown entity from the config! Skipping '" + s + "' in \"Desert Village Golem Spawns\"");
            }
        }
        return desertGolems;
    }

    public static List<Class<? extends GolemBase>> getPlainsGolems() {
        if (plainsGolems.isEmpty()) {
            for (String s : villageGolemSpawnsPlains) {
                ResourceLocation name = new ResourceLocation("golems", s);
                EntityEntry entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(name);
                if (entityEntry != null && GolemBase.class.isAssignableFrom(entityEntry.getEntityClass())) {
                    plainsGolems.add(entityEntry.getEntityClass());
                    continue;
                }
                ExtraGolems.LOGGER.error("Tried to parse an unknown entity from the config! Skipping '" + s + "' in \"Plains Village Golem Spawns\"");
            }
        }
        return plainsGolems;
    }

    public static boolean matchesSecret(String in) {
        return in != null && in.length() > 0 && SECRET.contains(in);
    }

    private static String decode(int[] iarray) {
        StringBuilder stringOut = new StringBuilder();
        for (int i : iarray) {
            int i2 = i - (Integer.parseInt(Character.toString('A'), 16) / 2 + (int)Math.floor(7.295551570330887));
            char c = (char)i2;
            stringOut.append(c);
        }
        return stringOut.toString();
    }

    static {
        villageGolemSpawnsDesert = new String[]{"golem_straw", "golem_sandstone", "golem_sandstone", "golem_sandstone", "golem_red_sandstone", "golem_bone", "golem_hardened_clay", "golem_end_stone"};
        villageGolemSpawnsPlains = new String[]{"golem_wooden", "golem_straw", "golem_melon", "golem_shroom", "golem_leaves", "golem_wool"};
        desertGolems = new ArrayList<Class<? extends GolemBase>>();
        plainsGolems = new ArrayList<Class<? extends GolemBase>>();
        SECRET = new HashSet<String>();
    }
}

