/*
 * Decompiled with CFR 0.152.
 */
package com.golems.util;

import com.golems.main.ExtraGolems;
import gnu.trove.map.TObjectByteMap;
import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectByteHashMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import net.minecraftforge.common.config.Configuration;

public class GolemConfigSet {
    public static GolemConfigSet EMPTY;
    private static final String GOLEM_PERMS = "Allow Golem";
    private static final String GOLEM_HEALTH = "Golem Health";
    private static final String GOLEM_ATTACK = "Golem Attack";
    private static final String DEFAULTING_TO = "' - defaulting to ";
    private static final String IN_GOLEM_CONFIG_SET = "' in GolemConfigSet '";
    private Configuration config;
    private String golemName;
    private String category;
    private final TObjectIntMap<String> mapInt = new TObjectIntHashMap(1);
    private final TObjectFloatMap<String> mapFloat = new TObjectFloatHashMap(1);
    private final TObjectByteMap<String> mapBoolean = new TObjectByteHashMap(1);
    private boolean canSpawn;
    private double maxHealth;
    private float baseAttack;
    private final boolean defSpawn;
    private final double defHealth;
    private final float defAttack;
    private static final int DEF_INT = 0;
    private static final float DEF_FLOAT = 0.0f;
    private static final boolean DEF_BOOL = false;
    private static final byte TRUE = 1;
    private static final byte FALSE = 0;

    public GolemConfigSet(Configuration configFile, String name, boolean spawn, double health, float attack) {
        this.config = configFile;
        this.golemName = name;
        this.category = this.golemName.toLowerCase().replace(' ', '_');
        this.defSpawn = spawn;
        this.defHealth = health;
        this.defAttack = attack;
        this.loadFromConfig();
    }

    public GolemConfigSet(Configuration configFile, String name, double health, float attack) {
        this(configFile, name, true, health, attack);
    }

    public GolemConfigSet loadFromConfig() {
        this.canSpawn = this.config.getBoolean(GOLEM_PERMS, this.category, this.defSpawn, "Whether the " + this.golemName + " can be built");
        this.maxHealth = this.config.getFloat(GOLEM_HEALTH, this.category, (float)this.defHealth, 0.0f, 999.0f, "Max health for this golem");
        this.baseAttack = this.config.getFloat(GOLEM_ATTACK, this.category, this.defAttack, 0.0f, 300.0f, "Base attack damage dealt by this golem");
        return this;
    }

    public GolemConfigSet addKey(String key, int defaultValue, int min, int max, String comment) {
        int value = this.config.getInt(key, this.category, defaultValue, min, max, comment);
        this.mapInt.put((Object)key, value);
        return this;
    }

    public GolemConfigSet addKey(String key, float defaultValue, float min, float max, String comment) {
        float value = this.config.getFloat(key, this.category, defaultValue, min, max, comment);
        this.mapFloat.put((Object)key, value);
        return this;
    }

    public GolemConfigSet addKey(String key, boolean defaultValue, String comment) {
        boolean value = this.config.getBoolean(key, this.category, defaultValue, comment);
        this.mapBoolean.put((Object)key, value ? (byte)1 : 0);
        return this;
    }

    public int getInt(String key) {
        if (this.mapInt.containsKey((Object)key)) {
            return this.mapInt.get((Object)key);
        }
        String error = "Did not find an int value matching '" + key + IN_GOLEM_CONFIG_SET + this.golemName + DEFAULTING_TO + 0;
        ExtraGolems.LOGGER.error(error);
        this.mapInt.put((Object)key, 0);
        return 0;
    }

    public float getFloat(String key) {
        if (this.mapFloat.containsKey((Object)key)) {
            return this.mapFloat.get((Object)key);
        }
        String error = "Did not find a float value matching '" + key + IN_GOLEM_CONFIG_SET + this.golemName + DEFAULTING_TO + 0.0f;
        ExtraGolems.LOGGER.error(error);
        this.mapFloat.put((Object)key, 0.0f);
        return 0.0f;
    }

    public boolean getBoolean(String key) {
        if (this.mapBoolean.containsKey((Object)key)) {
            return this.mapBoolean.get((Object)key) == 1;
        }
        String error = "Did not find a boolean value matching '" + key + IN_GOLEM_CONFIG_SET + this.golemName + DEFAULTING_TO + false;
        ExtraGolems.LOGGER.error(error);
        this.mapFloat.put((Object)key, 0.0f);
        return false;
    }

    public boolean canSpawn() {
        return this.canSpawn;
    }

    public double getMaxHealth() {
        return this.maxHealth;
    }

    public float getBaseAttack() {
        return this.baseAttack;
    }

    public Configuration getConfig() {
        return this.config;
    }
}

