/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.blocks;

import com.mcmoddev.golems.blocks.BlockUtility;
import com.mcmoddev.golems.entity.base.GolemBase;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockUtilityGlow
extends BlockUtility {
    public static final IntegerProperty LIGHT_LEVEL = IntegerProperty.func_177719_a((String)"light", (int)0, (int)15);
    public static final int UPDATE_TICKS = 6;

    public BlockUtilityGlow(Material m, float defaultLight, int tickRate) {
        super(Block.Properties.func_200945_a((Material)m).func_200944_c().func_200951_a((int)(defaultLight * 15.0f)), tickRate);
        int light = (int)(defaultLight * 15.0f);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)LIGHT_LEVEL, (Comparable)Integer.valueOf(light)));
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        boolean hasLightGolem;
        AxisAlignedBB toCheck = new AxisAlignedBB(pos).func_186662_g(0.5);
        List list = worldIn.func_217357_a(GolemBase.class, toCheck);
        boolean bl = hasLightGolem = !list.isEmpty() && BlockUtilityGlow.hasLightGolem(list);
        if (hasLightGolem) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), this.func_149738_a((IWorldReader)worldIn));
        } else {
            this.remove(worldIn, state, pos, 3);
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{LIGHT_LEVEL});
    }

    public int func_149750_m(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)LIGHT_LEVEL);
    }

    public static boolean hasLightGolem(List<GolemBase> golems) {
        for (GolemBase g : golems) {
            if (!g.isProvidingLight()) continue;
            return true;
        }
        return false;
    }
}

