/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemMultiTextured;
import com.mcmoddev.golems.items.ItemBedrockGolem;
import com.mcmoddev.golems.util.GolemTextureBytes;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CoralBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public final class CoralGolem
extends GolemMultiTextured {
    private static final DataParameter<Boolean> DRY = EntityDataManager.func_187226_a(CoralGolem.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final String KEY_DRY = "isDry";
    public static final String ALLOW_HEALING = "Allow Special: Healing";
    public static final String DRY_TIMER = "Max Wet Time";
    public static final String[] VARIANTS = new String[]{"tube", "brain", "bubble", "fire", "horn"};
    public final ResourceLocation[] texturesDry = new ResourceLocation[VARIANTS.length];
    private final boolean allowHealing;
    private final int maxChangingTime;
    private int timeChanging = 0;

    public CoralGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world, "golems", VARIANTS);
        int len = VARIANTS.length;
        for (int n = 0; n < len; ++n) {
            this.texturesDry[n] = CoralGolem.makeTexture("golems", this.getGolemContainer().getName() + "/" + VARIANTS[n] + "_dead");
        }
        this.allowHealing = this.getConfigBool(ALLOW_HEALING);
        this.maxChangingTime = this.getConfigInt(DRY_TIMER);
    }

    public boolean isDry() {
        return (Boolean)this.func_184212_Q().func_187225_a(DRY);
    }

    public void setDry(boolean isDry) {
        if ((Boolean)this.func_184212_Q().func_187225_a(DRY) != isDry) {
            this.func_184212_Q().func_187227_b(DRY, (Object)isDry);
        }
    }

    protected void func_70665_d(DamageSource source, float amount) {
        if (this.isDry()) {
            amount *= 0.7f;
        }
        super.func_70665_d(source, amount);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DRY, (Object)false);
    }

    public void func_70636_d() {
        boolean isChanging;
        super.func_70636_d();
        boolean bl = isChanging = this.func_203005_aq() == this.isDry();
        if (isChanging) {
            if (!this.field_70170_p.field_72995_K && ++this.timeChanging > this.maxChangingTime) {
                this.setDry(!this.func_203005_aq());
                this.timeChanging = 0;
            }
        } else {
            this.timeChanging = 0;
        }
        if (!this.isDry()) {
            if (this.func_70026_G() && this.timeChanging > 0 && this.field_70146_Z.nextInt(3) == 0) {
                --this.timeChanging;
            }
            if (this.allowHealing && this.field_70146_Z.nextInt(650) == 0) {
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, 50, 1));
            }
        }
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (DRY.equals(key)) {
            this.setDry((Boolean)this.func_184212_Q().func_187225_a(DRY));
            if (this.isDry()) {
                double dryHealth = Math.floor(this.getGolemContainer().getHealth() * 0.7 * 10.0) / 10.0;
                double dryAttack = Math.floor(this.getGolemContainer().getAttack() * 1.45 * 10.0) / 10.0;
                double drySpeed = Math.floor(this.getGolemContainer().getSpeed() * 0.7 * 100.0) / 100.0;
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(dryHealth);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(dryAttack);
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(drySpeed);
                ItemBedrockGolem.spawnParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.1, this.field_70161_v, 0.15, (IParticleData)ParticleTypes.field_197601_L, 80);
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getGolemContainer().getHealth());
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getGolemContainer().getAttack());
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getGolemContainer().getSpeed());
            }
        }
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a(KEY_DRY, this.isDry());
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setDry(nbt.func_74767_n(KEY_DRY));
    }

    @Override
    public ResourceLocation[] getTextureArray() {
        return this.isDry() ? this.texturesDry : this.textures;
    }

    @Override
    public void onBuilt(BlockState body, BlockState legs, BlockState arm1, BlockState arm2) {
        this.setDry(!(body.func_177230_c() instanceof CoralBlock));
        super.onBuilt(body, legs, arm1, arm2);
    }

    @Override
    public ItemStack getCreativeReturn(RayTraceResult target) {
        return new ItemStack((IItemProvider)GolemTextureBytes.getByByte(this.isDry() ? GolemTextureBytes.CORAL_DEAD : GolemTextureBytes.CORAL, (byte)this.getTextureNum()));
    }

    @Override
    public boolean shouldMoveToWater(Vec3d target) {
        double dis;
        return this.isDry() || !((dis = this.func_213303_ch().func_72438_d(target)) < 8.0) || this.getTimeUntilChange() <= 60;
    }

    @Override
    public Map<Block, Byte> getTextureBytes() {
        return this.isDry() ? GolemTextureBytes.CORAL_DEAD : GolemTextureBytes.CORAL;
    }

    public int getTimeUntilChange() {
        return this.maxChangingTime - this.timeChanging;
    }
}

