/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.container.ContainerDispenserGolem;
import com.mcmoddev.golems.entity.base.GolemBase;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public final class DispenserGolem
extends GolemBase
implements IRangedAttackMob,
IInventoryChangedListener {
    public static final String ALLOW_SPECIAL = "Allow Special: Shoot Arrows";
    public static final String ARROW_DAMAGE = "Arrow Damage";
    public static final String ARROW_SPEED = "Arrow Speed";
    private static final String KEY_INVENTORY = "Items";
    private static final String KEY_SLOT = "Slot";
    private static final int INVENTORY_SIZE = 9;
    private boolean allowArrows = this.getConfigBool("Allow Special: Shoot Arrows");
    private double arrowDamage = Math.max(0.0, this.getConfigDouble("Arrow Damage"));
    private int arrowSpeed = this.getConfigInt("Arrow Speed");
    private Inventory inventory;
    private final RangedAttackGoal aiArrowAttack = new RangedAttackGoal((IRangedAttackMob)this, 1.0, this.arrowSpeed, 32.0f);
    private final MeleeAttackGoal aiMeleeAttack = new MeleeAttackGoal((CreatureEntity)this, 1.0, true);

    public DispenserGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world);
        this.initInventory();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
    }

    protected void func_82167_n(Entity entityIn) {
        super.func_82167_n(entityIn);
        this.updateCombatTask(entityIn != null && this.func_70638_az() != null && entityIn == this.func_70638_az());
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 50 == 0) {
            boolean forceMelee = !this.allowArrows || this.func_70638_az() != null && this.func_70638_az().func_70068_e((Entity)this) < 4.5;
            this.updateCombatTask(forceMelee);
        }
        int frequency = 24;
        double range = 0.8;
        boolean gameRule = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b);
        if (this.func_70613_aW() && gameRule && this.field_70146_Z.nextInt(24) == 0) {
            List itemList = this.field_70170_p.func_175647_a(ItemEntity.class, this.func_174813_aQ().func_72314_b(0.8, 0.0, 0.8), i -> i != null && !i.func_92059_d().func_190926_b() && !i.func_174874_s() && i.func_92059_d().func_77973_b() instanceof ArrowItem);
            for (ItemEntity i2 : itemList) {
                ItemStack item = i2.func_92059_d().func_77946_l();
                i2.func_92058_a(this.inventory.func_174894_a(item));
            }
        }
    }

    @Override
    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (!player.func_70093_af() && player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerDispenserGolem.Provider((IInventory)this.inventory));
            player.func_184609_a(hand);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70097_a(DamageSource src, float amnt) {
        if (super.func_70097_a(src, amnt)) {
            if (src instanceof IndirectEntityDamageSource && src.func_76346_g() instanceof LivingEntity) {
                this.func_70604_c((LivingEntity)src.func_76346_g());
            }
            return true;
        }
        return false;
    }

    public void func_213337_cE() {
        int l = this.inventory.func_70302_i_();
        for (int i = 0; i < l; ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            this.func_199701_a_(stack.func_77946_l());
            this.inventory.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    @Override
    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        ListNBT list = tag.func_150295_c(KEY_INVENTORY, 10);
        this.initInventory();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT slotNBT = list.func_150305_b(i);
            int slotNum = slotNBT.func_74771_c(KEY_SLOT) & 0xFF;
            if (slotNum < 0 || slotNum >= this.inventory.func_70302_i_()) continue;
            this.inventory.func_70299_a(slotNum, ItemStack.func_199557_a((CompoundNBT)slotNBT));
        }
        this.func_76316_a((IInventory)this.inventory);
    }

    @Override
    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        ListNBT listNBT = new ListNBT();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            CompoundNBT slotNBT = new CompoundNBT();
            slotNBT.func_74774_a(KEY_SLOT, (byte)i);
            stack.func_77955_b(slotNBT);
            listNBT.add((Object)slotNBT);
        }
        tag.func_218657_a(KEY_INVENTORY, (INBT)listNBT);
    }

    private void initInventory() {
        Inventory inv = this.inventory;
        this.inventory = new Inventory(9);
        if (inv != null) {
            inv.func_110132_b((IInventoryChangedListener)this);
            int i = Math.min(inv.func_70302_i_(), this.inventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inv.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.inventory.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.inventory.func_110134_a((IInventoryChangedListener)this);
        this.func_76316_a((IInventory)this.inventory);
    }

    public void func_76316_a(IInventory inv) {
        if (this.func_70613_aW()) {
            this.updateCombatTask();
        }
    }

    private static ItemStack findArrows(IInventory inv) {
        int l = inv.func_70302_i_();
        for (int i = 0; i < l; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ArrowItem)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        ItemStack itemstack = DispenserGolem.findArrows((IInventory)this.inventory);
        if (!itemstack.func_190926_b()) {
            AbstractArrowEntity arrow = ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor);
            arrow.field_70163_u = this.field_70163_u + (double)(this.func_213302_cg() * 0.6f);
            double d0 = target.field_70165_t - this.field_70165_t;
            double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - arrow.field_70163_u;
            double d2 = target.field_70161_v - this.field_70161_v;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            arrow.func_212361_a((Entity)this);
            arrow.func_70239_b(this.arrowDamage + this.field_70146_Z.nextDouble() * 0.5);
            arrow.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
            arrow.func_70186_c(d0, d1 + d3 * 0.2, d2, 1.6f, 1.2f);
            this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70170_p.func_217376_c((Entity)arrow);
            itemstack.func_190918_g(1);
            this.func_76316_a((IInventory)this.inventory);
        }
    }

    public void updateCombatTask() {
        this.updateCombatTask(!this.allowArrows);
    }

    public void updateCombatTask(boolean forceMelee) {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((Goal)this.aiMeleeAttack);
            this.field_70714_bg.func_85156_a((Goal)this.aiArrowAttack);
            ItemStack ammo = DispenserGolem.findArrows((IInventory)this.inventory);
            if (forceMelee || ammo.func_190926_b()) {
                this.field_70714_bg.func_75776_a(0, (Goal)this.aiMeleeAttack);
            } else {
                this.field_70714_bg.func_75776_a(0, (Goal)this.aiArrowAttack);
            }
        }
    }
}

