/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.items.ItemBedrockGolem;
import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public final class FurnaceGolem
extends GolemBase {
    private static final DataParameter<Integer> FUEL = EntityDataManager.func_187226_a(FurnaceGolem.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final String KEY_FUEL = "FuelRemaining";
    private static final ResourceLocation LIT = FurnaceGolem.makeTexture("golem_furnace/lit");
    private static final ResourceLocation UNLIT = FurnaceGolem.makeTexture("golem_furnace/unlit");
    public static final String FUEL_FACTOR = "Burn Time";
    public static final int MAX_FUEL = 102400;
    public final int fuelBurnFactor = Math.max(1, this.getConfigInt("Burn Time"));
    protected boolean inertLastTick = false;

    public FurnaceGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(FUEL, (Object)0);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new InertGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new UseFuelGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new TemptGoal((CreatureEntity)this, 0.7, Ingredient.func_199805_a((Tag)ItemTags.field_219775_L), false));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(10) == 0) {
            double pMotion = 0.03;
            this.field_70170_p.func_195594_a((IParticleData)(this.hasFuel() ? ParticleTypes.field_197631_x : ParticleTypes.field_197601_L), this.field_70165_t + this.field_70170_p.field_73012_v.nextDouble() * 0.4 - 0.2 + this.func_213322_ci().func_82615_a() * 8.0, this.field_70163_u + this.field_70170_p.field_73012_v.nextDouble() * 0.5 + (double)this.func_213302_cg() / 2.0, this.field_70161_v + this.field_70170_p.field_73012_v.nextDouble() * 0.4 - 0.2 + this.func_213322_ci().func_82616_c() * 8.0, this.field_70170_p.field_73012_v.nextGaussian() * 0.03, this.field_70170_p.field_73012_v.nextDouble() * 0.03, this.field_70170_p.field_73012_v.nextGaussian() * 0.03);
        }
        if (!this.inertLastTick && !this.hasFuel()) {
            this.inertLastTick = true;
        }
    }

    @Override
    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.setFuel(tag.func_74762_e(KEY_FUEL));
    }

    @Override
    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74768_a(KEY_FUEL, this.getFuel());
    }

    @Override
    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int burnTime = ForgeHooks.getBurnTime((ItemStack)stack) * (player.func_70093_af() ? stack.func_190916_E() : 1);
        if (burnTime > 0 && this.getFuel() + burnTime <= 102400) {
            if (player.func_70093_af()) {
                this.addFuel(burnTime * stack.func_190916_E());
                stack = stack.getContainerItem();
            } else {
                this.addFuel(burnTime);
                if (stack.func_190916_E() > 1) {
                    stack.func_190918_g(1);
                } else {
                    stack = stack.getContainerItem();
                }
            }
            player.func_184611_a(hand, stack);
            ItemBedrockGolem.spawnParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.func_213302_cg() / 2.0, this.field_70161_v, 0.05, (IParticleData)ParticleTypes.field_197631_x, 10);
            return true;
        }
        if (stack.func_77973_b() == Items.field_151131_as && stack.func_190916_E() == 1) {
            this.setFuel(0);
            player.func_184611_a(hand, stack.getContainerItem());
            ItemBedrockGolem.spawnParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.func_213302_cg() / 2.0, this.field_70161_v, 0.1, (IParticleData)ParticleTypes.field_197594_E, 15);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public ResourceLocation getTexture() {
        return this.hasFuel() ? LIT : UNLIT;
    }

    public boolean hasFuel() {
        return this.getFuel() > 0;
    }

    public int getFuel() {
        return (Integer)this.func_184212_Q().func_187225_a(FUEL);
    }

    public float getFuelPercentage() {
        return (float)this.getFuel() / 102400.0f;
    }

    public void setFuel(int fuel) {
        if (this.getFuel() != fuel) {
            this.func_184212_Q().func_187227_b(FUEL, (Object)fuel);
        }
    }

    public void addFuel(int toAdd) {
        if (toAdd != 0) {
            this.func_184212_Q().func_187227_b(FUEL, (Object)(this.getFuel() + toAdd));
        }
    }

    class InertGoal
    extends Goal {
        private final FurnaceGolem golem;
        private Vec3d lookVec;
        private float rotateYaw;
        private float rotatePitch;

        protected InertGoal(FurnaceGolem entity) {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.TARGET));
            this.golem = entity;
            this.lookVec = this.golem.func_70040_Z();
            this.rotateYaw = this.golem.field_70177_z;
            this.rotatePitch = this.golem.field_70125_A;
        }

        public boolean func_75250_a() {
            return !this.golem.hasFuel();
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            this.func_75246_d();
        }

        public void func_75246_d() {
            this.golem.func_213317_d(this.golem.func_213322_ci().func_216372_d(0.0, 1.0, 0.0));
            this.golem.func_191989_p(0.0f);
            this.golem.func_184646_p(0.0f);
            this.golem.field_70765_h.func_75642_a(this.golem.field_70165_t, this.golem.field_70163_u, this.golem.field_70161_v, 0.1);
            this.golem.func_70637_d(false);
            this.golem.func_70624_b(null);
            this.golem.func_70604_c(null);
            this.golem.func_70661_as().func_75499_g();
            if (!this.golem.inertLastTick) {
                this.lookVec = this.golem.func_70040_Z();
                this.rotateYaw = this.golem.field_70177_z;
                this.rotatePitch = this.golem.field_70125_A;
            }
            this.golem.func_70671_ap().func_220674_a(this.lookVec);
            this.golem.func_70101_b(this.rotateYaw, this.rotatePitch);
        }
    }

    class UseFuelGoal
    extends Goal {
        private final FurnaceGolem golem;

        protected UseFuelGoal(FurnaceGolem entity) {
            this.golem = entity;
        }

        public boolean func_75250_a() {
            return this.golem.func_70613_aW() && this.golem.getFuel() > 0 && this.golem.field_70173_aa % this.golem.fuelBurnFactor == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            this.golem.addFuel(-1);
        }
    }
}

