/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.events.SpongeGolemSoakEvent;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public final class SpongeGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Absorb Water";
    public static final String INTERVAL = "Water Soaking Frequency";
    public static final String RANGE = "Water Soaking Range";

    public SpongeGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        if (this.getConfigBool(ALLOW_SPECIAL)) {
            this.field_70714_bg.func_75776_a(2, (Goal)new SoakWaterGoal(this, this.getConfigInt(INTERVAL), this.getConfigInt(RANGE)));
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (Math.abs(this.func_213322_ci().func_82615_a()) < 0.03 && Math.abs(this.func_213322_ci().func_82616_c()) < 0.03 && this.field_70170_p.field_72995_K) {
            BasicParticleType particle = this.func_70027_ad() ? ParticleTypes.field_197601_L : ParticleTypes.field_218422_X;
            double x = this.field_70146_Z.nextDouble() - 0.5 * (double)this.func_213311_cf() * 0.6;
            double y = this.field_70146_Z.nextDouble() * ((double)this.func_213302_cg() - 0.75);
            double z = this.field_70146_Z.nextDouble() - 0.5 * (double)this.func_213311_cf();
            this.field_70170_p.func_195594_a((IParticleData)particle, this.field_70165_t + x, this.field_70163_u + y, this.field_70161_v + z, (this.field_70146_Z.nextDouble() - 0.5) * 0.5, this.field_70146_Z.nextDouble() - 0.5, (this.field_70146_Z.nextDouble() - 0.5) * 0.5);
        }
    }

    public static class SoakWaterGoal
    extends Goal {
        protected final GolemBase golem;
        protected final int interval;
        protected final int range;

        public SoakWaterGoal(GolemBase golemIn, int intervalIn, int rangeIn) {
            this.golem = golemIn;
            this.interval = Math.min(1, intervalIn);
            this.range = rangeIn;
        }

        public boolean func_75250_a() {
            return this.golem.field_70173_aa % this.interval == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            int z;
            int y;
            int x = MathHelper.func_76128_c((double)this.golem.field_70165_t);
            BlockPos center = new BlockPos(x, y = MathHelper.func_76128_c((double)(this.golem.field_70163_u - (double)0.2f)) + 2, z = MathHelper.func_76128_c((double)this.golem.field_70161_v));
            SpongeGolemSoakEvent event = new SpongeGolemSoakEvent(this.golem, center, this.range);
            if (!MinecraftForge.EVENT_BUS.post((Event)event) && event.getResult() != Event.Result.DENY) {
                this.replaceWater(event.getPositionList(), event.getAbsorbFunction(), event.updateFlag);
            }
        }

        public boolean replaceWater(List<BlockPos> positions, Function<BlockState, BlockState> replaceWater, int updateFlag) {
            boolean flag = true;
            for (BlockPos p : positions) {
                flag &= this.golem.func_130014_f_().func_180501_a(p, replaceWater.apply(this.golem.func_130014_f_().func_180495_p(p)), updateFlag);
            }
            return flag;
        }
    }
}

