/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity.ai;

import com.mcmoddev.golems.entity.base.GolemBase;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class PlaceBlocksGoal
extends Goal {
    public final GolemBase golem;
    public final int tickDelay;
    public final BlockState[] plantables;
    public final Block[] plantSupports;
    public final boolean checkSupports;
    public final Predicate<PlaceBlocksGoal> canExecute;

    public PlaceBlocksGoal(GolemBase golemBase, int ticksBetweenPlanting, BlockState[] plants, Block[] soils, Predicate<PlaceBlocksGoal> pred) {
        this.golem = golemBase;
        this.tickDelay = Math.max(1, ticksBetweenPlanting);
        this.plantables = plants;
        this.plantSupports = soils;
        this.canExecute = pred;
        this.checkSupports = soils != null && soils.length > 0;
    }

    public PlaceBlocksGoal(GolemBase golemBase, int ticksBetweenPlanting, BlockState[] plants, Predicate<PlaceBlocksGoal> p) {
        this(golemBase, ticksBetweenPlanting, plants, null, p);
    }

    public PlaceBlocksGoal(GolemBase golemBase, int ticksBetweenPlanting, BlockState[] plants, @Nullable Block[] soils, boolean configAllows) {
        this(golemBase, ticksBetweenPlanting, plants, soils, t -> configAllows);
    }

    public PlaceBlocksGoal(GolemBase golemBase, int ticksBetweenPlanting, BlockState[] plants, boolean configAllows) {
        this(golemBase, ticksBetweenPlanting, plants, null, configAllows);
    }

    public boolean func_75250_a() {
        return this.tickDelay > 0 && this.golem.func_130014_f_().field_73012_v.nextInt(this.tickDelay) == 0 && this.canExecute.test(this);
    }

    public void func_75249_e() {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.golem.field_70165_t);
        BlockPos below = new BlockPos(x, y = MathHelper.func_76128_c((double)(this.golem.field_70163_u - (double)0.2f)), z = MathHelper.func_76128_c((double)this.golem.field_70161_v));
        BlockPos in = below.func_177981_b(1);
        if (this.golem.field_70170_p.func_175623_d(in) && this.isPlantSupport(this.golem.field_70170_p, below)) {
            this.setToPlant(this.golem.field_70170_p, in);
        }
    }

    public boolean func_75253_b() {
        return false;
    }

    protected boolean setToPlant(World world, BlockPos pos) {
        BlockState state = this.plantables[world.field_73012_v.nextInt(this.plantables.length)];
        return world.func_180501_a(pos, state, 2);
    }

    protected boolean isPlantSupport(World world, BlockPos pos) {
        if (!this.checkSupports) {
            return true;
        }
        Block at = world.func_180495_p(pos).func_177230_c();
        if (this.plantSupports != null && this.plantSupports.length > 0) {
            for (Block b : this.plantSupports) {
                if (at != b) continue;
                return true;
            }
        }
        return false;
    }

    public static Predicate<PlaceBlocksGoal> getGriefingPredicate() {
        return t -> t.golem.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b);
    }
}

