/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity.ai;

import com.mcmoddev.golems.entity.base.GolemBase;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class PlaceUtilityBlockGoal
extends Goal {
    public final GolemBase golem;
    public final BlockState stateToPlace;
    public final int tickDelay;
    public final boolean configAllows;
    public final BiPredicate<GolemBase, BlockPos> predicate;
    public static final BiPredicate<GolemBase, BlockPos> ABOVE_AIR_PRED = (g, pos) -> g.func_130014_f_().func_175623_d(pos.func_177977_b());
    public static final BiPredicate<GolemBase, BlockPos> ABOVE_WATER_PRED = (g, pos) -> g.func_130014_f_().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150355_j;

    public PlaceUtilityBlockGoal(GolemBase golemIn, BlockState stateIn, int interval, boolean cfgAllows, boolean onlyAboveEmpty, @Nullable BiPredicate<GolemBase, BlockPos> otherPredicate) {
        this.golem = golemIn;
        this.stateToPlace = stateIn;
        this.tickDelay = interval;
        this.configAllows = cfgAllows;
        BiPredicate<GolemBase, BlockPos> pred = PlaceUtilityBlockGoal.makeBiPred(stateIn, onlyAboveEmpty);
        this.predicate = otherPredicate != null ? pred.and(otherPredicate) : pred;
    }

    public PlaceUtilityBlockGoal(GolemBase golemIn, BlockState stateIn, int interval, boolean configAllows) {
        this(golemIn, stateIn, interval, configAllows, false, null);
    }

    public boolean func_75250_a() {
        return this.configAllows;
    }

    public void func_75246_d() {
        int tickMod = this.golem.field_70173_aa % this.tickDelay;
        if (this.configAllows && tickMod == 0) {
            int x = MathHelper.func_76128_c((double)this.golem.field_70165_t);
            int y = MathHelper.func_76128_c((double)(this.golem.field_70163_u - (double)0.2f - this.golem.func_70033_W()));
            int z = MathHelper.func_76128_c((double)this.golem.field_70161_v);
            BlockPos blockPosIn = new BlockPos(x, y, z);
            for (int i = 0; i < 4; ++i) {
                BlockPos pos = blockPosIn.func_177981_b(i);
                BlockState cur = this.golem.func_130014_f_().func_180495_p(pos);
                if (cur.func_177230_c() == this.stateToPlace.func_177230_c()) {
                    return;
                }
                if (!this.predicate.test(this.golem, pos)) continue;
                this.golem.func_130014_f_().func_180501_a(pos, this.getStateToPlace(cur), 6);
                return;
            }
        }
    }

    public void func_75249_e() {
        this.func_75246_d();
    }

    public static boolean canBeWaterlogged(BlockState stateIn) {
        return stateIn.func_206869_a().contains(BlockStateProperties.field_208198_y);
    }

    public static BlockState getStateWaterlogged(BlockState stateIn) {
        return PlaceUtilityBlockGoal.canBeWaterlogged(stateIn) ? (BlockState)stateIn.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)) : stateIn;
    }

    public static BiPredicate<GolemBase, BlockPos> makeBiPred(BlockState stateIn, boolean onlyAboveEmpty) {
        boolean canBeWaterlogged = PlaceUtilityBlockGoal.canBeWaterlogged(stateIn);
        BiPredicate<GolemBase, BlockPos> pred = (golem, pos) -> golem.func_130014_f_().func_175623_d(pos);
        if (canBeWaterlogged) {
            pred = pred.or((golem, pos) -> {
                BlockState toReplace = golem.func_130014_f_().func_180495_p(pos);
                return toReplace.func_177230_c() == Blocks.field_150355_j && (Integer)toReplace.func_177229_b((IProperty)FlowingFluidBlock.field_176367_b) == 0;
            });
        }
        if (onlyAboveEmpty) {
            pred = canBeWaterlogged ? pred.and(ABOVE_WATER_PRED.or(ABOVE_AIR_PRED)) : pred.and(ABOVE_AIR_PRED);
        }
        return pred;
    }

    protected BlockState getStateToPlace(BlockState toReplace) {
        return toReplace.func_177230_c() == Blocks.field_150355_j ? PlaceUtilityBlockGoal.getStateWaterlogged(this.stateToPlace) : this.stateToPlace;
    }
}

