/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity.base;

import com.mcmoddev.golems.entity.ai.GoToWaterGoal;
import com.mcmoddev.golems.entity.ai.MoveThroughVillageGoalFixed;
import com.mcmoddev.golems.entity.ai.SwimUpGoal;
import com.mcmoddev.golems.entity.ai.SwimmingMovementController;
import com.mcmoddev.golems.entity.base.IMultiTexturedGolem;
import com.mcmoddev.golems.items.ItemBedrockGolem;
import com.mcmoddev.golems.main.ExtraGolems;
import com.mcmoddev.golems.main.ExtraGolemsEntities;
import com.mcmoddev.golems.util.config.ExtraGolemsConfig;
import com.mcmoddev.golems.util.config.GolemContainer;
import com.mcmoddev.golems.util.config.GolemRegistrar;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeHooks;

public abstract class GolemBase
extends IronGolemEntity {
    protected static final DataParameter<Boolean> CHILD = EntityDataManager.func_187226_a(GolemBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final String KEY_CHILD = "isChild";
    private final GolemContainer container;
    protected final SwimmerPathNavigator waterNavigator;
    protected final GroundPathNavigator groundNavigator;
    protected boolean swimmingUp;

    public GolemBase(EntityType<? extends GolemBase> type, World world) {
        super(type, world);
        this.container = GolemRegistrar.getContainer(type);
        this.waterNavigator = new SwimmerPathNavigator((MobEntity)this, world);
        this.groundNavigator = new GroundPathNavigator((MobEntity)this, world);
        switch (this.container.getSwimMode()) {
            case FLOAT: {
                this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
                this.field_70699_by.func_212239_d(true);
                break;
            }
            case SWIM: {
                this.field_70138_W = 1.0f;
                this.field_70765_h = new SwimmingMovementController(this);
                this.func_184644_a(PathNodeType.WATER, 0.0f);
                this.field_70714_bg.func_75776_a(1, (Goal)new GoToWaterGoal(this, 14, 1.0));
                this.field_70714_bg.func_75776_a(2, (Goal)new SwimUpGoal(this, 1.0, this.field_70170_p.func_181545_F()));
                break;
            }
        }
    }

    public void onBuilt(BlockState body, BlockState legs, BlockState arm1, BlockState arm2) {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        GolemContainer golemContainer = GolemRegistrar.getContainer(this.func_200600_R());
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(golemContainer.getAttack());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(golemContainer.getHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(golemContainer.getSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(golemContainer.getKnockbackResist());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(CHILD, (Object)false);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        ArrayList erroringGoals = new ArrayList();
        this.field_70714_bg.field_220892_d.forEach(g -> {
            if (g.func_220772_j().getClass() == MoveThroughVillageGoal.class) {
                erroringGoals.add(g.func_220772_j());
            }
        });
        erroringGoals.forEach(g -> {
            this.field_70714_bg.func_85156_a(g);
            ExtraGolems.LOGGER.debug("Removed erroring goal inherited from IronGolemEntity");
        });
        this.field_70714_bg.func_75776_a(3, (Goal)new MoveThroughVillageGoalFixed((CreatureEntity)this, 0.6, false, 4, () -> false));
    }

    public boolean canInteractChangeTexture() {
        return ExtraGolemsConfig.enableTextureInteract() && this instanceof IMultiTexturedGolem;
    }

    public boolean isProvidingLight() {
        return false;
    }

    public boolean isProvidingPower() {
        return false;
    }

    public GolemContainer getGolemContainer() {
        return this.container != null ? this.container : GolemRegistrar.getContainer(this.func_200600_R().getRegistryName());
    }

    public float getHealAmount(ItemStack i) {
        float amount = (float)((double)this.func_110138_aP() * this.getGolemContainer().getHealAmount(i.func_77973_b()));
        if (this.func_70631_g_()) {
            amount *= 1.75f;
        }
        return Math.min(amount, 32.0f);
    }

    public ForgeConfigSpec.ConfigValue getConfigValue(String name) {
        return ExtraGolemsConfig.GOLEM_CONFIG.specials.get((Object)this.getGolemContainer().getSpecialContainer((String)name)).value;
    }

    public boolean getConfigBool(String name) {
        return (Boolean)this.getConfigValue(name).get();
    }

    public int getConfigInt(String name) {
        return (Integer)this.getConfigValue(name).get();
    }

    public double getConfigDouble(String name) {
        return (Double)this.getConfigValue(name).get();
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (!this.container.takesFallDamage()) {
            return;
        }
        float[] ret = ForgeHooks.onLivingFall((LivingEntity)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return;
        }
        distance = ret[0];
        damageMultiplier = ret[1];
        super.func_180430_e(distance, damageMultiplier);
        EffectInstance effectinstance = this.func_70660_b(Effects.field_76430_j);
        float f = effectinstance == null ? 0.0f : (float)(effectinstance.func_76458_c() + 1);
        int i = MathHelper.func_76123_f((float)((distance - 3.0f - f) * damageMultiplier));
        if (i > 0) {
            this.func_184185_a(this.func_184588_d(i), 1.0f, 1.0f);
            this.func_70097_a(DamageSource.field_76379_h, i);
            int j = MathHelper.func_76128_c((double)this.field_70165_t);
            int k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
            int l = MathHelper.func_76128_c((double)this.field_70161_v);
            BlockPos pos = new BlockPos(j, k, l);
            BlockState blockstate = this.field_70170_p.func_180495_p(pos);
            if (!this.field_70170_p.func_175623_d(pos)) {
                SoundType soundtype = blockstate.getSoundType((IWorldReader)this.field_70170_p, pos, (Entity)this);
                this.func_184185_a(soundtype.func_185842_g(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
            }
        }
    }

    public boolean func_70652_k(Entity entity) {
        double baseAttack = this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        double damage = baseAttack + this.field_70146_Z.nextDouble() * 0.75 * baseAttack;
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)damage);
        if (flag) {
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(0.0, 0.4, 0.0));
            this.func_174815_a((LivingEntity)this, entity);
        }
        this.field_70855_f = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        this.func_184185_a(this.getGolemSound(), 1.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
        return flag;
    }

    public boolean func_213358_a(EntityType<?> type) {
        if (type == EntityType.field_200729_aH && this.func_70850_q()) {
            return ExtraGolemsConfig.enableFriendlyFire();
        }
        if (type == EntityType.field_200756_av || type.getRegistryName().toString().contains("golem")) {
            return false;
        }
        return super.func_213358_a(type);
    }

    public ItemStack getPickedResult(RayTraceResult ray) {
        Block block = this.container.getPrimaryBuildingBlock();
        return block != null ? new ItemStack((IItemProvider)block) : ItemStack.field_190927_a;
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        float healAmount = this.getHealAmount(stack);
        if (ExtraGolemsConfig.enableHealGolems() && this.func_110143_aJ() < this.func_110138_aP() && healAmount > 0.0f) {
            this.func_70691_i(healAmount);
            stack.func_190918_g(1);
            if (this.func_70638_az() == player) {
                this.func_70604_c(null);
                this.func_70624_b(null);
            }
            ItemBedrockGolem.spawnParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)(this.func_213302_cg() / 2.0f), this.field_70161_v, 0.15, (IParticleData)ParticleTypes.field_197590_A, 30);
            this.func_184185_a(SoundEvents.field_187845_fY, 0.85f, 1.1f + this.field_70146_Z.nextFloat() * 0.2f);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(CHILD);
    }

    public void setChild(boolean isChild) {
        if ((Boolean)this.func_184212_Q().func_187225_a(CHILD) != isChild) {
            this.func_184212_Q().func_187227_b(CHILD, (Object)isChild);
            this.func_213323_x_();
        }
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.setChild(tag.func_74767_n(KEY_CHILD));
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74757_a(KEY_CHILD, this.func_70631_g_());
    }

    public ResourceLocation getTexture() {
        return this.getGolemContainer().getTexture();
    }

    protected static ResourceLocation makeTexture(String TEXTURE) {
        return ExtraGolemsEntities.makeTexture(TEXTURE);
    }

    protected static ResourceLocation makeTexture(String MODID, String TEXTURE) {
        return ExtraGolemsEntities.makeTexture(MODID, TEXTURE);
    }

    protected SoundEvent func_184639_G() {
        return this.getGolemSound();
    }

    protected SoundEvent func_184601_bQ(DamageSource ignored) {
        return this.getGolemSound() == SoundEvents.field_187569_bQ ? SoundEvents.field_187565_bO : this.getGolemSound();
    }

    protected SoundEvent func_184615_bR() {
        return this.getGolemSound() == SoundEvents.field_187569_bQ ? SoundEvents.field_187561_bM : this.getGolemSound();
    }

    public final SoundEvent getGolemSound() {
        return this.container.getSound();
    }

    public void func_213352_e(Vec3d vec) {
        if (this.func_70613_aW() && this.func_70090_H() && this.isSwimmingUp()) {
            this.func_213309_a(0.01f, vec);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        } else {
            super.func_213352_e(vec);
        }
    }

    public void func_205343_av() {
        if (this.container.getSwimMode() != GolemContainer.SwimMode.SWIM) {
            super.func_205343_av();
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70613_aW() && this.func_70090_H() && this.isSwimmingUp()) {
                this.field_70699_by = this.waterNavigator;
                this.func_204711_a(true);
            } else {
                this.field_70699_by = this.groundNavigator;
                this.func_204711_a(false);
            }
        }
    }

    protected float func_189749_co() {
        return this.container.getSwimMode() == GolemContainer.SwimMode.SWIM ? 0.88f : super.func_189749_co();
    }

    public boolean func_96092_aw() {
        return !this.func_203007_ba();
    }

    public void setSwimmingUp(boolean isSwimmingUp) {
        this.swimmingUp = isSwimmingUp && this.container.getSwimMode() == GolemContainer.SwimMode.SWIM;
    }

    public boolean isSwimmingUp() {
        if (this.container.getSwimMode() != GolemContainer.SwimMode.SWIM) {
            return false;
        }
        if (this.swimmingUp) {
            return true;
        }
        LivingEntity e = this.func_70638_az();
        return e != null && e.func_70090_H();
    }

    public static boolean isSwimmingUp(GolemBase golem) {
        return golem.swimmingUp;
    }

    public boolean shouldMoveToWater(Vec3d target) {
        return this.container.getSwimMode() == GolemContainer.SwimMode.SWIM;
    }
}

