/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.events;

import com.mcmoddev.golems.entity.base.GolemBase;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

@Cancelable
public final class SpongeGolemSoakEvent
extends Event {
    protected List<BlockPos> affectedBlocks;
    protected Function<BlockState, BlockState> absorbFunction;
    public final GolemBase spongeGolem;
    public final BlockPos spongeGolemPos;
    public final int range;
    public int updateFlag = 3;

    public SpongeGolemSoakEvent(GolemBase golem, BlockPos center, int radius) {
        this(golem, center, radius, state -> state.func_196959_b((IProperty)BlockStateProperties.field_208198_y) ? (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)) : (state.func_185904_a() == Material.field_151586_h || state.func_177230_c() == Blocks.field_203214_jx || state.func_177230_c() == Blocks.field_203215_jy || state.func_177230_c() == Blocks.field_203198_aQ || state.func_177230_c() == Blocks.field_203199_aR ? Blocks.field_150350_a.func_176223_P() : state));
    }

    public SpongeGolemSoakEvent(GolemBase golem, BlockPos center, int radius, Function<BlockState, BlockState> function) {
        this.setResult(Event.Result.ALLOW);
        this.spongeGolem = golem;
        this.spongeGolemPos = center;
        this.range = radius;
        this.setAbsorbFunction(function, true);
    }

    public void initAffectedBlockList(int range) {
        this.affectedBlocks = new ArrayList<BlockPos>(range * range * range * 4);
        int MAX_DIS = range * range;
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                for (int k = -range; k <= range; ++k) {
                    BlockState state;
                    BlockState replace;
                    BlockPos current = this.spongeGolemPos.func_177982_a(i, j, k);
                    if (!(this.spongeGolemPos.func_177951_i((Vec3i)current) <= (double)MAX_DIS) || (replace = this.absorbFunction.apply(state = this.spongeGolem.field_70170_p.func_180495_p(current))) == null || replace == state) continue;
                    this.affectedBlocks.add(current);
                }
            }
        }
    }

    public List<BlockPos> getPositionList() {
        return this.affectedBlocks;
    }

    public Function<BlockState, BlockState> getAbsorbFunction() {
        return this.absorbFunction;
    }

    public void setAbsorbFunction(Function<BlockState, BlockState> function, boolean refresh) {
        this.absorbFunction = function;
        if (refresh) {
            this.initAffectedBlockList(this.range);
        }
    }

    public boolean removeBlockPos(BlockPos toRemove) {
        return this.affectedBlocks.remove(toRemove);
    }
}

