/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.gui;

import com.mcmoddev.golems.gui.GolemBookEntry;
import com.mcmoddev.golems.main.GolemItems;
import com.mcmoddev.golems.util.config.GolemContainer;
import com.mcmoddev.golems.util.config.GolemRegistrar;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiGolemBook
extends Screen {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("golems", "textures/gui/info_book.png");
    protected static final ResourceLocation CONTENTS = new ResourceLocation("golems", "textures/gui/info_book_contents.png");
    protected static final int BOOK_HEIGHT = 164;
    protected static final int BOOK_WIDTH = 256;
    protected static final int DEF_SEP = 5;
    protected static final int SCR_OFFSET_Y = 16;
    protected static final int ARROW_WIDTH = 18;
    protected static final int ARROW_HEIGHT = 15;
    protected static final int SUPP_WIDTH = 100;
    protected static final int SUPP_HEIGHT = 50;
    private BlockButton buttonBlockLeft;
    private BlockButton buttonBlockRight;
    private NextPageButton buttonNextPage;
    private NextPageButton buttonPreviousPage;
    private GolemEntryButton[] tableOfContents;
    protected int curPage;
    protected int totalPages;
    public static final List<GolemBookEntry> GOLEMS = new ArrayList<GolemBookEntry>();
    private static final List<GolemBookEntry> ALPHABETICAL = new ArrayList<GolemBookEntry>();
    private static final float GOLEM_BLOCK_SCALE = 1.6f;
    private static final int MARGIN = 12;
    private static final int NUM_PAGES_INTRO = 6;
    private static final int NUM_CONTENTS_ENTRIES = 5;
    protected static final int CONTENTS_W = 106;
    protected static final int CONTENTS_H = 110;
    protected static final int SCROLL_STARTX = 12;
    protected static final int SCROLL_STARTY = 24;
    protected static final int SCROLL_W = 12;
    protected static final int SCROLL_H = 15;
    protected static final int ENTRY_W = 88;
    protected static final int ENTRY_H = 22;
    private float currentScroll;
    private boolean isScrolling;
    protected long ticksOpen;
    private static final ItemStack[] ingredientsSpell = new ItemStack[]{new ItemStack((IItemProvider)Items.field_151121_aF), new ItemStack((IItemProvider)Items.field_151008_G), new ItemStack((IItemProvider)Items.field_151137_ax), new ItemStack((IItemProvider)Items.field_196136_br)};
    private static final ItemStack outputSpell = new ItemStack((IItemProvider)GolemItems.GOLEM_SPELL);
    private static final ItemStack[] ingredientsHead = new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196625_cS), new ItemStack((IItemProvider)GolemItems.GOLEM_SPELL)};
    private static final ItemStack outputHead = new ItemStack((IItemProvider)GolemItems.GOLEM_HEAD);

    public GuiGolemBook(PlayerEntity playerIn, ItemStack itemIn) {
        super((ITextComponent)new TranslationTextComponent("item.golems.info_book", new Object[0]));
        if (GOLEMS.isEmpty()) {
            GuiGolemBook.initGolemBookEntries();
        }
        this.setSize(256, 164);
        this.curPage = 0;
        this.totalPages = 6 + GOLEMS.size();
        this.currentScroll = 0.0f;
        this.isScrolling = false;
        this.tableOfContents = new GolemEntryButton[5];
        this.ticksOpen = 0L;
    }

    private static final void initGolemBookEntries() {
        GOLEMS.clear();
        for (GolemContainer container : GolemRegistrar.getContainers()) {
            if (!container.isEnabled()) continue;
            GOLEMS.add(new GolemBookEntry(container));
        }
        Collections.sort(GOLEMS, (g1, g2) -> Float.compare(g1.getAttack(), g2.getAttack()));
        ALPHABETICAL.clear();
        ALPHABETICAL.addAll(GOLEMS);
        Collections.sort(ALPHABETICAL, (g1, g2) -> g1.getGolemName().compareTo(g2.getGolemName()));
    }

    public void init() {
        int doneW = 98;
        int doneH = 20;
        int doneX = (this.width - doneW) / 2;
        int doneY = 188;
        this.addButton((Widget)new Button(doneX, doneY, doneW, doneH, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), c -> this.onClose()));
        int arrowX = (this.width - 256) / 2;
        int arrowY = 158;
        this.buttonPreviousPage = (NextPageButton)this.addButton((Widget)new NextPageButton(this, arrowX + 18, arrowY, false));
        this.buttonNextPage = (NextPageButton)this.addButton((Widget)new NextPageButton(this, arrowX + 256 - 36, arrowY, true));
        int blockX = (this.width - 256) / 2 + 12 + 4;
        int blockY = 28;
        this.buttonBlockLeft = (BlockButton)this.addButton((Widget)new BlockButton(this, new Block[0], blockX, blockY, 1.6f));
        blockX = this.width / 2 + 12;
        this.buttonBlockRight = (BlockButton)this.addButton((Widget)new BlockButton(this, new Block[0], blockX, blockY, 1.6f));
        for (int i = 0; i < 5; ++i) {
            this.tableOfContents[i] = (GolemEntryButton)this.addButton((Widget)new GolemEntryButton(this, ALPHABETICAL.get(i), this.width / 2 + 12, 40 + 22 * i));
        }
        this.updateButtons();
    }

    public void tick() {
        ++this.ticksOpen;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
        int bookX = (this.width - 256) / 2;
        int bookY = 16;
        this.blit(bookX, bookY, 0, 0, 256, 164);
        this.drawPageAt(bookX + 1, bookY, this.curPage, partialTicks);
        this.drawPageAt(bookX + 128 - 2, bookY, this.curPage + 1, partialTicks);
        super.render(mouseX, mouseY, partialTicks);
        if (GuiGolemBook.isPageGolemEntry(this.curPage, this.totalPages) && this.buttonBlockLeft.isHovered()) {
            this.buttonBlockLeft.drawHoveringText(mouseX, mouseY);
        }
        if (GuiGolemBook.isPageGolemEntry(this.curPage + 1, this.totalPages) && this.buttonBlockRight.isHovered()) {
            this.buttonBlockRight.drawHoveringText(mouseX, mouseY);
        }
    }

    private void drawPageAt(int cornerX, int cornerY, int pageNum, float partialTicks) {
        this.drawPageNum(cornerX, cornerY, pageNum + 1);
        switch (pageNum) {
            case 0: {
                String title = GuiGolemBook.trans("item.golems.info_book", new Object[0]);
                String body = GuiGolemBook.trans("golembook.intro1", new Object[0]) + "\n" + GuiGolemBook.trans("golembook.intro2", new Object[0]);
                this.drawBasicPage(cornerX, cornerY, title, body);
                return;
            }
            case 1: {
                String title = GuiGolemBook.trans("golembook.contents.title", new Object[0]);
                this.drawBasicPage(cornerX, cornerY, title, "");
                this.getMinecraft().func_110434_K().func_110577_a(CONTENTS);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int startX = cornerX + 12 + 1;
                int startY = cornerY + 24 - 1;
                this.blit(startX, startY, 0, 0, 106, 112);
                startX = GuiGolemBook.getScrollX(this.width) - 2;
                startY = GuiGolemBook.getScrollY(this.currentScroll);
                this.blit(startX, startY, this.isScrolling ? 17 : 0, 115, 12, 15);
                if (this.isScrolling) {
                    GolemBookEntry[] visibleArray = GuiGolemBook.getGolemEntriesForScroll(this.currentScroll);
                    int l = this.tableOfContents.length;
                    for (int i = 0; i < l; ++i) {
                        this.tableOfContents[i].setEntry(visibleArray[i]);
                    }
                }
                return;
            }
            case 2: {
                String title = TextFormatting.func_110646_a((String)GuiGolemBook.trans("item.golems.golem_paper", new Object[0]));
                String body = "\n\n\n\n" + I18n.func_135052_a((String)"golembook.recipe_spell.recipe", (Object[])new Object[]{title, GuiGolemBook.trans("item.minecraft.paper", new Object[0]), GuiGolemBook.trans("item.minecraft.feather", new Object[0]), GuiGolemBook.trans("item.minecraft.ink_sac", new Object[0]), GuiGolemBook.trans("item.minecraft.redstone", new Object[0])});
                this.drawBasicPage(cornerX, cornerY, title, body);
                this.draw2x2GridAt(cornerX + 24, cornerY + 24, ingredientsSpell, outputSpell);
                return;
            }
            case 3: {
                String title = GuiGolemBook.trans("block.golems.golem_head", new Object[0]);
                String body = "\n\n\n\n" + TextFormatting.func_110646_a((String)GuiGolemBook.trans("golembook.recipe_head.recipe", title, GuiGolemBook.trans("item.golems.golem_paper", new Object[0]), GuiGolemBook.trans("block.minecraft.pumpkin", new Object[0])));
                this.drawBasicPage(cornerX, cornerY, title, body);
                this.draw2x2GridAt(cornerX + 24, cornerY + 24, ingredientsHead, outputHead);
                return;
            }
            case 4: {
                String title = GuiGolemBook.trans("golembook.build_golem.title", new Object[0]);
                String body = GuiGolemBook.trans("golembook.build_golem.howto1", new Object[0]) + " " + GuiGolemBook.trans("golembook.build_golem.howto2", new Object[0]) + "\n\n" + I18n.func_135052_a((String)"golembook.build_golem.howto3", (Object[])new Object[]{GuiGolemBook.trans("block.golems.golem_head", new Object[0])});
                this.drawBasicPage(cornerX, cornerY, title, body);
                return;
            }
            case 5: {
                Block golemBody = Blocks.field_150339_S;
                Block golemHead = GolemItems.GOLEM_HEAD;
                float scale = 2.0f;
                int blockW = (int)(8.0f * scale);
                int startX = cornerX + 32;
                int startY = cornerY + blockW;
                this.drawBlock(golemHead, startX, startY, scale);
                this.drawBlock(golemBody, startX, startY += blockW * 4, scale);
                this.drawBlock(golemBody, startX += blockW * 2, startY -= blockW * 5 / 2, scale);
                this.drawBlock(golemBody, startX -= blockW * 2, startY += blockW / 2, scale);
                this.drawBlock(golemBody, startX -= blockW * 2, startY += blockW / 2, scale);
                return;
            }
        }
        if (GuiGolemBook.isPageGolemEntry(pageNum, this.totalPages)) {
            GolemBookEntry entry = GuiGolemBook.getGolemEntryForPage(pageNum);
            this.drawGolemEntry(cornerX, cornerY, entry, partialTicks);
        }
    }

    private void drawPageNum(int cornerX, int cornerY, int pageNum) {
        boolean isLeft = pageNum % 2 == 1;
        int numX = isLeft ? this.width / 2 - 12 : this.width / 2 + 12;
        int numY = cornerY + 164 - 22;
        String pageNumLeft = String.valueOf(pageNum);
        int sWidth = isLeft ? this.font.func_78256_a(pageNumLeft) : 0;
        this.font.func_211126_b(pageNumLeft, (float)(numX - sWidth), (float)numY, 0);
    }

    protected void drawBlock(Block blockIn, int cornerX, int cornerY, float scale) {
        Block block = blockIn != Blocks.field_150350_a ? blockIn : Blocks.field_180401_cv;
        float blockX = cornerX + 12 + 4;
        float blockY = cornerY + 12;
        GlStateManager.pushMatrix();
        GlStateManager.enableRescaleNormal();
        RenderHelper.func_74520_c();
        GlStateManager.scalef((float)scale, (float)scale, (float)scale);
        this.itemRenderer.func_175042_a(new ItemStack((IItemProvider)block), (int)(blockX / scale), (int)(blockY / scale));
        GlStateManager.popMatrix();
    }

    private void drawGolemEntry(int cornerX, int cornerY, GolemBookEntry entry, float partialTicks) {
        int nameX = cornerX + 48;
        int nameY = cornerY + 12;
        String golemName = entry.getGolemName();
        this.font.func_78279_b(golemName, nameX, nameY, 68, 0);
        int statsX = cornerX + 12;
        int statsY = nameY + 24;
        String stats = entry.getDescriptionPage();
        this.font.func_78279_b(stats, statsX, statsY, 104, 0);
        if (entry.hasImage()) {
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float scale = 0.9f;
            int imgX = cornerX + 64 - (int)(100.0f * scale / 2.0f);
            int imgY = cornerY + 164 - (int)(50.0f * scale) - 24;
            this.getMinecraft().func_110434_K().func_110577_a(entry.getImageResource());
            int w = (int)(100.0f * scale);
            int h = (int)(50.0f * scale);
            GuiGolemBook.blit((int)imgX, (int)imgY, (float)0.0f, (float)0.0f, (int)w, (int)h, (int)w, (int)h);
        }
    }

    private void drawBasicPage(int cornerX, int cornerY, String title, String body) {
        int maxWidth = 104;
        int titleX = cornerX + 12 + 4;
        int titleY = cornerY + 12;
        int sWidth = this.font.func_78256_a(title);
        if (sWidth > 104) {
            this.font.func_78279_b(title, titleX, titleY, 104, 0);
        } else {
            this.font.func_211126_b(title, (float)(titleX + (104 - sWidth) / 2), (float)titleY, 0);
        }
        int bodyX = titleX;
        int bodyY = titleY + 24;
        this.font.func_78279_b(body, bodyX, bodyY, 104, 0);
    }

    private void draw2x2GridAt(int startX, int startY, ItemStack[] ingredients, ItemStack result) {
        float posY;
        float posX;
        int frameWidth = 3;
        float scale = 1.0f;
        int gridW = 84;
        int gridH = 46;
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
        this.blit(startX, startY, 172, 169, 84, 46);
        GlStateManager.enableRescaleNormal();
        RenderHelper.func_74520_c();
        int iconW = 15;
        switch (ingredients.length) {
            case 4: {
                posX = (float)(startX + iconW) + 9.0f;
                posY = (float)(startY + iconW) + 9.0f;
                this.itemRenderer.func_175042_a(ingredients[3], (int)(posX / 1.0f), (int)(posY / 1.0f));
            }
            case 3: {
                posX = (float)startX + 6.0f;
                posY = (float)(startY + iconW) + 9.0f;
                this.itemRenderer.func_175042_a(ingredients[2], (int)(posX / 1.0f), (int)(posY / 1.0f));
            }
            case 2: {
                posX = (float)(startX + iconW) + 9.0f;
                posY = (float)startY + 6.0f;
                this.itemRenderer.func_175042_a(ingredients[1], (int)(posX / 1.0f), (int)(posY / 1.0f));
            }
            case 1: {
                posX = (float)startX + 6.0f;
                posY = (float)startY + 6.0f;
                this.itemRenderer.func_175042_a(ingredients[0], (int)(posX / 1.0f), (int)(posY / 1.0f));
            }
        }
        posX = (float)(startX + 84) - 16.0f - 6.0f;
        posY = (float)startY + 16.0f;
        this.itemRenderer.func_175042_a(result, (int)(posX / 1.0f), (int)(posY / 1.0f));
        GlStateManager.popMatrix();
    }

    public boolean mouseDragged(double mouseX, double mouseY, int state, double parDouble1, double parDouble2) {
        if (GuiGolemBook.isPageTableContents(this.curPage)) {
            int mouseYCentered = (int)(mouseY - 7.5);
            if (GuiGolemBook.isMouseOverScroll((int)mouseX, mouseYCentered, this.width)) {
                this.isScrolling = true;
                if (mouseYCentered < 150 && mouseYCentered >= 40) {
                    this.currentScroll = GuiGolemBook.getScrollFloat((int)(mouseY - 7.5));
                }
            } else {
                this.isScrolling = false;
            }
        }
        return super.mouseDragged(mouseX, mouseY, state, parDouble1, parDouble2);
    }

    public boolean mouseScrolled(double d1, double d2, double d3) {
        this.currentScroll = GuiGolemBook.getScrollFloat(GuiGolemBook.getScrollY(this.currentScroll + (float)d1));
        return super.mouseScrolled(d1, d2, d3);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        this.isScrolling = false;
        return super.mouseReleased(mouseX, mouseY, state);
    }

    private void updateButtons() {
        this.buttonPreviousPage.visible = this.curPage > 0;
        this.buttonNextPage.visible = this.curPage + 2 < this.totalPages;
        boolean tableContentsVisible = GuiGolemBook.isPageTableContents(this.curPage);
        for (GolemEntryButton b : this.tableOfContents) {
            b.visible = tableContentsVisible;
        }
        if (GuiGolemBook.isPageGolemEntry(this.curPage, this.totalPages)) {
            this.buttonBlockLeft.visible = true;
            this.buttonBlockLeft.updateBlocks(GuiGolemBook.getGolemEntryForPage(this.curPage).getBlocks());
        } else {
            this.buttonBlockLeft.visible = false;
        }
        if (GuiGolemBook.isPageGolemEntry(this.curPage + 1, this.totalPages)) {
            this.buttonBlockRight.visible = true;
            this.buttonBlockRight.updateBlocks(GuiGolemBook.getGolemEntryForPage(this.curPage + 1).getBlocks());
        } else {
            this.buttonBlockRight.visible = false;
        }
    }

    private static boolean isMouseOverScroll(int mouseX, int mouseY, int width) {
        int scrollStartX = GuiGolemBook.getScrollX(width);
        int scrollStartY = 40;
        return mouseX >= scrollStartX && mouseY >= scrollStartY && mouseX < scrollStartX + 12 && mouseY < scrollStartY + 110 - 7;
    }

    private static int getScrollX(int screenWidth) {
        return screenWidth / 2 + 12 + 106 - 12;
    }

    private static int getScrollY(float scroll) {
        float f = Math.max(0.0f, Math.min(1.0f, scroll));
        return 40 + (int)(f * 95.0f);
    }

    private static float getScrollFloat(int currentY) {
        int minY = 40;
        int maxY = 135;
        float f = Math.max(40, Math.min(135, currentY)) - 40;
        return f / 95.0f;
    }

    private static boolean isPageGolemEntry(int page, int totalPages) {
        return page >= 6 && page < totalPages;
    }

    private static boolean isPageTableContents(int page) {
        return page >= 0 && page < 2;
    }

    private static GolemBookEntry getGolemEntryForPage(int page) {
        return GOLEMS.get(page - 6);
    }

    private static GolemBookEntry[] getGolemEntriesForScroll(float scrollIn) {
        float scroll = MathHelper.func_76131_a((float)scrollIn, (float)0.0f, (float)1.0f);
        int i = (int)(scroll * (float)(ALPHABETICAL.size() - 5));
        return ALPHABETICAL.subList(i, i + 5).toArray(new GolemBookEntry[5]);
    }

    protected static String trans(String s, Object ... strings) {
        return I18n.func_135052_a((String)s, (Object[])strings);
    }

    protected static class NextPageButton
    extends Button {
        protected static final int TEXTURE_STARTY = 169;
        private final GuiGolemBook gui;
        private final boolean isForward;

        public NextPageButton(GuiGolemBook guiBook, int x, int y, boolean isForwardIn) {
            super(x, y, 18, 15, "", b -> {});
            this.gui = guiBook;
            this.isForward = isForwardIn;
        }

        public void onClick(double mouseX, double mouseY) {
            this.gui.curPage = this.isForward ? (this.gui.curPage += 2) : (this.gui.curPage -= 2);
            this.gui.updateButtons();
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            if (this.visible) {
                boolean mouseOver = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
                int tx = 0;
                int ty = 169;
                if (mouseOver) {
                    tx += 23;
                }
                if (!this.isForward) {
                    ty += 15;
                }
                this.blit(this.x, this.y, tx, ty, 18, 15);
            }
        }
    }

    protected static class GolemEntryButton
    extends Button {
        private final GuiGolemBook gui;
        private GolemBookEntry entry;

        public GolemEntryButton(GuiGolemBook guiIn, GolemBookEntry entryIn, int x, int y) {
            super(x, y, 88, 22, "", b -> {});
            this.gui = guiIn;
            this.entry = entryIn;
        }

        public void setEntry(GolemBookEntry toSet) {
            this.entry = toSet;
        }

        public void onClick(double mouseX, double mouseY) {
            int index = GOLEMS.indexOf(this.entry);
            if (index >= 0 && index <= GOLEMS.size()) {
                int page = index + 6;
                this.gui.curPage = page = Math.floorDiv(page, 2) * 2;
            }
            this.gui.updateButtons();
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            if (this.visible) {
                this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(CONTENTS);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.blit(this.x, this.y, 111, this.isHovered ? 27 : 0, 88, 22);
                int index = (int)(this.gui.ticksOpen / 30L);
                this.gui.drawBlock(this.entry.getBlock(index), this.x - 12 - 2, this.y - 9, 1.0f);
                GlStateManager.pushMatrix();
                String name = this.entry.getGolemName();
                int wrap = this.width - 20;
                float scale = 1.0f;
                int nameH = this.gui.font.func_78267_b(name, wrap);
                if (nameH > this.height) {
                    scale = 0.7f;
                    nameH = (int)(scale * (float)this.gui.font.func_78267_b(name, (int)((float)wrap / scale)));
                }
                int nameX = this.x + 20;
                int nameY = this.y + (this.height - nameH) / 2 + 1;
                GlStateManager.scalef((float)scale, (float)scale, (float)scale);
                this.gui.font.func_78279_b(name, (int)((float)nameX / scale), (int)((float)nameY / scale), (int)((float)wrap / scale), 0);
                GlStateManager.popMatrix();
            }
        }
    }

    protected static class BlockButton
    extends Button {
        private float scale;
        private Block[] blocks;
        private Block currentBlock;
        private final GuiGolemBook gui;

        public BlockButton(GuiGolemBook guiIn, Block[] blockValues, int x, int y, float scaleIn) {
            super(x, y, (int)(scaleIn * 16.0f), (int)(scaleIn * 16.0f), "", b -> {});
            this.gui = guiIn;
            this.blocks = blockValues;
            this.scale = scaleIn;
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            if (this.visible) {
                boolean bl = this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
                if (this.blocks != null && this.blocks.length > 0) {
                    int index = (int)(this.gui.ticksOpen / 30L) % this.blocks.length;
                    this.currentBlock = this.blocks[index];
                } else {
                    this.currentBlock = Blocks.field_150350_a;
                }
                this.gui.drawBlock(this.currentBlock, this.x - 12 - 4, this.y - 12, this.scale);
            }
        }

        public void updateBlocks(Block[] blocksToDraw) {
            this.blocks = blocksToDraw;
        }

        public boolean drawHoveringText(int mouseX, int mouseY) {
            if (this.currentBlock != Blocks.field_150350_a) {
                this.gui.renderTooltip(GuiGolemBook.trans(this.currentBlock.func_149739_a(), new Object[0]), mouseX, mouseY);
                return true;
            }
            return false;
        }
    }
}

