/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.items;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.util.config.ExtraGolemsConfig;
import com.mcmoddev.golems.util.config.GolemContainer;
import com.mcmoddev.golems.util.config.GolemRegistrar;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class ItemBedrockGolem
extends Item {
    public ItemBedrockGolem() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World worldIn = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        Direction facing = context.func_196000_l();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = context.func_195996_i();
        if (ExtraGolemsConfig.bedrockGolemCreativeOnly() && !player.field_71075_bZ.field_75098_d || facing == Direction.DOWN) {
            return ActionResultType.FAIL;
        }
        GolemContainer container = GolemRegistrar.getContainer(new ResourceLocation("golems", "golem_bedrock"));
        if (container != null && container.isEnabled()) {
            BlockState state = worldIn.func_180495_p(pos);
            BlockPos spawnPos = state.func_196952_d((IBlockReader)context.func_195991_k(), context.func_195995_a()).func_197766_b() ? pos : pos.func_177972_a(context.func_196000_l());
            EntityType<? extends GolemBase> entitytype = container.getEntityType();
            if (!worldIn.field_72995_K && entitytype != null) {
                entitytype.func_220331_a(worldIn, stack, player, spawnPos, SpawnReason.SPAWN_EGG, true, !Objects.equals(pos, spawnPos) && facing == Direction.UP);
                stack.func_190918_g(1);
            }
            ItemBedrockGolem.spawnParticles(worldIn, spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p(), 0.12);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static void spawnParticles(World world, double x, double y, double z, double motion) {
        ItemBedrockGolem.spawnParticles(world, x, y, z, motion, (IParticleData)ParticleTypes.field_197594_E, 60);
    }

    public static void spawnParticles(World world, double x, double y, double z, double motion, IParticleData type, int num) {
        if (world.field_72995_K) {
            for (int i = num + world.field_73012_v.nextInt(Math.max(1, num / 2)); i > 0; --i) {
                world.func_195594_a(type, x + world.field_73012_v.nextDouble() - 0.5, y + world.field_73012_v.nextDouble() - 0.5, z + world.field_73012_v.nextDouble() - 0.5, field_77697_d.nextGaussian() * motion, world.field_73012_v.nextDouble() * motion, field_77697_d.nextGaussian() * motion);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ITextComponent loreCreativeOnly = ItemBedrockGolem.trans("tooltip.creative_only_item", new Object[0]).func_211708_a(TextFormatting.RED);
        ITextComponent lorePressShift = ItemBedrockGolem.trans("tooltip.press", new Object[0]).func_211708_a(TextFormatting.GRAY).func_150257_a((ITextComponent)ItemBedrockGolem.wrap(" ")).func_150257_a(ItemBedrockGolem.trans("tooltip.shift", new Object[0]).func_211708_a(TextFormatting.YELLOW)).func_150257_a((ITextComponent)ItemBedrockGolem.wrap(" ")).func_150257_a(ItemBedrockGolem.trans("tooltip.for_more_details", new Object[0]).func_211708_a(TextFormatting.GRAY));
        tooltip.add(loreCreativeOnly);
        if (Screen.hasShiftDown()) {
            tooltip.add((ITextComponent)ItemBedrockGolem.trans("tooltip.use_to_spawn", ItemBedrockGolem.trans("entity.golems.golem_bedrock", new Object[0])));
            tooltip.add((ITextComponent)ItemBedrockGolem.trans("tooltip.use_on_existing", ItemBedrockGolem.trans("entity.golems.golem_bedrock", new Object[0])));
            tooltip.add((ITextComponent)ItemBedrockGolem.trans("tooltip.to_remove_it", new Object[0]));
        } else {
            tooltip.add(lorePressShift);
        }
    }

    private static TranslationTextComponent trans(String s, Object ... param) {
        return new TranslationTextComponent(s, param);
    }

    private static StringTextComponent wrap(String s) {
        return new StringTextComponent(s);
    }
}

