/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.proxies;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemColorized;
import com.mcmoddev.golems.gui.GuiDispenserGolem;
import com.mcmoddev.golems.main.GolemItems;
import com.mcmoddev.golems.proxies.ProxyCommon;
import com.mcmoddev.golems.renders.RenderColoredGolem;
import com.mcmoddev.golems.renders.RenderGolem;
import com.mcmoddev.golems.util.config.GolemRegistrar;
import net.minecraft.client.gui.ScreenManager;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public final class ProxyClient
extends ProxyCommon {
    public static final IRenderFactory<GolemBase> FACTORY_TEXTURED_GOLEM = RenderGolem::new;
    public static final IRenderFactory<GolemColorized> FACTORY_COLORED_GOLEM = RenderColoredGolem::new;

    @Override
    public void registerListeners() {
    }

    @Override
    public void registerContainerRenders() {
        ScreenManager.func_216911_a(GolemItems.DISPENSER_GOLEM, GuiDispenserGolem::new);
    }

    @Override
    public void registerEntityRenders() {
        GolemRegistrar.getContainers().forEach(container -> {
            if (container.useDefaultRender()) {
                ProxyClient.registerEntityRender(container.getEntityClass());
            }
        });
    }

    public static void registerEntityRender(Class<? extends GolemBase> clazz) {
        if (GolemColorized.class.isAssignableFrom(clazz)) {
            ProxyClient.registerColorized(clazz);
        } else {
            ProxyClient.registerTextured(clazz);
        }
    }

    public static void registerTextured(Class<? extends GolemBase> golem) {
        RenderingRegistry.registerEntityRenderingHandler(golem, FACTORY_TEXTURED_GOLEM);
    }

    public static void registerColorized(Class<? extends GolemColorized> golem) {
        RenderingRegistry.registerEntityRenderingHandler(golem, FACTORY_COLORED_GOLEM);
    }
}

