/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.renders;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelGolem<T extends GolemBase>
extends EntityModel<T> {
    public final RendererModel golemHead;
    public final RendererModel golemBody;
    public final RendererModel golemRightArm;
    public final RendererModel golemLeftArm;
    public final RendererModel golemLeftLeg;
    public final RendererModel golemRightLeg;

    public ModelGolem() {
        this(0.0f);
    }

    public ModelGolem(float f1) {
        this(f1, -7.0f);
    }

    public ModelGolem(float f1, float f2) {
        int short1 = 128;
        int short2 = 128;
        this.golemHead = new RendererModel((Model)this).func_78787_b(short1, short2);
        this.golemHead.func_78793_a(0.0f, 0.0f + f2, -2.0f);
        this.golemHead.func_78784_a(0, 0).func_78790_a(-4.0f, -12.0f, -5.5f, 8, 10, 8, f1);
        this.golemHead.func_78784_a(24, 0).func_78790_a(-1.0f, -5.0f, -7.5f, 2, 4, 2, f1);
        this.golemBody = new RendererModel((Model)this).func_78787_b(short1, short2);
        this.golemBody.func_78793_a(0.0f, 0.0f + f2, 0.0f);
        this.golemBody.func_78784_a(0, 40).func_78790_a(-9.0f, -2.0f, -6.0f, 18, 12, 11, f1);
        this.golemBody.func_78784_a(0, 70).func_78790_a(-4.5f, 10.0f, -3.0f, 9, 5, 6, f1 + 0.5f);
        this.golemRightArm = new RendererModel((Model)this).func_78787_b(short1, short2);
        this.golemRightArm.func_78793_a(0.0f, -7.0f, 0.0f);
        this.golemRightArm.func_78784_a(60, 21).func_78790_a(-13.0f, -2.5f, -3.0f, 4, 30, 6, f1);
        this.golemLeftArm = new RendererModel((Model)this).func_78787_b(short1, short2);
        this.golemLeftArm.func_78793_a(0.0f, -7.0f, 0.0f);
        this.golemLeftArm.func_78784_a(60, 58).func_78790_a(9.0f, -2.5f, -3.0f, 4, 30, 6, f1);
        this.golemLeftLeg = new RendererModel((Model)this, 0, 22).func_78787_b(short1, short2);
        this.golemLeftLeg.func_78793_a(-4.0f, 18.0f + f2, 0.0f);
        this.golemLeftLeg.func_78784_a(37, 0).func_78790_a(-3.5f, -3.0f, -3.0f, 6, 16, 5, f1);
        this.golemRightLeg = new RendererModel((Model)this, 0, 22).func_78787_b(short1, short2);
        this.golemRightLeg.field_78809_i = true;
        this.golemRightLeg.func_78784_a(60, 0).func_78793_a(5.0f, 18.0f + f2, 0.0f);
        this.golemRightLeg.func_78790_a(-3.5f, -3.0f, -3.0f, 6, 16, 5, f1);
    }

    public void render(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.setRotationAngles(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        float scaleChild = entityIn.func_213355_cm();
        GlStateManager.pushMatrix();
        if (((GolemBase)((Object)entityIn)).func_70631_g_()) {
            GlStateManager.scalef((float)scaleChild, (float)scaleChild, (float)scaleChild);
            GlStateManager.translatef((float)0.0f, (float)(24.0f * scale), (float)0.0f);
        }
        this.golemHead.func_78785_a(scale);
        this.golemBody.func_78785_a(scale);
        this.golemLeftLeg.func_78785_a(scale);
        this.golemRightLeg.func_78785_a(scale);
        this.golemRightArm.func_78785_a(scale);
        this.golemLeftArm.func_78785_a(scale);
        GlStateManager.popMatrix();
    }

    public void setRotationAngles(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        this.golemHead.field_78796_g = netHeadYaw / 57.295776f;
        this.golemHead.field_78795_f = headPitch / 57.295776f;
        this.golemLeftLeg.field_78795_f = -1.5f * ModelGolem.triangleWave(limbSwing, 13.0f) * limbSwingAmount;
        this.golemRightLeg.field_78795_f = 1.5f * ModelGolem.triangleWave(limbSwing, 13.0f) * limbSwingAmount;
        this.golemLeftLeg.field_78796_g = 0.0f;
        this.golemRightLeg.field_78796_g = 0.0f;
    }

    public void setLivingAnimations(T entity, float limbSwing, float limbSwingAmount, float partialTickTime) {
        int i = entity.func_70854_o();
        if (i > 0) {
            this.golemRightArm.field_78795_f = -2.0f + 1.5f * ModelGolem.triangleWave((float)i - partialTickTime, 10.0f);
            this.golemLeftArm.field_78795_f = -2.0f + 1.5f * ModelGolem.triangleWave((float)i - partialTickTime, 10.0f);
        } else {
            this.golemRightArm.field_78795_f = (-0.2f + 1.5f * ModelGolem.triangleWave(limbSwing, 13.0f)) * limbSwingAmount;
            this.golemLeftArm.field_78795_f = (-0.2f - 1.5f * ModelGolem.triangleWave(limbSwing, 13.0f)) * limbSwingAmount;
        }
    }

    private static float triangleWave(float f1, float f2) {
        return (Math.abs(f1 % f2 - f2 * 0.5f) - f2 * 0.25f) / (f2 * 0.25f);
    }
}

