/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.renders;

import com.mcmoddev.golems.entity.base.GolemColorized;
import com.mcmoddev.golems.renders.RenderGolem;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.EntityRendererManager;

public class RenderColoredGolem
extends RenderGolem<GolemColorized> {
    public RenderColoredGolem(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
    }

    @Override
    public void doRender(GolemColorized golem, double x, double y, double z, float entityYaw, float partialTicks) {
        float colorRed = golem.getColorRed();
        float colorGreen = golem.getColorGreen();
        float colorBlue = golem.getColorBlue();
        float colorAlpha = golem.getColorAlpha();
        if (golem.hasBase()) {
            this.texture = golem.getTextureBase();
            super.doRender(golem, x, y, z, entityYaw, partialTicks);
        }
        GlStateManager.pushMatrix();
        GlStateManager.color4f((float)colorRed, (float)colorGreen, (float)colorBlue, (float)colorAlpha);
        if (golem.hasTransparency()) {
            GlStateManager.enableNormalize();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)770, (int)771);
        }
        if (golem.hasOverlay()) {
            this.texture = golem.getTextureToColor();
            super.doRender(golem, x, y, z, entityYaw, partialTicks);
        }
        if (golem.hasTransparency()) {
            GlStateManager.disableBlend();
            GlStateManager.disableNormalize();
        }
        GlStateManager.popMatrix();
    }

    @Override
    protected void bindGolemTexture(GolemColorized golem) {
    }
}

