/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.renders;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.main.ExtraGolemsEntities;
import com.mcmoddev.golems.renders.ModelGolem;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.util.ResourceLocation;

public class RenderGolem<T extends GolemBase>
extends LivingRenderer<T, ModelGolem<T>> {
    protected static final ResourceLocation fallbackTexture = ExtraGolemsEntities.makeTexture("golem_clay");
    protected ResourceLocation texture;
    protected static final ResourceLocation[] damageIndicators = new ResourceLocation[]{ExtraGolemsEntities.makeTexture("damage/damaged_0"), ExtraGolemsEntities.makeTexture("damage/damaged_1"), ExtraGolemsEntities.makeTexture("damage/damaged_2")};
    protected static final float DAMAGE_ALPHA = 0.55f;

    public RenderGolem(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new ModelGolem(), 0.5f);
    }

    protected void applyRotations(T golem, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_77043_a(golem, ageInTicks, rotationYaw, partialTicks);
        if ((double)((GolemBase)((Object)golem)).field_70721_aZ >= 0.01) {
            float f = 13.0f;
            float f1 = ((GolemBase)((Object)golem)).field_184619_aG - ((GolemBase)((Object)golem)).field_70721_aZ * (1.0f - partialTicks) + 6.0f;
            float f2 = (Math.abs(f1 % 13.0f - 6.5f) - 3.25f) / 3.25f;
            GlStateManager.rotatef((float)(6.5f * f2), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    public void doRender(T golem, double x, double y, double z, float entityYaw, float partialTicks) {
        this.bindGolemTexture(golem);
        super.func_76986_a(golem, x, y, z, entityYaw, partialTicks);
        this.renderDamage(golem, x, y, z, entityYaw, partialTicks);
    }

    protected void bindGolemTexture(T golem) {
        this.texture = ((GolemBase)((Object)golem)).getTexture();
    }

    protected void renderDamage(T golem, double x, double y, double z, float entityYaw, float partialTicks) {
        int index = Math.min(this.getDamageTexture(golem), damageIndicators.length - 1);
        if (index > -1) {
            GlStateManager.pushMatrix();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.55f);
            GlStateManager.enableNormalize();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)770, (int)771);
            this.texture = damageIndicators[index];
            super.func_76986_a(golem, x, y, z, entityYaw, partialTicks);
            GlStateManager.disableBlend();
            GlStateManager.disableNormalize();
            GlStateManager.popMatrix();
        }
    }

    protected ResourceLocation getEntityTexture(T golem) {
        return this.texture != null ? this.texture : fallbackTexture;
    }

    protected int getDamageTexture(T golem) {
        float percentHealth = golem.func_110143_aJ() / golem.func_110138_aP();
        return damageIndicators.length - (int)Math.ceil(percentHealth * 4.0f);
    }
}

