/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.util.config;

import com.mcmoddev.golems.util.config.GolemConfigurationSection;
import com.mcmoddev.golems.util.config.GolemContainer;
import com.mcmoddev.golems.util.config.GolemRegistrar;
import com.mcmoddev.golems.util.config.special.GolemSpecialContainer;
import com.mcmoddev.golems.util.config.special.GolemSpecialSection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;

public class GolemConfiguration {
    public final Map<GolemContainer, GolemConfigurationSection> sections = new HashMap<GolemContainer, GolemConfigurationSection>();
    public final Map<GolemSpecialContainer, GolemSpecialSection> specials = new HashMap<GolemSpecialContainer, GolemSpecialSection>();
    public final ForgeConfigSpec.BooleanValue bedrockGolemCreativeOnly;
    public final ForgeConfigSpec.BooleanValue pumpkinBuildsGolem;
    public final ForgeConfigSpec.BooleanValue enableFriendlyFire;
    public final ForgeConfigSpec.BooleanValue enableTextureInteract;
    public final ForgeConfigSpec.BooleanValue enableUseItemSpell;
    public final ForgeConfigSpec.BooleanValue enableHealGolems;
    public final ForgeConfigSpec.IntValue villagerGolemSpawnChance;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> villagerGolemSpawns;
    private static final String[] defaultVillagerGolemSpawns = new String[]{"golem_bookshelf", "golem_clay", "golem_coal", "golem_crafting", "golem_glass", "golem_glowstone", "golem_leaves", "golem_melon", "golem_shroom", "golem_obsidian", "golem_quartz", "golem_red_sandstone", "golem_sandstone", "golem_stained_glass", "golem_stained_clay", "golem_straw", "golem_hardened_clay", "golem_wooden", "golem_wool"};

    public GolemConfiguration(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        this.bedrockGolemCreativeOnly = builder.comment("When true, only players in creative mode can use a Bedrock Golem spawn item").define("bedrock_golem_creative_only", true);
        this.pumpkinBuildsGolem = builder.comment("When true, pumpkins can be used to build this mod's golems").define("pumpkin_builds_golems", false);
        this.enableFriendlyFire = builder.comment("When enabled, attacking a player-built golem will make it attack you").define("friendly_fire", true);
        this.enableTextureInteract = builder.comment("When enabled, some golems will change their texture when clicked").define("texture_interact", false);
        this.enableUseItemSpell = builder.comment("When enabled, players can 'use' the spell item on a carved pumpkin to convert it to a golem head in-world").define("use_spell", true);
        this.villagerGolemSpawnChance = builder.comment("Percent chance for a villager to successfully summon an Extra Golems golem").defineInRange("villager_summon_chance", 90, 0, 100);
        this.enableHealGolems = builder.comment("When enabled, giving blocks to golems can restore health").define("heal_golems", true);
        this.villagerGolemSpawns = builder.comment(new String[]{"Golems that can be summoned by villagers", "(Duplicate entries increase chances)"}).defineList("villager_summon_golems", GolemConfiguration.initVillagerGolemList(defaultVillagerGolemSpawns), o -> o instanceof String);
        builder.pop();
        for (GolemContainer c : GolemRegistrar.golemList.values()) {
            builder.push(c.getName());
            this.sections.put(c, new GolemConfigurationSection(c, builder));
            builder.push("specials");
            for (GolemSpecialContainer specialC : c.getSpecialContainers()) {
                this.specials.put(specialC, new GolemSpecialSection(specialC, builder));
            }
            builder.pop(2);
        }
    }

    public void loadData() {
        for (Map.Entry<GolemContainer, GolemConfigurationSection> e : this.sections.entrySet()) {
            GolemContainer c = e.getKey();
            GolemConfigurationSection section = e.getValue();
            c.setAttack((Double)section.attack.get());
            c.setHealth((Double)section.health.get());
            c.setEnabled((Boolean)section.enabled.get());
            for (GolemSpecialContainer specialC : c.getSpecialContainers()) {
                specialC.value = this.specials.get((Object)specialC).value;
            }
        }
    }

    private static List<String> initVillagerGolemList(String[] names) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : names) {
            list.add("golems".concat(":").concat(s));
        }
        return list;
    }

    public List<GolemContainer> loadVillagerGolemList() {
        ArrayList<GolemContainer> list = new ArrayList<GolemContainer>();
        for (String s : (List)this.villagerGolemSpawns.get()) {
            GolemContainer container;
            if (s == null || s.isEmpty() || (container = GolemRegistrar.getContainer(new ResourceLocation(s))) == null) continue;
            list.add(container);
        }
        return list;
    }
}

