/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.entity.hostile;

import com.legacy.farlanders.FarlandersLootTables;
import com.legacy.farlanders.client.audio.FarlandersSounds;
import com.legacy.farlanders.entity.hostile.EntityLooter;
import com.legacy.farlanders.entity.hostile.EntityRebel;
import com.legacy.farlanders.entity.util.IColoredEyes;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityEnderGuardian
extends EntityMob
implements IColoredEyes,
IRangedAttackMob {
    public static final DataParameter<Integer> EYE_COLOR = EntityDataManager.func_187226_a(EntityEnderGuardian.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> GUARDIAN_ATTACKING = EntityDataManager.func_187226_a(EntityEnderGuardian.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityEnderGuardian(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackRangedBow((EntityMob)this, 0.61, 20, 15.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 0.6, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLooter.class, false));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityRebel.class, false));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, false));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityEndermite.class, false));
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        return super.func_180482_a(difficulty, livingdata);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EYE_COLOR, (Object)this.field_70146_Z.nextInt(4));
        this.field_70180_af.func_187214_a(GUARDIAN_ATTACKING, (Object)false);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("EyeColor", this.getEyeColor());
        compound.func_74757_a("GuardianAttacking", this.getAttacking());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setEyeColor(compound.func_74762_e("EyeColor"));
        this.setAttacking(compound.func_74767_n("GuardianAttacking"));
    }

    public float func_70047_e() {
        return 1.6f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    public void func_70071_h_() {
        block5: {
            block7: {
                block6: {
                    block4: {
                        super.func_70071_h_();
                        if (this.func_70090_H()) {
                            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
                        }
                        if (this.getEyeColor() != 0) break block4;
                        for (int k = 0; k < 2; ++k) {
                            this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
                        }
                        break block5;
                    }
                    if (this.getEyeColor() != 1) break block6;
                    for (int k = 0; k < 2; ++k) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                    }
                    break block5;
                }
                if (this.getEyeColor() != 2) break block7;
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                break block5;
            }
            if (this.getEyeColor() != 3) break block5;
            for (int k = 0; k < 2; ++k) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SUSPENDED_DEPTH, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        if (entitylivingbaseIn != null) {
            this.setAttacking(true);
        } else {
            this.setAttacking(false);
        }
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
    }

    @Override
    public void setEyeColor(int colorID) {
        this.field_70180_af.func_187227_b(EYE_COLOR, (Object)colorID);
    }

    @Override
    public int getEyeColor() {
        return (Integer)this.field_70180_af.func_187225_a(EYE_COLOR);
    }

    public void setAttacking(boolean att) {
        this.field_70180_af.func_187227_b(GUARDIAN_ATTACKING, (Object)att);
    }

    public boolean getAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(GUARDIAN_ATTACKING);
    }

    protected SoundEvent func_184639_G() {
        return FarlandersSounds.ENTITY_ENDER_GUARDIAN_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        this.func_184185_a(FarlandersSounds.ENTITY_ENDER_GUARDIAN_HURT, 1.0f, 1.2f);
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return FarlandersSounds.ENTITY_ENDER_GUARDIAN_DEATH;
    }

    protected float func_70647_i() {
        return 1.7f;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        EntityArrow entityarrow = this.getArrow(distanceFactor);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    protected EntityArrow getArrow(float p_190726_1_) {
        EntityTippedArrow entitytippedarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        entitytippedarrow.func_190547_a((EntityLivingBase)this, p_190726_1_);
        return entitytippedarrow;
    }

    public void func_184724_a(boolean swingingArms) {
    }

    protected ResourceLocation func_184647_J() {
        return FarlandersLootTables.ender_guardian;
    }
}

