/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.entity.hostile;

import com.legacy.farlanders.FarlandersLootTables;
import com.legacy.farlanders.client.audio.FarlandersSounds;
import com.legacy.farlanders.entity.util.IColoredEyes;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityTitan
extends EntityMob
implements IColoredEyes {
    public static final DataParameter<Integer> EYE_COLOR = EntityDataManager.func_187226_a(EntityTitan.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> HOLDING_PLAYER = EntityDataManager.func_187226_a(EntityTitan.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> ANGRY = EntityDataManager.func_187226_a(EntityTitan.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> RAGE = EntityDataManager.func_187226_a(EntityTitan.class, (DataSerializer)DataSerializers.field_187198_h);
    private int attackTimer;
    private int holdingChance;
    private long holdingTimerInit;
    private long holdingTimerEnd;
    private EntityLivingBase entityRidingTitan;
    private int attackNumber;
    private float rageHealth;
    private long rageTimerInit;
    private long rageTimerEnd;

    public EntityTitan(World world) {
        super(world);
        this.func_70105_a(1.8f, 5.3f);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.rageTimerEnd = 0L;
        this.rageTimerInit = 0L;
        this.holdingChance = this.field_70146_Z.nextInt(15);
        this.attackNumber = -1;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.65, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, false));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityEndermite.class, false));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EYE_COLOR, (Object)this.field_70146_Z.nextInt(12));
        this.field_70180_af.func_187214_a(HOLDING_PLAYER, (Object)false);
        this.field_70180_af.func_187214_a(ANGRY, (Object)false);
        this.field_70180_af.func_187214_a(RAGE, (Object)false);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("EyeColor", this.getEyeColor());
        compound.func_74757_a("HoldingPlayer", this.getHoldingPlayer());
        compound.func_74757_a("IsAngry", this.getAngry());
        compound.func_74757_a("InRage", this.inRage());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setEyeColor(compound.func_74762_e("EyeColor"));
        this.setHoldingPlayer(compound.func_74767_n("HoldingPlayer"));
        this.setAngry(compound.func_74767_n("IsAngry"));
        this.setInRage(compound.func_74767_n("InRage"));
    }

    public float func_70047_e() {
        return 4.8f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(135.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.rageHealth = this.func_110138_aP() * 25.0f / 100.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70090_H()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        try {
            int k;
            int j;
            int i;
            IBlockState blockstate;
            if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            if (this.inRage()) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.getHoldingPlayer() && this.func_184187_bx() == null && !this.field_70170_p.field_72995_K && this.entityRidingTitan != null) {
                this.entityRidingTitan.func_184220_m((Entity)this);
            }
            if (this.func_110143_aJ() < this.getRageHealth() && !this.inRage() && !this.field_70170_p.field_72995_K) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 232));
                this.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 232));
                this.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 232));
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 232));
                this.func_70690_d(new PotionEffect(MobEffects.field_76432_h, 5));
                this.func_184185_a(SoundEvents.field_187942_hp, 1.0f, 1.0f);
                this.rageTimerInit = System.currentTimeMillis();
                this.setInRage(true);
            }
            if (this.inRage() && !this.field_70170_p.field_72995_K) {
                this.rageTimerEnd = System.currentTimeMillis() - this.rageTimerInit;
                if (this.rageTimerEnd > 15000L) {
                    this.setInRage(false);
                }
            }
            if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && (blockstate = this.field_70170_p.func_180495_p(new BlockPos(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v)))).func_185904_a() != Material.field_151579_a) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)blockstate)});
            }
            if (this.holdingChance == 1 && this.getHoldingPlayer() && !this.field_70170_p.field_72995_K && this.entityRidingTitan != null) {
                if (this.entityRidingTitan != null && !this.entityRidingTitan.func_70089_S()) {
                    this.holdingChance = 2;
                    this.setHoldingPlayer(false);
                    this.entityRidingTitan.func_184210_p();
                    this.setAngry(false);
                    this.entityRidingTitan = null;
                    this.attackNumber = -1;
                }
                this.holdingTimerEnd = System.currentTimeMillis() - this.holdingTimerInit;
                if (this.attackNumber == 0 && this.holdingTimerEnd > 5000L) {
                    this.holdingChance = 2;
                    this.setHoldingPlayer(false);
                    this.entityRidingTitan.func_184210_p();
                    this.setAngry(false);
                    this.entityRidingTitan = null;
                    this.attackNumber = -1;
                } else if (this.attackNumber == 1 && this.holdingTimerEnd > 3600L) {
                    this.holdingChance = 2;
                    this.setHoldingPlayer(false);
                    this.entityRidingTitan.func_184210_p();
                    this.setAngry(false);
                    this.entityRidingTitan = null;
                    this.attackNumber = -1;
                } else if (this.attackNumber == 2 && this.holdingTimerEnd > 2200L) {
                    this.holdingChance = 2;
                    this.setHoldingPlayer(false);
                    this.entityRidingTitan.func_184210_p();
                    this.setAngry(false);
                    this.entityRidingTitan = null;
                    this.attackNumber = -1;
                }
            } else {
                this.holdingChance = this.field_70146_Z.nextInt(15);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        if (this.holdingChance == 1 && !this.getHoldingPlayer()) {
            flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 0.0f);
            if (!this.field_70170_p.field_72995_K) {
                this.setHoldingPlayer(true);
                this.attackNumber = this.field_70146_Z.nextInt(3);
                this.holdingTimerInit = System.currentTimeMillis();
                entityIn.func_184220_m((Entity)this);
                this.setAngry(true);
                if (this.attackNumber == 0) {
                    this.field_70170_p.func_184133_a((EntityPlayer)null, this.func_180425_c(), FarlandersSounds.ENTITY_TITAN_HOLDING_LONG, SoundCategory.HOSTILE, 1.0f, 0.6f);
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 120));
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76431_k, 176));
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76437_t, 120));
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 120, 2));
                } else if (this.attackNumber == 1) {
                    this.field_70170_p.func_184133_a((EntityPlayer)null, this.func_180425_c(), FarlandersSounds.ENTITY_TITAN_HOLDING_MED, SoundCategory.HOSTILE, 1.0f, 0.6f);
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76431_k, 144));
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 80, 2));
                } else {
                    this.field_70170_p.func_184133_a((EntityPlayer)null, this.func_180425_c(), FarlandersSounds.ENTITY_TITAN_HOLDING_SHORT, SoundCategory.HOSTILE, 1.0f, 0.6f);
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 56, 1));
                }
                this.entityRidingTitan = (EntityLivingBase)entityIn;
            } else if (this.field_70170_p.field_72995_K) {
                if (this.attackNumber == 0) {
                    this.field_70170_p.func_184133_a((EntityPlayer)null, this.func_180425_c(), FarlandersSounds.ENTITY_TITAN_HOLDING_LONG, SoundCategory.HOSTILE, 1.0f, 0.6f);
                } else if (this.attackNumber == 1) {
                    this.field_70170_p.func_184133_a((EntityPlayer)null, this.func_180425_c(), FarlandersSounds.ENTITY_TITAN_HOLDING_MED, SoundCategory.HOSTILE, 1.0f, 0.6f);
                } else {
                    this.field_70170_p.func_184133_a((EntityPlayer)null, this.func_180425_c(), FarlandersSounds.ENTITY_TITAN_HOLDING_SHORT, SoundCategory.HOSTILE, 1.0f, 0.6f);
                }
            }
        } else {
            flag = this.getHoldingPlayer() ? entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f) : entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 8.0f);
        }
        if (flag) {
            entityIn.field_70181_x += 0.3000000059604645;
            entityIn.field_70179_y += 0.2000000059604645;
            entityIn.field_70159_w += 0.2000000059604645;
        }
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    protected SoundEvent func_184639_G() {
        return FarlandersSounds.ENTITY_TITAN_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        this.func_184185_a(FarlandersSounds.ENTITY_TITAN_HURT, 1.0f, 0.5f);
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return FarlandersSounds.ENTITY_TITAN_DEATH_ECHO;
    }

    protected void playStepSound(BlockPos pos, IBlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    protected float func_70647_i() {
        return 0.8f;
    }

    @Override
    public void setEyeColor(int colorID) {
        this.field_70180_af.func_187227_b(EYE_COLOR, (Object)colorID);
    }

    @Override
    public int getEyeColor() {
        return (Integer)this.field_70180_af.func_187225_a(EYE_COLOR);
    }

    public void setInRage(boolean rage) {
        this.field_70180_af.func_187227_b(RAGE, (Object)rage);
    }

    public boolean inRage() {
        return (Boolean)this.field_70180_af.func_187225_a(RAGE);
    }

    public void setHoldingPlayer(boolean hold) {
        this.field_70180_af.func_187227_b(HOLDING_PLAYER, (Object)hold);
    }

    public boolean getHoldingPlayer() {
        return (Boolean)this.field_70180_af.func_187225_a(HOLDING_PLAYER);
    }

    public void setAngry(boolean ang) {
        this.field_70180_af.func_187227_b(ANGRY, (Object)ang);
    }

    public boolean getAngry() {
        return (Boolean)this.field_70180_af.func_187225_a(ANGRY);
    }

    public float getRageHealth() {
        return this.rageHealth;
    }

    protected ResourceLocation func_184647_J() {
        return FarlandersLootTables.titan;
    }
}

