/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.entity.passive;

import com.legacy.farlanders.client.audio.FarlandersSounds;
import com.legacy.farlanders.entity.ai.EntityAIMoveIndoorsDaytime;
import com.legacy.farlanders.entity.hostile.EntityLooter;
import com.legacy.farlanders.entity.hostile.EntityRebel;
import com.legacy.farlanders.item.ItemsFarlanders;
import java.util.Collections;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataFixer;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.village.Village;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFarlander
extends EntityAgeable
implements INpc,
IMerchant {
    public static final DataParameter<Integer> EYE_COLOR = EntityDataManager.func_187226_a(EntityFarlander.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(EntityFarlander.class, (DataSerializer)DataSerializers.field_187192_b);
    private int randomTickDivider;
    private boolean isMating;
    private boolean isPlaying;
    Village village;
    @Nullable
    private EntityPlayer buyingPlayer;
    @Nullable
    protected MerchantRecipeList buyingList;
    private int timeUntilReset;
    private boolean needsInitilization;
    private boolean isWillingToMate;
    private int wealth;
    private UUID lastBuyingPlayer;
    private int careerLevel;
    private boolean isLookingForHome;
    private int particleEffect;

    public EntityFarlander(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.8f);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityZombie.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityRebel.class, 12.0f, 0.8, 0.8));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityLooter.class, 8.0f, 0.8, 0.8));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoorsDaytime((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    protected void func_70619_bc() {
        if (--this.randomTickDivider <= 0) {
            BlockPos blockpos = new BlockPos((Entity)this);
            this.field_70170_p.func_175714_ae().func_176060_a(blockpos);
            this.randomTickDivider = 70 + this.field_70146_Z.nextInt(50);
            this.village = this.field_70170_p.func_175714_ae().func_176056_a(blockpos, 32);
            if (this.village == null) {
                this.func_110177_bN();
            } else {
                BlockPos blockpos1 = this.village.func_180608_a();
                this.func_175449_a(blockpos1, this.village.func_75568_b());
                if (this.isLookingForHome) {
                    this.isLookingForHome = false;
                    this.village.func_82683_b(5);
                }
            }
        }
        if (!this.isTrading() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.needsInitilization) {
                    for (MerchantRecipe merchantrecipe : this.buyingList) {
                        if (!merchantrecipe.func_82784_g()) continue;
                        merchantrecipe.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
                    }
                    this.populateBuyingList();
                    this.needsInitilization = false;
                    if (this.village != null && this.lastBuyingPlayer != null) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)14);
                        this.village.modifyPlayerReputation(this.lastBuyingPlayer, 1);
                    }
                }
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 0));
            }
        }
        super.func_70619_bc();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (((Object)((Object)this)).getClass() == EntityFarlander.class) {
            if (this.getEyeColor() == 0) {
                for (int k = 0; k < 2; ++k) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
                }
            } else if (this.getEyeColor() == 1) {
                for (int k = 0; k < 2; ++k) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                }
            } else if (this.getEyeColor() == 2) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            } else if (this.getEyeColor() == 3) {
                for (int k = 0; k < 2; ++k) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SUSPENDED_DEPTH, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
                }
            } else if (this.getEyeColor() == 4) {
                ++this.particleEffect;
                if (this.particleEffect == 3) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                    this.particleEffect = 0;
                }
            } else if (this.getEyeColor() == 5) {
                ++this.particleEffect;
                if (this.particleEffect == 1) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, 0.5 + this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
                    this.particleEffect = 0;
                }
            }
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = itemstack.func_77973_b() == Items.field_151057_cb;
        if (flag) {
            itemstack.func_111282_a(player, (EntityLivingBase)this, hand);
            return true;
        }
        if (!(this.func_190669_a(itemstack, ((Object)((Object)this)).getClass()) || !this.func_70089_S() || this.isTrading() || this.func_70631_g_() || player.func_70093_af())) {
            if (this.buyingList == null) {
                this.populateBuyingList();
            }
            if (hand == EnumHand.MAIN_HAND) {
                player.func_71029_a(StatList.field_188074_H);
            }
            if (!this.field_70170_p.field_72995_K && !this.buyingList.isEmpty()) {
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
            } else if (this.buyingList.isEmpty()) {
                return super.func_184645_a(player, hand);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EYE_COLOR, (Object)this.field_70146_Z.nextInt(6));
    }

    public static void registerFixesVillager(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityFarlander.class);
        fixer.func_188258_a(FixTypes.ENTITY, (IDataWalker)new ItemStackDataLists(EntityFarlander.class, new String[]{"Inventory"}));
        fixer.func_188258_a(FixTypes.ENTITY, new IDataWalker(){

            public NBTTagCompound func_188266_a(IDataFixer fixer, NBTTagCompound compound, int versionIn) {
                NBTTagCompound nbttagcompound;
                if (EntityList.func_191306_a(EntityFarlander.class).equals((Object)new ResourceLocation(compound.func_74779_i("id"))) && compound.func_150297_b("Offers", 10) && (nbttagcompound = compound.func_74775_l("Offers")).func_150297_b("Recipes", 9)) {
                    NBTTagList nbttaglist = nbttagcompound.func_150295_c("Recipes", 10);
                    for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                        NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                        DataFixesManager.func_188277_a((IDataFixer)fixer, (NBTTagCompound)nbttagcompound1, (int)versionIn, (String)"buy");
                        DataFixesManager.func_188277_a((IDataFixer)fixer, (NBTTagCompound)nbttagcompound1, (int)versionIn, (String)"buyB");
                        DataFixesManager.func_188277_a((IDataFixer)fixer, (NBTTagCompound)nbttagcompound1, (int)versionIn, (String)"sell");
                        nbttaglist.func_150304_a(i, (NBTBase)nbttagcompound1);
                    }
                }
                return compound;
            }
        });
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Riches", this.wealth);
        compound.func_74768_a("CareerLevel", this.careerLevel);
        compound.func_74757_a("Willing", this.isWillingToMate);
        compound.func_74768_a("EyeColor", this.getEyeColor());
        if (this.buyingList != null) {
            compound.func_74782_a("Offers", (NBTBase)this.buyingList.func_77202_a());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.wealth = compound.func_74762_e("Riches");
        this.careerLevel = compound.func_74762_e("CareerLevel");
        this.isWillingToMate = compound.func_74767_n("Willing");
        this.setEyeColor(compound.func_74762_e("EyeColor"));
        if (compound.func_150297_b("Offers", 10)) {
            NBTTagCompound nbttagcompound = compound.func_74775_l("Offers");
            this.buyingList = new MerchantRecipeList(nbttagcompound);
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return FarlandersSounds.ENTITY_FARLANDER_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return FarlandersSounds.ENTITY_FARLANDER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return FarlandersSounds.ENTITY_FARLANDER_DEATH;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_191184_at;
    }

    public boolean isMating() {
        return this.isMating;
    }

    public void setMating(boolean mating) {
        this.isMating = mating;
    }

    public void setPlaying(boolean playing) {
        this.isPlaying = playing;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void func_70604_c(@Nullable EntityLivingBase livingBase) {
        super.func_70604_c(livingBase);
        if (this.village != null && livingBase != null) {
            this.village.func_75575_a(livingBase);
            if (livingBase instanceof EntityPlayer) {
                int i = -1;
                if (this.func_70631_g_()) {
                    i = -3;
                }
                this.village.modifyPlayerReputation(livingBase.func_110124_au(), i);
                if (this.func_70089_S()) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)13);
                }
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (this.village != null) {
            Entity entity = cause.func_76346_g();
            if (entity != null) {
                if (entity instanceof EntityPlayer) {
                    this.village.modifyPlayerReputation(entity.func_110124_au(), -2);
                } else if (entity instanceof IMob) {
                    this.village.func_82692_h();
                }
            } else {
                EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, 16.0);
                if (entityplayer != null) {
                    this.village.func_82692_h();
                }
            }
        }
        super.func_70645_a(cause);
    }

    public void setEyeColor(int colorID) {
        this.field_70180_af.func_187227_b(EYE_COLOR, (Object)colorID);
    }

    public int getEyeColor() {
        return (Integer)this.field_70180_af.func_187225_a(EYE_COLOR);
    }

    public void func_70932_a_(@Nullable EntityPlayer player) {
        this.buyingPlayer = player;
    }

    @Nullable
    public EntityPlayer func_70931_l_() {
        return this.buyingPlayer;
    }

    public boolean isTrading() {
        return this.buyingPlayer != null;
    }

    public void setIsWillingToMate(boolean isWillingToMate) {
        this.isWillingToMate = isWillingToMate;
    }

    public void func_70933_a(MerchantRecipe recipe) {
        recipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        this.func_184185_a(FarlandersSounds.ENTITY_FARLANDER_IDLE, this.func_70599_aP(), this.func_70647_i() + 0.2f);
        int i = 3 + this.field_70146_Z.nextInt(4);
        if (recipe.func_180321_e() == 1 || this.field_70146_Z.nextInt(5) == 0) {
            this.timeUntilReset = 40;
            this.needsInitilization = true;
            this.isWillingToMate = true;
            this.lastBuyingPlayer = this.buyingPlayer != null ? this.buyingPlayer.func_110124_au() : null;
            i += 5;
        }
        if (recipe.func_77394_a().func_77973_b() == ItemsFarlanders.endumium_crystal) {
            this.wealth += recipe.func_77394_a().func_190916_E();
        }
        if (recipe.func_180322_j()) {
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, i));
        }
    }

    public void func_110297_a_(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
        }
    }

    @Nullable
    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        if (this.buyingList == null) {
            this.populateBuyingList();
        }
        return this.buyingList;
    }

    private void populateBuyingList() {
        this.careerLevel = this.careerLevel != 0 ? ++this.careerLevel : 1;
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        this.addDefaultTrades(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70930_a(@Nullable MerchantRecipeList recipeList) {
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos func_190671_u_() {
        return new BlockPos((Entity)this);
    }

    public float func_70047_e() {
        return this.func_70631_g_() ? 0.81f : 1.62f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 12) {
            this.spawnParticles(EnumParticleTypes.HEART);
        } else if (id == 13) {
            this.spawnParticles(EnumParticleTypes.VILLAGER_ANGRY);
        } else if (id == 14) {
            this.spawnParticles(EnumParticleTypes.VILLAGER_HAPPY);
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(EnumParticleTypes particleType) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        return this.finalizeMobSpawn(difficulty, livingdata, true);
    }

    public IEntityLivingData finalizeMobSpawn(DifficultyInstance p_190672_1_, @Nullable IEntityLivingData p_190672_2_, boolean p_190672_3_) {
        p_190672_2_ = super.func_180482_a(p_190672_1_, p_190672_2_);
        this.populateBuyingList();
        return p_190672_2_;
    }

    public void setLookingForHome() {
        this.isLookingForHome = true;
    }

    public EntityFarlander createChild(EntityAgeable ageable) {
        EntityFarlander entityvillager = new EntityFarlander(this.field_70170_p);
        entityvillager.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityvillager)), null);
        return entityvillager;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    protected void addDefaultTrades(int amount) {
        MerchantRecipeList list = new MerchantRecipeList();
        EntityFarlander.addMerchantItem2(list, Items.field_151065_br, this.field_70146_Z, 0.9f, 2, 1 + this.field_70146_Z.nextInt(2));
        EntityFarlander.addMerchantItem2(list, Items.field_151072_bj, this.field_70146_Z, 0.5f, 2, 1 + this.field_70146_Z.nextInt(3));
        EntityFarlander.addMerchantItem2(list, Items.field_151103_aS, this.field_70146_Z, 0.5f, 1, 1 + this.field_70146_Z.nextInt(5));
        EntityFarlander.addMerchantItem2(list, Items.field_151119_aD, this.field_70146_Z, 0.4f, 2, 1 + this.field_70146_Z.nextInt(20));
        EntityFarlander.addMerchantItem2(list, Items.field_151044_h, this.field_70146_Z, 0.8f, 1, 1 + this.field_70146_Z.nextInt(10));
        EntityFarlander.addMerchantItem3(list, Items.field_151166_bC, this.field_70146_Z, 0.7f, 1, 1);
        EntityFarlander.addMerchantItem2(list, Items.field_151166_bC, this.field_70146_Z, 0.7f, 1, 1);
        EntityFarlander.addMerchantItem2(list, Items.field_151079_bi, this.field_70146_Z, 0.5f, 2, 1 + this.field_70146_Z.nextInt(3));
        EntityFarlander.addMerchantItem2(list, Items.field_151062_by, this.field_70146_Z, 0.5f, 3, 1 + this.field_70146_Z.nextInt(2));
        EntityFarlander.addMerchantItem2(list, Items.field_151071_bq, this.field_70146_Z, 0.5f, 2, 1 + this.field_70146_Z.nextInt(3));
        EntityFarlander.addMerchantItem2(list, Items.field_151059_bz, this.field_70146_Z, 0.5f, 2, 1 + this.field_70146_Z.nextInt(2));
        EntityFarlander.addMerchantItem2(list, Items.field_151145_ak, this.field_70146_Z, 0.5f, 1, 1 + this.field_70146_Z.nextInt(10));
        EntityFarlander.addMerchantItem2(list, Items.field_151073_bk, this.field_70146_Z, 0.5f, 3, 1 + this.field_70146_Z.nextInt(2));
        EntityFarlander.addMerchantItem2(list, Items.field_151043_k, this.field_70146_Z, 0.5f, 2, 1 + this.field_70146_Z.nextInt(4));
        EntityFarlander.addMerchantItem2(list, Items.field_151016_H, this.field_70146_Z, 0.3f, 2, 1 + this.field_70146_Z.nextInt(3));
        EntityFarlander.addMerchantItem2(list, Items.field_151042_j, this.field_70146_Z, 0.5f, 3, 1 + this.field_70146_Z.nextInt(5));
        EntityFarlander.addMerchantItem2(list, Items.field_151114_aO, this.field_70146_Z, 0.5f, 2, 1 + this.field_70146_Z.nextInt(10));
        EntityFarlander.addMerchantItem2(list, Items.field_151064_bs, this.field_70146_Z, 0.5f, 3, 1 + this.field_70146_Z.nextInt(2));
        EntityFarlander.addMerchantItem2(list, Items.field_151081_bc, this.field_70146_Z, 0.5f, 2, 1 + this.field_70146_Z.nextInt(7));
        EntityFarlander.addMerchantItem2(list, Items.field_151075_bm, this.field_70146_Z, 0.5f, 3, 1 + this.field_70146_Z.nextInt(5));
        EntityFarlander.addMerchantItem2(list, Items.field_151080_bb, this.field_70146_Z, 0.5f, 2, 1 + this.field_70146_Z.nextInt(7));
        EntityFarlander.addMerchantItem2(list, Items.field_151137_ax, this.field_70146_Z, 0.5f, 2, 1 + this.field_70146_Z.nextInt(15));
        EntityFarlander.addMerchantItem2(list, Items.field_151123_aH, this.field_70146_Z, 0.5f, 3, 1 + this.field_70146_Z.nextInt(2));
        EntityFarlander.addMerchantItem2(list, Items.field_151070_bp, this.field_70146_Z, 0.5f, 1, 1 + this.field_70146_Z.nextInt(5));
        EntityFarlander.addMerchantItem2(list, Items.field_151032_g, this.field_70146_Z, 0.5f, 3, 1 + this.field_70146_Z.nextInt(15));
        EntityFarlander.addMerchantItem2(list, Items.field_151060_bw, this.field_70146_Z, 0.5f, 3, 1 + this.field_70146_Z.nextInt(3));
        EntityFarlander.addMerchantItem2(list, Item.func_150898_a((Block)Blocks.field_150369_x), this.field_70146_Z, 0.5f, 2, 1 + this.field_70146_Z.nextInt(2));
        EntityFarlander.addMerchantItem2(list, Items.field_151172_bF, this.field_70146_Z, 0.5f, 2, 1 + this.field_70146_Z.nextInt(7));
        EntityFarlander.addMerchantItem2(list, Items.field_151174_bG, this.field_70146_Z, 0.5f, 2, 1 + this.field_70146_Z.nextInt(7));
        EntityFarlander.addMerchantItem3(list, Items.field_151042_j, this.field_70146_Z, 0.5f, 1, 1);
        EntityFarlander.addMerchantItem3(list, (Item)Items.field_151097_aZ, this.field_70146_Z, 0.5f, 1, 1);
        EntityFarlander.addMerchantItem3(list, Items.field_151117_aB, this.field_70146_Z, 0.5f, 1, 1);
        EntityFarlander.addMerchantItem3(list, Items.field_151129_at, this.field_70146_Z, 0.5f, 2, 1);
        EntityFarlander.addMerchantItem3(list, (Item)Items.field_151148_bJ, this.field_70146_Z, 0.5f, 1, 1);
        EntityFarlander.addMerchantItem3(list, Items.field_151111_aL, this.field_70146_Z, 0.5f, 2, 1);
        EntityFarlander.addMerchantItem3(list, Items.field_151113_aN, this.field_70146_Z, 0.5f, 3, 1);
        EntityFarlander.addMerchantItem3(list, Items.field_151043_k, this.field_70146_Z, 0.5f, 2, 1);
        EntityFarlander.addMerchantItem3(list, Items.field_151152_bP, this.field_70146_Z, 0.5f, 1, 1);
        EntityFarlander.addMerchantItem3(list, Items.field_151059_bz, this.field_70146_Z, 0.5f, 1, 1);
        EntityFarlander.addMerchantItem3(list, Items.field_151159_an, this.field_70146_Z, 0.5f, 1, 1);
        if (this.field_70146_Z.nextFloat() < 0.5f) {
            list.add((Object)new MerchantRecipe(new ItemStack(Items.field_151043_k, 1 + this.field_70146_Z.nextInt(5)), new ItemStack(ItemsFarlanders.endumium_crystal, 1 + this.field_70146_Z.nextInt(3)), new ItemStack(Items.field_151045_i, this.field_70146_Z.nextInt(2), 0)));
        }
        if (this.field_70146_Z.nextFloat() < 0.5f) {
            list.add((Object)new MerchantRecipe(new ItemStack(Items.field_151079_bi, 1 + this.field_70146_Z.nextInt(4)), new ItemStack(ItemsFarlanders.endumium_crystal, 1 + this.field_70146_Z.nextInt(2)), new ItemStack(Items.field_151061_bv, this.field_70146_Z.nextInt(2), 0)));
        }
        if (this.field_70146_Z.nextFloat() < 0.5f) {
            list.add((Object)new MerchantRecipe(new ItemStack(Items.field_151074_bl, 3 + this.field_70146_Z.nextInt(4)), new ItemStack(ItemsFarlanders.endumium_crystal, 1 + this.field_70146_Z.nextInt(2)), new ItemStack(Items.field_151043_k, 1 + this.field_70146_Z.nextInt(2), 0)));
        }
        Collections.shuffle(list);
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        for (int var8 = 0; var8 < amount && var8 < list.size(); ++var8) {
            this.buyingList.add((Object)((MerchantRecipe)list.get(var8)));
        }
    }

    protected static void addMerchantItem2(MerchantRecipeList par0MerchantRecipeList, Item clayBall, Random par2Random, float par3, int amountRuby, int amountItem) {
        ItemStack var5 = new ItemStack(ItemsFarlanders.endumium_crystal, amountRuby, 0);
        ItemStack var6 = new ItemStack(clayBall, amountItem, 0);
        if (par2Random.nextFloat() < par3) {
            par0MerchantRecipeList.add((Object)new MerchantRecipe(var5, var6));
        }
    }

    protected static void addMerchantItem3(MerchantRecipeList par0MerchantRecipeList, Item emerald, Random par2Random, float par3, int amountRuby, int amountItem) {
        ItemStack var5 = new ItemStack(ItemsFarlanders.endumium_crystal, amountRuby, 0);
        ItemStack var6 = new ItemStack(emerald, amountItem, 0);
        if (par2Random.nextFloat() < par3) {
            par0MerchantRecipeList.add((Object)new MerchantRecipe(var6, var5));
        }
    }
}

