/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.world;

import com.legacy.farlanders.FarlandersLootTables;
import com.legacy.farlanders.entity.hostile.EntityEnderGolem;
import com.legacy.farlanders.entity.hostile.EntityTitan;
import java.util.Random;
import net.minecraft.block.BlockPane;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenFarlanderLoot
extends WorldGenerator {
    private IBlockState replaceID;

    public WorldGenFarlanderLoot(IBlockState replace) {
        super(true);
        this.replaceID = replace;
    }

    public boolean locationIsValidSpawn(World world, int i, int j, int k) {
        int distanceToAir = 0;
        IBlockState checkID = world.func_180495_p(new BlockPos(i, j, k));
        while (checkID != Blocks.field_150350_a.func_176223_P()) {
            checkID = world.func_180495_p(new BlockPos(i, j + ++distanceToAir, k));
        }
        if (distanceToAir > 2) {
            return false;
        }
        IBlockState blockID = world.func_180495_p(new BlockPos(i, j += distanceToAir - 1, k));
        IBlockState blockIDAbove = world.func_180495_p(new BlockPos(i, j + 1, k));
        IBlockState blockIDBelow = world.func_180495_p(new BlockPos(i, j - 1, k));
        if (blockIDAbove != Blocks.field_150350_a.func_176223_P()) {
            return false;
        }
        if (blockID.func_177230_c() == Blocks.field_150433_aE && blockIDBelow == this.replaceID || blockID.func_177230_c() == Blocks.field_150349_c && blockIDBelow == this.replaceID || blockID == Blocks.field_150328_O.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_150327_N.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_150330_I.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_150434_aF.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_150338_P.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_150337_Q.func_176223_P() && blockIDBelow == this.replaceID) {
            return true;
        }
        return blockID == this.replaceID;
    }

    public boolean airLocationIsValidSpawn(World world, int i, int j, int k) {
        IBlockState blockID = world.func_180495_p(new BlockPos(i, j, k));
        IBlockState blockIDAbove = world.func_180495_p(new BlockPos(i, j + 1, k));
        return blockID == Blocks.field_150350_a.func_176223_P() && blockIDAbove == Blocks.field_150350_a.func_176223_P();
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        int doorSide = random.nextInt(2);
        IBlockState whiteStone = Blocks.field_150377_bs.func_176223_P();
        IBlockState ironFence = Blocks.field_150411_aY.func_176223_P();
        if (!(this.locationIsValidSpawn(world, i - 1, j, k - 2) && this.locationIsValidSpawn(world, i + 3, j, k - 2) && this.locationIsValidSpawn(world, i + 3, j, k + 2) && this.locationIsValidSpawn(world, i - 1, j, k + 2) && this.airLocationIsValidSpawn(world, i - 1, j + 3, k - 2) && this.airLocationIsValidSpawn(world, i + 3, j + 3, k - 2) && this.airLocationIsValidSpawn(world, i + 3, j + 3, k + 2) && this.airLocationIsValidSpawn(world, i - 1, j + 3, k + 2))) {
            return false;
        }
        world.func_180501_a(new BlockPos(i, j, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i, j, k - 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i, j + 1, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i, j + 1, k - 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i, j + 2, k), whiteStone, 2);
        world.func_180501_a(new BlockPos(i, j + 2, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i, j + 2, k - 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j, k - 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k), Blocks.field_150350_a.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 1), ironFence.func_177226_a((IProperty)BlockPane.field_176242_M, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockPane.field_176244_O, (Comparable)Boolean.valueOf(true)), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k - 1), ironFence.func_177226_a((IProperty)BlockPane.field_176242_M, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockPane.field_176244_O, (Comparable)Boolean.valueOf(true)), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k - 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k), Blocks.field_150333_U.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 2, j, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 2, j, k - 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k - 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k - 1), whiteStone, 2);
        if (doorSide != 0) {
            world.func_180501_a(new BlockPos(i + 2, j, k), whiteStone, 2);
            world.func_180501_a(new BlockPos(i + 2, j + 1, k), whiteStone, 2);
        } else {
            world.func_180501_a(new BlockPos(i + 2, j, k), ironFence.func_177226_a((IProperty)BlockPane.field_176241_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockPane.field_176243_N, (Comparable)Boolean.valueOf(true)), 2);
            world.func_180501_a(new BlockPos(i + 2, j + 1, k), ironFence.func_177226_a((IProperty)BlockPane.field_176241_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockPane.field_176243_N, (Comparable)Boolean.valueOf(true)), 2);
        }
        if (doorSide != 1) {
            world.func_180501_a(new BlockPos(i, j, k), whiteStone, 2);
            world.func_180501_a(new BlockPos(i, j + 1, k), whiteStone, 2);
        } else {
            world.func_180501_a(new BlockPos(i, j, k), ironFence, 2);
            world.func_180501_a(new BlockPos(i, j + 1, k), ironFence, 2);
        }
        world.func_180501_a(new BlockPos(i + 1, j, k), Blocks.field_150486_ae.func_176223_P(), 2);
        TileEntityChest tile = (TileEntityChest)world.func_175625_s(new BlockPos(i + 1, j, k));
        tile.func_189404_a(FarlandersLootTables.small_loot_chest, world.field_73012_v.nextLong());
        world.func_180501_a(new BlockPos(i, j, k - 2), Blocks.field_150350_a.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i, j + 1, k - 2), Blocks.field_150350_a.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i, j + 2, k - 2), Blocks.field_150350_a.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 3, j, k), Blocks.field_150350_a.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k), Blocks.field_150350_a.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k), Blocks.field_150350_a.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i - 1, j, k), Blocks.field_150350_a.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i - 1, j + 1, k), Blocks.field_150350_a.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i - 1, j + 2, k), Blocks.field_150350_a.func_176223_P(), 2);
        for (int posX = i; posX <= i + 8; ++posX) {
            for (int posZ = k; posZ <= k + 6; ++posZ) {
                int posY = j - 1;
                boolean isFloorFinished = false;
                while (!isFloorFinished) {
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150350_a.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150349_c.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150434_aF.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150328_O.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150327_N.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150330_I.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150433_aE.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150355_j.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150353_l.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150338_P.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150337_Q.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150392_bi.func_176223_P()) {
                        world.func_180501_a(new BlockPos(posX, posY, posZ), whiteStone, 2);
                        --posY;
                        continue;
                    }
                    isFloorFinished = true;
                }
            }
        }
        if (random.nextInt(5) == 0) {
            EntityTitan var7 = new EntityTitan(world);
            var7.func_70107_b(i - 1, j + 1, k);
            var7.func_110163_bv();
            world.func_72838_d((Entity)var7);
        } else {
            EntityEnderGolem var5 = new EntityEnderGolem(world);
            var5.func_70107_b(i - 1, j + 1, k);
            var5.func_110163_bv();
            world.func_72838_d((Entity)var5);
        }
        return true;
    }
}

