/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.world.village;

import com.legacy.farlanders.entity.hostile.EntityEnderGuardian;
import com.legacy.farlanders.entity.passive.EntityFarlander;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class VillageHouseSmallDoor
extends WorldGenerator {
    private static final IBlockState planks = Blocks.field_150344_f.func_176223_P();
    private static final IBlockState wood = Blocks.field_150364_r.func_176223_P();
    private static final IBlockState thinGlass = Blocks.field_150410_aZ.func_176223_P();
    private static final IBlockState whiteStone = Blocks.field_150377_bs.func_176223_P();
    private static final IBlockState fence = Blocks.field_180407_aO.func_176223_P();
    private static final Block door = Blocks.field_180413_ao;
    private static final IBlockState dirt = Blocks.field_150346_d.func_176223_P();
    private static final IBlockState air = Blocks.field_150350_a.func_176223_P();

    protected IBlockState[] getValidSpawnBlocks() {
        return new IBlockState[]{Blocks.field_150431_aC.func_176223_P(), Blocks.field_150354_m.func_176223_P(), Blocks.field_150348_b.func_176223_P(), Blocks.field_150349_c.func_176223_P()};
    }

    public boolean locationIsValidSpawn(World world, int i, int j, int k) {
        int distanceToAir = 0;
        IBlockState checkID = world.func_180495_p(new BlockPos(i, j, k));
        while (checkID != Blocks.field_150350_a.func_176223_P()) {
            checkID = world.func_180495_p(new BlockPos(i, j + ++distanceToAir, k));
        }
        if (distanceToAir > 2) {
            return false;
        }
        IBlockState blockID = world.func_180495_p(new BlockPos(i, j += distanceToAir - 1, k));
        IBlockState blockIDAbove = world.func_180495_p(new BlockPos(i, j + 1, k));
        IBlockState blockIDBelow = world.func_180495_p(new BlockPos(i, j - 1, k));
        for (IBlockState x : this.getValidSpawnBlocks()) {
            if (blockIDAbove != Blocks.field_150350_a.func_176223_P()) {
                return false;
            }
            if (blockID.func_177230_c() == Blocks.field_150433_aE && blockIDBelow == x || blockID.func_177230_c() == Blocks.field_150349_c && blockIDBelow == x || blockID == Blocks.field_150328_O.func_176223_P() && blockIDBelow == x || blockID == Blocks.field_150327_N.func_176223_P() && blockIDBelow == x || blockID == Blocks.field_150330_I.func_176223_P() && blockIDBelow == x || blockID == Blocks.field_150434_aF.func_176223_P() && blockIDBelow == x || blockID == Blocks.field_150338_P.func_176223_P() && blockIDBelow == x || blockID == Blocks.field_150337_Q.func_176223_P() && blockIDBelow == x) {
                return true;
            }
            if (blockID != x) continue;
            return true;
        }
        return false;
    }

    public boolean checkAllLocations(World world, int i, int j, int k) {
        return this.locationIsValidSpawn(world, i, j, k) && this.locationIsValidSpawn(world, i + 5, j, k) && this.locationIsValidSpawn(world, i + 5, j, k + 3) && this.locationIsValidSpawn(world, i, j, k + 3) && this.airlocationIsValidSpawn(world, i, j + 6, k) && this.airlocationIsValidSpawn(world, i + 5, j + 6, k) && this.airlocationIsValidSpawn(world, i + 5, j + 6, k + 3) && this.airlocationIsValidSpawn(world, i, j + 6, k + 3);
    }

    public boolean airlocationIsValidSpawn(World world, int i, int j, int k) {
        IBlockState blockID = world.func_180495_p(new BlockPos(i, j, k));
        IBlockState blockIDAbove = world.func_180495_p(new BlockPos(i, j + 1, k));
        return blockID == air && blockIDAbove == air;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int k;
        int j;
        int i = pos.func_177958_n();
        if (!(this.locationIsValidSpawn(world, i, j = pos.func_177956_o(), k = pos.func_177952_p()) && this.locationIsValidSpawn(world, i + 5, j, k) && this.locationIsValidSpawn(world, i + 5, j, k + 3) && this.locationIsValidSpawn(world, i, j, k + 3) && this.airlocationIsValidSpawn(world, i, j + 6, k) && this.airlocationIsValidSpawn(world, i + 5, j + 6, k) && this.airlocationIsValidSpawn(world, i + 5, j + 6, k + 3) && this.airlocationIsValidSpawn(world, i, j + 6, k + 3))) {
            return false;
        }
        world.func_175656_a(new BlockPos(i + 0, j + 1, k + 0), air);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 1), Blocks.field_150446_ar.func_176203_a(0), 2);
        world.func_175656_a(new BlockPos(i + 0, j + 1, k + 2), air);
        world.func_175656_a(new BlockPos(i + 0, j + 1, k + 3), air);
        world.func_175656_a(new BlockPos(i + 0, j + 2, k + 0), air);
        world.func_175656_a(new BlockPos(i + 0, j + 2, k + 1), air);
        world.func_175656_a(new BlockPos(i + 0, j + 2, k + 2), air);
        world.func_175656_a(new BlockPos(i + 0, j + 2, k + 3), air);
        world.func_175656_a(new BlockPos(i + 0, j + 3, k + 0), air);
        world.func_175656_a(new BlockPos(i + 0, j + 3, k + 1), air);
        world.func_175656_a(new BlockPos(i + 0, j + 3, k + 2), air);
        world.func_175656_a(new BlockPos(i + 0, j + 3, k + 3), air);
        world.func_175656_a(new BlockPos(i + 0, j + 4, k + 0), air);
        world.func_175656_a(new BlockPos(i + 0, j + 4, k + 1), air);
        world.func_175656_a(new BlockPos(i + 0, j + 4, k + 2), air);
        world.func_175656_a(new BlockPos(i + 0, j + 4, k + 3), air);
        world.func_175656_a(new BlockPos(i + 0, j + 5, k + 0), air);
        world.func_175656_a(new BlockPos(i + 0, j + 5, k + 1), air);
        world.func_175656_a(new BlockPos(i + 0, j + 5, k + 2), air);
        world.func_175656_a(new BlockPos(i + 0, j + 5, k + 3), air);
        world.func_175656_a(new BlockPos(i + 0, j + 6, k + 0), air);
        world.func_175656_a(new BlockPos(i + 0, j + 6, k + 1), air);
        world.func_175656_a(new BlockPos(i + 0, j + 6, k + 2), air);
        world.func_175656_a(new BlockPos(i + 0, j + 6, k + 3), air);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 0), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 2), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 3), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 0), wood, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 2), planks, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 3), wood, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 0), wood, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 2), planks, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 3), wood, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 0), wood, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 1), planks, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 2), planks, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 3), wood, 2);
        world.func_175656_a(new BlockPos(i + 1, j + 5, k + 0), air);
        world.func_180501_a(new BlockPos(i + 1, j + 5, k + 1), wood, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 5, k + 2), wood, 2);
        world.func_175656_a(new BlockPos(i + 1, j + 5, k + 3), air);
        world.func_175656_a(new BlockPos(i + 1, j + 6, k + 0), air);
        world.func_175656_a(new BlockPos(i + 1, j + 6, k + 1), air);
        world.func_175656_a(new BlockPos(i + 1, j + 6, k + 2), air);
        world.func_175656_a(new BlockPos(i + 1, j + 6, k + 3), air);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 0), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 3), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 0), planks, 2);
        world.func_175656_a(new BlockPos(i + 2, j + 2, k + 1), air);
        world.func_175656_a(new BlockPos(i + 2, j + 2, k + 2), air);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 3), planks, 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 0), planks, 2);
        world.func_175656_a(new BlockPos(i + 2, j + 3, k + 1), air);
        world.func_175656_a(new BlockPos(i + 2, j + 3, k + 2), air);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 3), planks, 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 0), planks, 2);
        world.func_175656_a(new BlockPos(i + 2, j + 4, k + 1), air);
        world.func_175656_a(new BlockPos(i + 2, j + 4, k + 2), air);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 3), planks, 2);
        world.func_180501_a(new BlockPos(i + 2, j + 5, k + 0), wood, 2);
        world.func_175656_a(new BlockPos(i + 2, j + 5, k + 1), air);
        world.func_175656_a(new BlockPos(i + 2, j + 5, k + 2), air);
        world.func_180501_a(new BlockPos(i + 2, j + 5, k + 3), wood, 2);
        world.func_175656_a(new BlockPos(i + 2, j + 6, k + 0), air);
        world.func_180501_a(new BlockPos(i + 2, j + 6, k + 1), wood, 2);
        world.func_180501_a(new BlockPos(i + 2, j + 6, k + 2), wood, 2);
        world.func_175656_a(new BlockPos(i + 2, j + 6, k + 3), air);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 0), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 3), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 0), planks, 2);
        world.func_175656_a(new BlockPos(i + 3, j + 2, k + 1), air);
        world.func_175656_a(new BlockPos(i + 3, j + 2, k + 2), air);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 3), planks, 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 0), thinGlass, 2);
        world.func_175656_a(new BlockPos(i + 3, j + 3, k + 1), air);
        world.func_175656_a(new BlockPos(i + 3, j + 3, k + 2), air);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 3), thinGlass, 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 0), planks, 2);
        world.func_175656_a(new BlockPos(i + 3, j + 4, k + 1), air);
        world.func_175656_a(new BlockPos(i + 3, j + 4, k + 2), air);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 3), planks, 2);
        world.func_180501_a(new BlockPos(i + 3, j + 5, k + 0), wood, 2);
        world.func_175656_a(new BlockPos(i + 3, j + 5, k + 1), air);
        world.func_175656_a(new BlockPos(i + 3, j + 5, k + 2), air);
        world.func_180501_a(new BlockPos(i + 3, j + 5, k + 3), wood, 2);
        world.func_175656_a(new BlockPos(i + 3, j + 6, k + 0), air);
        world.func_180501_a(new BlockPos(i + 3, j + 6, k + 1), wood, 2);
        world.func_180501_a(new BlockPos(i + 3, j + 6, k + 2), wood, 2);
        world.func_175656_a(new BlockPos(i + 3, j + 6, k + 3), air);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 0), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 3), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 0), planks, 2);
        world.func_175656_a(new BlockPos(i + 4, j + 2, k + 1), air);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 2), fence, 2);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 3), planks, 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 0), planks, 2);
        world.func_175656_a(new BlockPos(i + 4, j + 3, k + 1), air);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 3), planks, 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 0), planks, 2);
        world.func_175656_a(new BlockPos(i + 4, j + 4, k + 1), air);
        world.func_175656_a(new BlockPos(i + 4, j + 4, k + 2), air);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 3), planks, 2);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 0), wood, 2);
        world.func_175656_a(new BlockPos(i + 4, j + 5, k + 1), air);
        world.func_175656_a(new BlockPos(i + 4, j + 5, k + 2), air);
        world.func_180501_a(new BlockPos(i + 4, j + 5, k + 3), wood, 2);
        world.func_175656_a(new BlockPos(i + 4, j + 6, k + 0), air);
        world.func_180501_a(new BlockPos(i + 4, j + 6, k + 1), wood, 2);
        world.func_180501_a(new BlockPos(i + 4, j + 6, k + 2), wood, 2);
        world.func_175656_a(new BlockPos(i + 4, j + 6, k + 3), air);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 0), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 2), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 3), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 0), wood, 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 1), planks, 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 2), planks, 2);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 3), wood, 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 0), wood, 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 1), planks, 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 2), planks, 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 3), wood, 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 0), wood, 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 1), planks, 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 2), planks, 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 3), wood, 2);
        world.func_175656_a(new BlockPos(i + 5, j + 5, k + 0), air);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 1), wood, 2);
        world.func_180501_a(new BlockPos(i + 5, j + 5, k + 2), wood, 2);
        world.func_175656_a(new BlockPos(i + 5, j + 5, k + 3), air);
        world.func_175656_a(new BlockPos(i + 5, j + 6, k + 0), air);
        world.func_175656_a(new BlockPos(i + 5, j + 6, k + 1), air);
        world.func_175656_a(new BlockPos(i + 5, j + 6, k + 2), air);
        world.func_175656_a(new BlockPos(i + 5, j + 6, k + 3), air);
        world.func_175656_a(new BlockPos(i + 2, j + 1, k + 1), dirt);
        world.func_175656_a(new BlockPos(i + 2, j + 1, k + 2), dirt);
        world.func_175656_a(new BlockPos(i + 3, j + 1, k + 1), dirt);
        world.func_175656_a(new BlockPos(i + 3, j + 1, k + 2), dirt);
        world.func_175656_a(new BlockPos(i + 4, j + 1, k + 1), dirt);
        world.func_175656_a(new BlockPos(i + 4, j + 1, k + 2), dirt);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 1), door.func_176203_a(0), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 1), door.func_176203_a(8), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 2), Blocks.field_150452_aw.func_176223_P(), 2);
        for (int posX = i; posX <= i + 5; ++posX) {
            for (int posZ = k; posZ <= k + 3; ++posZ) {
                int posY = j;
                boolean isFloorFinished = false;
                while (!isFloorFinished) {
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)) == air || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150329_H.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150434_aF.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150328_O.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150327_N.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150330_I.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150431_aC.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150355_j.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150353_l.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150338_P.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150337_Q.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150392_bi.func_176223_P()) {
                        world.func_180501_a(new BlockPos(posX, posY, posZ), whiteStone, 2);
                        --posY;
                        continue;
                    }
                    isFloorFinished = true;
                }
            }
        }
        EntityFarlander farlander = new EntityFarlander(world);
        farlander.func_70107_b(i - 1, j + 2, k + 1);
        world.func_72838_d((Entity)farlander);
        EntityEnderGuardian guardian = new EntityEnderGuardian(world);
        guardian.func_70107_b(i - 1, j + 2, k);
        guardian.func_110163_bv();
        world.func_72838_d((Entity)guardian);
        return true;
    }
}

