/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.world.village;

import com.legacy.farlanders.FarlandersConfig;
import com.legacy.farlanders.item.ItemsFarlanders;
import com.legacy.farlanders.world.village.VillageRoad;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class VillageWell
extends WorldGenerator {
    private static final IBlockState air = Blocks.field_150350_a.func_176223_P();

    protected IBlockState[] getValidSpawnBlocks() {
        return new IBlockState[]{Blocks.field_150431_aC.func_176223_P(), Blocks.field_150354_m.func_176223_P(), Blocks.field_150348_b.func_176223_P(), Blocks.field_150349_c.func_176223_P()};
    }

    public boolean locationIsValidSpawn(World world, int i, int j, int k) {
        int distanceToAir = 0;
        IBlockState checkID = world.func_180495_p(new BlockPos(i, j, k));
        while (checkID != Blocks.field_150350_a.func_176223_P()) {
            checkID = world.func_180495_p(new BlockPos(i, j + ++distanceToAir, k));
        }
        if (distanceToAir > 2) {
            return false;
        }
        IBlockState blockID = world.func_180495_p(new BlockPos(i, j += distanceToAir - 1, k));
        IBlockState blockIDAbove = world.func_180495_p(new BlockPos(i, j + 1, k));
        IBlockState blockIDBelow = world.func_180495_p(new BlockPos(i, j - 1, k));
        for (IBlockState x : this.getValidSpawnBlocks()) {
            if (blockIDAbove != Blocks.field_150350_a.func_176223_P()) {
                return false;
            }
            if (blockID.func_177230_c() == Blocks.field_150433_aE && blockIDBelow == x || blockID.func_177230_c() == Blocks.field_150349_c && blockIDBelow == x || blockID == Blocks.field_150328_O.func_176223_P() && blockIDBelow == x || blockID == Blocks.field_150327_N.func_176223_P() && blockIDBelow == x || blockID == Blocks.field_150330_I.func_176223_P() && blockIDBelow == x || blockID == Blocks.field_150434_aF.func_176223_P() && blockIDBelow == x || blockID == Blocks.field_150338_P.func_176223_P() && blockIDBelow == x || blockID == Blocks.field_150337_Q.func_176223_P() && blockIDBelow == x) {
                return true;
            }
            if (blockID != x) continue;
            return true;
        }
        return false;
    }

    public boolean airlocationIsValidSpawn(World world, int i, int j, int k) {
        IBlockState blockID = world.func_180495_p(new BlockPos(i, j, k));
        IBlockState blockIDAbove = world.func_180495_p(new BlockPos(i, j + 1, k));
        return blockID == Blocks.field_150350_a.func_176223_P() && blockIDAbove == Blocks.field_150350_a.func_176223_P();
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        IBlockState whiteStone = Blocks.field_150377_bs.func_176223_P();
        if (!(this.locationIsValidSpawn(world, i, j, k) && this.locationIsValidSpawn(world, i + 5, j, k) && this.locationIsValidSpawn(world, i + 5, j, k + 5) && this.locationIsValidSpawn(world, i, j, k + 5) && this.airlocationIsValidSpawn(world, i, j + 4, k) && this.airlocationIsValidSpawn(world, i + 5, j + 4, k) && this.airlocationIsValidSpawn(world, i + 5, j + 4, k + 5) && this.airlocationIsValidSpawn(world, i, j + 4, k + 5))) {
            return false;
        }
        if (world.func_180495_p(new BlockPos(i, j, k)) == Blocks.field_150354_m.func_176223_P() && rand.nextInt((50 - FarlandersConfig.structures.villageSpawnRate) * 500) != 1) {
            return false;
        }
        if (!new VillageRoad().canAllHousesSpawn(world, i, j, k)) {
            return false;
        }
        world.func_175656_a(new BlockPos(i + 0, j + 1, k + 0), air);
        world.func_175656_a(new BlockPos(i + 0, j + 1, k + 1), air);
        world.func_175656_a(new BlockPos(i + 0, j + 1, k + 2), air);
        world.func_175656_a(new BlockPos(i + 0, j + 1, k + 3), air);
        world.func_175656_a(new BlockPos(i + 0, j + 1, k + 4), air);
        world.func_175656_a(new BlockPos(i + 0, j + 1, k + 5), air);
        world.func_175656_a(new BlockPos(i + 0, j + 2, k + 0), air);
        world.func_175656_a(new BlockPos(i + 0, j + 2, k + 1), air);
        world.func_175656_a(new BlockPos(i + 0, j + 2, k + 2), air);
        world.func_175656_a(new BlockPos(i + 0, j + 2, k + 3), air);
        world.func_175656_a(new BlockPos(i + 0, j + 2, k + 4), air);
        world.func_175656_a(new BlockPos(i + 0, j + 2, k + 5), air);
        world.func_175656_a(new BlockPos(i + 0, j + 3, k + 0), air);
        world.func_175656_a(new BlockPos(i + 0, j + 3, k + 1), air);
        world.func_175656_a(new BlockPos(i + 0, j + 3, k + 2), air);
        world.func_175656_a(new BlockPos(i + 0, j + 3, k + 3), air);
        world.func_175656_a(new BlockPos(i + 0, j + 3, k + 4), air);
        world.func_175656_a(new BlockPos(i + 0, j + 3, k + 5), air);
        world.func_175656_a(new BlockPos(i + 0, j + 4, k + 0), air);
        world.func_175656_a(new BlockPos(i + 0, j + 4, k + 1), air);
        world.func_175656_a(new BlockPos(i + 0, j + 4, k + 2), air);
        world.func_175656_a(new BlockPos(i + 0, j + 4, k + 3), air);
        world.func_175656_a(new BlockPos(i + 0, j + 4, k + 4), air);
        world.func_175656_a(new BlockPos(i + 0, j + 4, k + 5), air);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 2), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 3), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 4), whiteStone, 2);
        world.func_175656_a(new BlockPos(i + 1, j + 1, k + 0), air);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 2), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 3), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 4), whiteStone, 2);
        world.func_175656_a(new BlockPos(i + 1, j + 1, k + 5), air);
        world.func_175656_a(new BlockPos(i + 1, j + 2, k + 0), air);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 1), Blocks.field_180407_aO.func_176223_P(), 2);
        world.func_175656_a(new BlockPos(i + 1, j + 2, k + 2), air);
        world.func_175656_a(new BlockPos(i + 1, j + 2, k + 3), air);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 4), Blocks.field_180407_aO.func_176223_P(), 2);
        world.func_175656_a(new BlockPos(i + 1, j + 2, k + 5), air);
        world.func_175656_a(new BlockPos(i + 1, j + 3, k + 0), air);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 1), Blocks.field_180407_aO.func_176223_P(), 2);
        world.func_175656_a(new BlockPos(i + 1, j + 3, k + 2), air);
        world.func_175656_a(new BlockPos(i + 1, j + 3, k + 3), air);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 4), Blocks.field_180407_aO.func_176223_P(), 2);
        world.func_175656_a(new BlockPos(i + 1, j + 3, k + 5), air);
        world.func_175656_a(new BlockPos(i + 1, j + 4, k + 0), air);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 2), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 3), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 4), whiteStone, 2);
        world.func_175656_a(new BlockPos(i + 1, j + 4, k + 5), air);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 4), whiteStone, 2);
        world.func_175656_a(new BlockPos(i + 2, j + 1, k + 0), air);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 1), whiteStone, 2);
        world.func_175656_a(new BlockPos(i + 2, j + 1, k + 2), air);
        world.func_175656_a(new BlockPos(i + 2, j + 1, k + 3), air);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 4), whiteStone, 2);
        world.func_175656_a(new BlockPos(i + 2, j + 1, k + 5), air);
        world.func_175656_a(new BlockPos(i + 2, j + 2, k + 0), air);
        world.func_175656_a(new BlockPos(i + 2, j + 2, k + 1), air);
        world.func_175656_a(new BlockPos(i + 2, j + 2, k + 2), air);
        world.func_175656_a(new BlockPos(i + 2, j + 2, k + 3), air);
        world.func_175656_a(new BlockPos(i + 2, j + 2, k + 4), air);
        world.func_175656_a(new BlockPos(i + 2, j + 2, k + 5), air);
        world.func_175656_a(new BlockPos(i + 2, j + 3, k + 0), air);
        world.func_175656_a(new BlockPos(i + 2, j + 3, k + 1), air);
        world.func_175656_a(new BlockPos(i + 2, j + 3, k + 2), air);
        world.func_175656_a(new BlockPos(i + 2, j + 3, k + 3), air);
        world.func_175656_a(new BlockPos(i + 2, j + 3, k + 4), air);
        world.func_175656_a(new BlockPos(i + 2, j + 3, k + 5), air);
        world.func_175656_a(new BlockPos(i + 2, j + 4, k + 0), air);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 2), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 3), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 4), whiteStone, 2);
        world.func_175656_a(new BlockPos(i + 2, j + 4, k + 5), air);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 4), whiteStone, 2);
        world.func_175656_a(new BlockPos(i + 3, j + 1, k + 0), air);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 1), whiteStone, 2);
        world.func_175656_a(new BlockPos(i + 3, j + 1, k + 2), air);
        world.func_175656_a(new BlockPos(i + 3, j + 1, k + 3), air);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 4), whiteStone, 2);
        world.func_175656_a(new BlockPos(i + 3, j + 1, k + 5), air);
        world.func_175656_a(new BlockPos(i + 3, j + 2, k + 0), air);
        world.func_175656_a(new BlockPos(i + 3, j + 2, k + 1), air);
        world.func_175656_a(new BlockPos(i + 3, j + 2, k + 2), air);
        world.func_175656_a(new BlockPos(i + 3, j + 2, k + 3), air);
        world.func_175656_a(new BlockPos(i + 3, j + 2, k + 4), air);
        world.func_175656_a(new BlockPos(i + 3, j + 2, k + 5), air);
        world.func_175656_a(new BlockPos(i + 3, j + 3, k + 0), air);
        world.func_175656_a(new BlockPos(i + 3, j + 3, k + 1), air);
        world.func_175656_a(new BlockPos(i + 3, j + 3, k + 2), air);
        world.func_175656_a(new BlockPos(i + 3, j + 3, k + 3), air);
        world.func_175656_a(new BlockPos(i + 3, j + 3, k + 4), air);
        world.func_175656_a(new BlockPos(i + 3, j + 3, k + 5), air);
        world.func_175656_a(new BlockPos(i + 3, j + 4, k + 0), air);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 2), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 3), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 4), whiteStone, 2);
        world.func_175656_a(new BlockPos(i + 3, j + 4, k + 5), air);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 2), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 3), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 4), whiteStone, 2);
        world.func_175656_a(new BlockPos(i + 4, j + 1, k + 0), air);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 2), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 3), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 4), whiteStone, 2);
        world.func_175656_a(new BlockPos(i + 4, j + 1, k + 5), air);
        world.func_175656_a(new BlockPos(i + 4, j + 2, k + 0), air);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 1), Blocks.field_180407_aO.func_176223_P(), 2);
        world.func_175656_a(new BlockPos(i + 4, j + 2, k + 2), air);
        world.func_175656_a(new BlockPos(i + 4, j + 2, k + 3), air);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 4), Blocks.field_180407_aO.func_176223_P(), 2);
        world.func_175656_a(new BlockPos(i + 4, j + 2, k + 5), air);
        world.func_175656_a(new BlockPos(i + 4, j + 3, k + 0), air);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 1), Blocks.field_180407_aO.func_176223_P(), 2);
        world.func_175656_a(new BlockPos(i + 4, j + 3, k + 2), air);
        world.func_175656_a(new BlockPos(i + 4, j + 3, k + 3), air);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 4), Blocks.field_180407_aO.func_176223_P(), 2);
        world.func_175656_a(new BlockPos(i + 4, j + 3, k + 5), air);
        world.func_175656_a(new BlockPos(i + 4, j + 4, k + 0), air);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 2), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 3), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 4), whiteStone, 2);
        world.func_175656_a(new BlockPos(i + 4, j + 4, k + 5), air);
        world.func_175656_a(new BlockPos(i + 5, j + 1, k + 0), air);
        world.func_175656_a(new BlockPos(i + 5, j + 1, k + 1), air);
        world.func_175656_a(new BlockPos(i + 5, j + 1, k + 2), air);
        world.func_175656_a(new BlockPos(i + 5, j + 1, k + 3), air);
        world.func_175656_a(new BlockPos(i + 5, j + 1, k + 4), air);
        world.func_175656_a(new BlockPos(i + 5, j + 1, k + 5), air);
        world.func_175656_a(new BlockPos(i + 5, j + 2, k + 0), air);
        world.func_175656_a(new BlockPos(i + 5, j + 2, k + 1), air);
        world.func_175656_a(new BlockPos(i + 5, j + 2, k + 2), air);
        world.func_175656_a(new BlockPos(i + 5, j + 2, k + 3), air);
        world.func_175656_a(new BlockPos(i + 5, j + 2, k + 4), air);
        world.func_175656_a(new BlockPos(i + 5, j + 2, k + 5), air);
        world.func_175656_a(new BlockPos(i + 5, j + 3, k + 0), air);
        world.func_175656_a(new BlockPos(i + 5, j + 3, k + 1), air);
        world.func_175656_a(new BlockPos(i + 5, j + 3, k + 2), air);
        world.func_175656_a(new BlockPos(i + 5, j + 3, k + 3), air);
        world.func_175656_a(new BlockPos(i + 5, j + 3, k + 4), air);
        world.func_175656_a(new BlockPos(i + 5, j + 3, k + 5), air);
        world.func_175656_a(new BlockPos(i + 5, j + 4, k + 0), air);
        world.func_175656_a(new BlockPos(i + 5, j + 4, k + 1), air);
        world.func_175656_a(new BlockPos(i + 5, j + 4, k + 2), air);
        world.func_175656_a(new BlockPos(i + 5, j + 4, k + 3), air);
        world.func_175656_a(new BlockPos(i + 5, j + 4, k + 4), air);
        world.func_175656_a(new BlockPos(i + 5, j + 4, k + 5), air);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 0), Blocks.field_150351_n.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 1), Blocks.field_150351_n.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 2), Blocks.field_150351_n.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 3), Blocks.field_150351_n.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 4), Blocks.field_150351_n.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 0, j + 0, k + 5), Blocks.field_150351_n.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 0), Blocks.field_150351_n.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 0, k + 5), Blocks.field_150351_n.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 0), Blocks.field_150351_n.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 5), Blocks.field_150351_n.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 0), Blocks.field_150351_n.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 5), Blocks.field_150351_n.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 0), Blocks.field_150351_n.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 0, k + 5), Blocks.field_150351_n.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 0), Blocks.field_150351_n.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 1), Blocks.field_150351_n.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 2), Blocks.field_150351_n.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 3), Blocks.field_150351_n.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 4), Blocks.field_150351_n.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 0, k + 5), Blocks.field_150351_n.func_176223_P(), 2);
        world.func_175656_a(new BlockPos(i + 2, j - 1, k + 2), air);
        world.func_175656_a(new BlockPos(i + 2, j - 1, k + 3), air);
        world.func_175656_a(new BlockPos(i + 3, j - 1, k + 2), air);
        world.func_175656_a(new BlockPos(i + 3, j - 1, k + 3), air);
        for (int posX = i; posX <= i + 5; ++posX) {
            for (int posZ = k; posZ <= k + 5; ++posZ) {
                int posY = j - 1;
                boolean isFloorFinished = false;
                while (!isFloorFinished) {
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)) == air || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150349_c.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150434_aF.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150328_O.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150327_N.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150330_I.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() == Blocks.field_150433_aE || world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() == Blocks.field_150353_l || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150338_P.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150337_Q.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150392_bi.func_176223_P()) {
                        world.func_180501_a(new BlockPos(posX, posY, posZ), whiteStone, 2);
                        --posY;
                        continue;
                    }
                    isFloorFinished = true;
                }
            }
        }
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 2), Blocks.field_150355_j.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 0, k + 3), Blocks.field_150355_j.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 2), Blocks.field_150355_j.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 0, k + 3), Blocks.field_150355_j.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 2, j - 1, k + 2), Blocks.field_150355_j.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 2, j - 1, k + 3), Blocks.field_150355_j.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 3, j - 1, k + 2), Blocks.field_150355_j.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 3, j - 1, k + 3), Blocks.field_150355_j.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 2, j - 2, k + 2), Blocks.field_150355_j.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 2, j - 2, k + 3), Blocks.field_150355_j.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 3, j - 2, k + 2), Blocks.field_150355_j.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 3, j - 2, k + 3), Blocks.field_150486_ae.func_176223_P(), 2);
        TileEntityChest chest = new TileEntityChest();
        world.func_175690_a(new BlockPos(i + 3, j - 2, k + 3), (TileEntity)chest);
        for (int slot = 0; slot < chest.func_70302_i_(); ++slot) {
            int num = rand.nextInt(100);
            if (num == 0) {
                chest.func_70299_a(slot, new ItemStack(ItemsFarlanders.endumium_crystal));
                continue;
            }
            if (num == 1) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151166_bC));
                continue;
            }
            if (num == 2) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151043_k));
                continue;
            }
            if (num == 3) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151042_j));
                continue;
            }
            if (num == 4) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151065_br));
                continue;
            }
            if (num == 5) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151072_bj));
                continue;
            }
            if (num == 6) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151044_h));
                continue;
            }
            if (num == 7) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151062_by));
                continue;
            }
            if (num == 8) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151070_bp));
                continue;
            }
            if (num == 9) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151123_aH));
                continue;
            }
            if (num == 10) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151075_bm));
                continue;
            }
            if (num == 11) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151064_bs));
                continue;
            }
            if (num == 12) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151016_H));
                continue;
            }
            if (num == 13) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151073_bk));
                continue;
            }
            if (num == 14) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151074_bl));
                continue;
            }
            if (num == 15) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151071_bq));
                continue;
            }
            if (num == 16) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151059_bz));
                continue;
            }
            if (num == 17) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151145_ak));
                continue;
            }
            if (num == 18) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151079_bi));
                continue;
            }
            if (num == 19) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151061_bv));
                continue;
            }
            if (num == 20) {
                chest.func_70299_a(slot, new ItemStack(ItemsFarlanders.ender_horn));
                continue;
            }
            if (num != 21) continue;
            chest.func_70299_a(slot, new ItemStack(ItemsFarlanders.titan_hide));
        }
        new VillageRoad().func_180709_b(world, rand, new BlockPos(i, j, k));
        return true;
    }
}

