/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="farlanders", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FarlandersConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ServerConfig SERVER;
    public static int smallHouseSpawnRate;
    public static int mediumHouseSpawnRate;
    public static int largeHouseSpawnRate;
    public static int elderHouseSpawnRate;
    public static int farlanderLootWellSpawnRate;
    public static int obsidianSpireSpawnRate;
    public static boolean disableLooterStealing;

    private static String translate(String key) {
        return new String("farlanders.config." + key + ".name");
    }

    @SubscribeEvent
    public static void onLoadConfig(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == CLIENT_SPEC) {
            ConfigBakery.bakeClient(config);
        } else if (config.getSpec() == SERVER_SPEC) {
            ConfigBakery.bakeServer(config);
        }
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)pair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)pair.getRight();
        pair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER = (ServerConfig)pair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)pair.getRight();
    }

    private static class ConfigBakery {
        private static ModConfig clientConfig;
        private static ModConfig serverConfig;

        private ConfigBakery() {
        }

        public static void bakeClient(ModConfig config) {
            clientConfig = config;
            smallHouseSpawnRate = (Integer)FarlandersConfig.SERVER.smallHouseSpawnRate.get();
            mediumHouseSpawnRate = (Integer)FarlandersConfig.SERVER.mediumHouseSpawnRate.get();
            largeHouseSpawnRate = (Integer)FarlandersConfig.SERVER.largeHouseSpawnRate.get();
            elderHouseSpawnRate = (Integer)FarlandersConfig.SERVER.elderHouseSpawnRate.get();
            farlanderLootWellSpawnRate = (Integer)FarlandersConfig.SERVER.farlanderLootWellSpawnRate.get();
            obsidianSpireSpawnRate = (Integer)FarlandersConfig.SERVER.obsidianSpireSpawnRate.get();
            disableLooterStealing = (Boolean)FarlandersConfig.SERVER.disableLooterStealing.get();
        }

        public static void bakeServer(ModConfig config) {
            serverConfig = config;
        }
    }

    private static class ServerConfig {
        public final ForgeConfigSpec.ConfigValue<Integer> smallHouseSpawnRate;
        public final ForgeConfigSpec.ConfigValue<Integer> mediumHouseSpawnRate;
        public final ForgeConfigSpec.ConfigValue<Integer> largeHouseSpawnRate;
        public final ForgeConfigSpec.ConfigValue<Integer> elderHouseSpawnRate;
        public final ForgeConfigSpec.ConfigValue<Integer> farlanderLootWellSpawnRate;
        public final ForgeConfigSpec.ConfigValue<Integer> obsidianSpireSpawnRate;
        public final ForgeConfigSpec.ConfigValue<Boolean> disableLooterStealing;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Server and Client side changes.").push("common");
            this.smallHouseSpawnRate = builder.translation(FarlandersConfig.translate("smallHouseSpawnRate")).comment("Small Farlander house rarity (higher number = lower spawnrate)").define("smallHouseSpawnRate", (Object)4);
            this.mediumHouseSpawnRate = builder.translation(FarlandersConfig.translate("mediumHouseSpawnRate")).comment("Medium Farlander house rarity (higher number = lower spawnrate)").define("mediumHouseSpawnRate", (Object)5);
            this.largeHouseSpawnRate = builder.translation(FarlandersConfig.translate("largeHouseSpawnRate")).comment("Large Farlander house rarity (higher number = lower spawnrate)").define("largeHouseSpawnRate", (Object)7);
            this.elderHouseSpawnRate = builder.translation(FarlandersConfig.translate("elderHouseSpawnRate")).comment("Elder Farlander house rarity (higher number = lower spawnrate)").define("elderHouseSpawnRate", (Object)8);
            this.farlanderLootWellSpawnRate = builder.translation(FarlandersConfig.translate("farlanderLootWellSpawnRate")).comment("Farlander Loot Well rarity (higher number = lower spawnrate)").define("farlanderLootWellSpawnRate", (Object)15);
            this.obsidianSpireSpawnRate = builder.translation(FarlandersConfig.translate("obsidianSpireSpawnRate")).comment("Obsidian Spire rarity (higher number = lower spawnrate)").define("obsidianSpireSpawnRate", (Object)3);
            this.disableLooterStealing = builder.translation(FarlandersConfig.translate("disableLooterStealing")).comment("Disables the Looter's ability to take the player's weapon (This makes them spawn with a random weapon, good or bad)").define("disableLooterStealing", false);
            builder.pop();
        }
    }

    private static class ClientConfig {
        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Client side changes.").push("client");
            builder.pop();
        }
    }
}

