/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.client.render.entity;

import com.legacy.farlanders.TheFarlandersMod;
import com.legacy.farlanders.client.render.entity.layer.GlowingEyeLayer;
import com.legacy.farlanders.client.render.entity.layer.MiniDragonDeathLayer;
import com.legacy.farlanders.client.render.model.MiniDragonModel;
import com.legacy.farlanders.entity.hostile.boss.summon.MiniDragonEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MiniDragonRenderer
extends MobRenderer<MiniDragonEntity, MiniDragonModel> {
    private static final ResourceLocation DRAGON_TEXTURES = TheFarlandersMod.locate("textures/entity/mini_dragon/mini_dragon.png");
    private static final ResourceLocation EYES = TheFarlandersMod.locate("textures/entity/mini_dragon/dragon_eyes.png");

    public MiniDragonRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, (EntityModel)new MiniDragonModel(0.0f), 0.5f);
        this.func_177094_a(new GlowingEyeLayer(this, EYES));
        this.func_177094_a(new MiniDragonDeathLayer((IEntityRenderer<MiniDragonEntity, MiniDragonModel>)this));
    }

    protected void applyRotations(MiniDragonEntity entityLiving, float ageInTicks, float rotationYaw, float partialTicks) {
        float f = (float)entityLiving.getMovementOffsets(7, partialTicks)[0];
        float f1 = (float)(entityLiving.getMovementOffsets(5, partialTicks)[1] - entityLiving.getMovementOffsets(10, partialTicks)[1]);
        GlStateManager.rotatef((float)(-f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)(f1 * 10.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)1.0f);
        if (entityLiving.field_70725_aQ > 0) {
            float f2 = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f2 = MathHelper.func_76129_c((float)f2)) > 1.0f) {
                f2 = 1.0f;
            }
            GlStateManager.rotatef((float)(f2 * this.func_77037_a((LivingEntity)entityLiving)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected void renderModel(MiniDragonEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        GlStateManager.scalef((float)0.7f, (float)0.7f, (float)0.7f);
        this.func_180548_c((Entity)entitylivingbaseIn);
        ((MiniDragonModel)this.field_77045_g).render(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
        if (entitylivingbaseIn.field_70737_aN > 0) {
            GlStateManager.depthFunc((int)514);
            GlStateManager.disableTexture();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            ((MiniDragonModel)this.field_77045_g).render(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            GlStateManager.enableTexture();
            GlStateManager.disableBlend();
            GlStateManager.depthFunc((int)515);
        }
    }

    protected ResourceLocation getEntityTexture(MiniDragonEntity entity) {
        return DRAGON_TEXTURES;
    }
}

