/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.entity.hostile;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class ClassicEndermanEntity
extends MonsterEntity {
    private static final UUID ATTACKING_SPEED_BOOST_ID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier ATTACKING_SPEED_BOOST = new AttributeModifier(ATTACKING_SPEED_BOOST_ID, "Attacking speed boost", (double)0.15f, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final DataParameter<Optional<BlockState>> CARRIED_BLOCK = EntityDataManager.func_187226_a(ClassicEndermanEntity.class, (IDataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<Boolean> SCREAMING = EntityDataManager.func_187226_a(ClassicEndermanEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Predicate<LivingEntity> field_213627_bA = p_213626_0_ -> p_213626_0_ instanceof EndermiteEntity && ((EndermiteEntity)p_213626_0_).func_175495_n();
    private int lastCreepySound;
    private int targetChangeTime;

    public ClassicEndermanEntity(EntityType<? extends ClassicEndermanEntity> p_i50210_1_, World p_i50210_2_) {
        super(p_i50210_1_, p_i50210_2_);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new StareGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(10, (Goal)new PlaceBlockGoal(this));
        this.field_70714_bg.func_75776_a(11, (Goal)new TakeBlockGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new FindPlayerGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EndermiteEntity.class, 10, true, false, field_213627_bA));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (entitylivingbaseIn == null) {
            this.targetChangeTime = 0;
            this.field_70180_af.func_187227_b(SCREAMING, (Object)false);
            iattributeinstance.func_111124_b(ATTACKING_SPEED_BOOST);
        } else {
            this.targetChangeTime = this.field_70173_aa;
            this.field_70180_af.func_187227_b(SCREAMING, (Object)true);
            if (!iattributeinstance.func_180374_a(ATTACKING_SPEED_BOOST)) {
                iattributeinstance.func_111121_a(ATTACKING_SPEED_BOOST);
            }
        }
        super.func_70624_b(entitylivingbaseIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CARRIED_BLOCK, Optional.empty());
        this.field_70180_af.func_187214_a(SCREAMING, (Object)false);
    }

    public void playEndermanSound() {
        if (this.field_70173_aa >= this.lastCreepySound + 400) {
            this.lastCreepySound = this.field_70173_aa;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, SoundEvents.field_187533_aW, this.func_184176_by(), 2.5f, 1.0f, false);
            }
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SCREAMING.equals(key) && this.isScreaming() && this.field_70170_p.field_72995_K) {
            this.playEndermanSound();
        }
        super.func_184206_a(key);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        BlockState blockstate = this.getHeldBlockState();
        if (blockstate != null) {
            compound.func_218657_a("carriedBlockState", (INBT)NBTUtil.func_190009_a((BlockState)blockstate));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        BlockState blockstate = null;
        if (compound.func_150297_b("carriedBlockState", 10) && (blockstate = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("carriedBlockState"))).func_196958_f()) {
            blockstate = null;
        }
        this.func_195406_b(blockstate);
    }

    private boolean shouldAttackPlayer(PlayerEntity player) {
        ItemStack itemstack = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        if (itemstack.func_77973_b() == Blocks.field_196625_cS.func_199767_j()) {
            return false;
        }
        Vec3d vec3d = player.func_70676_i(1.0f).func_72432_b();
        Vec3d vec3d1 = new Vec3d(this.field_70165_t - player.field_70165_t, this.func_174813_aQ().field_72338_b + (double)this.func_70047_e() - (player.field_70163_u + (double)player.func_70047_e()), this.field_70161_v - player.field_70161_v);
        double d0 = vec3d1.func_72433_c();
        double d1 = vec3d.func_72430_b(vec3d1 = vec3d1.func_72432_b());
        return d1 > 1.0 - 0.025 / d0 ? player.func_70685_l((Entity)this) : false;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 2.55f;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
        }
        this.field_70703_bu = false;
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        float f;
        if (this.func_203008_ap()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.field_70170_p.func_72935_r() && this.field_70173_aa >= this.targetChangeTime + 600 && (f = this.func_70013_c()) > 0.5f && this.field_70170_p.func_217337_f(new BlockPos((Entity)this)) && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.func_70624_b(null);
            this.teleportRandomly();
        }
        super.func_70619_bc();
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(d0, d1, d2);
    }

    private boolean teleportToEntity(Entity p_70816_1_) {
        Vec3d vec3d = new Vec3d(this.field_70165_t - p_70816_1_.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.func_213302_cg() / 2.0f) - p_70816_1_.field_70163_u + (double)p_70816_1_.func_70047_e(), this.field_70161_v - p_70816_1_.field_70161_v);
        vec3d = vec3d.func_72432_b();
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * 16.0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3d.field_72448_b * 16.0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * 16.0;
        return this.teleportTo(d1, d2, d3);
    }

    private boolean teleportTo(double x, double y, double z) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(x, y, z);
        while (blockpos$mutableblockpos.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a().func_76230_c()) {
            blockpos$mutableblockpos.func_189536_c(Direction.DOWN);
        }
        if (!this.field_70170_p.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a().func_76230_c()) {
            return false;
        }
        EnderTeleportEvent event = new EnderTeleportEvent((LivingEntity)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = this.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
        if (flag) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    protected SoundEvent func_184639_G() {
        return this.isScreaming() ? SoundEvents.field_187532_aV : SoundEvents.field_187529_aS;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187531_aU;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187530_aT;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
        BlockState blockstate = this.getHeldBlockState();
        if (blockstate != null) {
            this.func_199703_a((IItemProvider)blockstate.func_177230_c());
        }
    }

    public void func_195406_b(@Nullable BlockState p_195406_1_) {
        this.field_70180_af.func_187227_b(CARRIED_BLOCK, Optional.ofNullable(p_195406_1_));
    }

    @Nullable
    public BlockState getHeldBlockState() {
        return ((Optional)this.field_70180_af.func_187225_a(CARRIED_BLOCK)).orElse(null);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!(source instanceof IndirectEntityDamageSource) && source != DamageSource.field_191552_t) {
            boolean flag = super.func_70097_a(source, amount);
            if (source.func_76363_c() && this.field_70146_Z.nextInt(10) != 0) {
                this.teleportRandomly();
            }
            return flag;
        }
        for (int i = 0; i < 64; ++i) {
            if (!this.teleportRandomly()) continue;
            return true;
        }
        return false;
    }

    public boolean isScreaming() {
        return (Boolean)this.field_70180_af.func_187225_a(SCREAMING);
    }

    static class TakeBlockGoal
    extends Goal {
        private final ClassicEndermanEntity enderman;

        public TakeBlockGoal(ClassicEndermanEntity p_i45841_1_) {
            this.enderman = p_i45841_1_;
        }

        public boolean func_75250_a() {
            if (this.enderman.getHeldBlockState() != null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)this.enderman.field_70170_p, (Entity)this.enderman)) {
                return false;
            }
            return this.enderman.func_70681_au().nextInt(20) == 0;
        }

        public void func_75246_d() {
            boolean flag;
            Vec3d vec3d1;
            Random random = this.enderman.func_70681_au();
            World world = this.enderman.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.enderman.field_70165_t - 2.0 + random.nextDouble() * 4.0));
            int j = MathHelper.func_76128_c((double)(this.enderman.field_70163_u + random.nextDouble() * 3.0));
            int k = MathHelper.func_76128_c((double)(this.enderman.field_70161_v - 2.0 + random.nextDouble() * 4.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = world.func_180495_p(blockpos);
            Block block = blockstate.func_177230_c();
            Vec3d vec3d = new Vec3d((double)MathHelper.func_76128_c((double)this.enderman.field_70165_t) + 0.5, (double)j + 0.5, (double)MathHelper.func_76128_c((double)this.enderman.field_70161_v) + 0.5);
            BlockRayTraceResult blockraytraceresult = world.func_217299_a(new RayTraceContext(vec3d, vec3d1 = new Vec3d((double)i + 0.5, (double)j + 0.5, (double)k + 0.5), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.enderman));
            boolean bl = flag = blockraytraceresult.func_216346_c() != RayTraceResult.Type.MISS && blockraytraceresult.func_216350_a().equals((Object)blockpos);
            if (block.func_203417_a(BlockTags.field_201151_l) && flag) {
                this.enderman.func_195406_b(blockstate);
                world.func_217377_a(blockpos, false);
            }
        }
    }

    static class StareGoal
    extends Goal {
        private final ClassicEndermanEntity field_220835_a;

        public StareGoal(ClassicEndermanEntity p_i50520_1_) {
            this.field_220835_a = p_i50520_1_;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.field_220835_a.func_70638_az();
            if (!(livingentity instanceof PlayerEntity)) {
                return false;
            }
            double d0 = livingentity.func_70068_e((Entity)this.field_220835_a);
            return d0 > 256.0 ? false : this.field_220835_a.shouldAttackPlayer((PlayerEntity)livingentity);
        }

        public void func_75249_e() {
            this.field_220835_a.func_70661_as().func_75499_g();
        }
    }

    static class PlaceBlockGoal
    extends Goal {
        private final ClassicEndermanEntity enderman;

        public PlaceBlockGoal(ClassicEndermanEntity p_i45843_1_) {
            this.enderman = p_i45843_1_;
        }

        public boolean func_75250_a() {
            if (this.enderman.getHeldBlockState() == null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)this.enderman.field_70170_p, (Entity)this.enderman)) {
                return false;
            }
            return this.enderman.func_70681_au().nextInt(2000) == 0;
        }

        public void func_75246_d() {
            Random random = this.enderman.func_70681_au();
            World iworld = this.enderman.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.enderman.field_70165_t - 1.0 + random.nextDouble() * 2.0));
            int j = MathHelper.func_76128_c((double)(this.enderman.field_70163_u + random.nextDouble() * 2.0));
            int k = MathHelper.func_76128_c((double)(this.enderman.field_70161_v - 1.0 + random.nextDouble() * 2.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = iworld.func_180495_p(blockpos);
            BlockPos blockpos1 = blockpos.func_177977_b();
            BlockState blockstate1 = iworld.func_180495_p(blockpos1);
            BlockState blockstate2 = this.enderman.getHeldBlockState();
            if (blockstate2 != null && this.func_220836_a((IWorldReader)iworld, blockpos, blockstate2, blockstate, blockstate1, blockpos1) && !ForgeEventFactory.onBlockPlace((Entity)this.enderman, (BlockSnapshot)new BlockSnapshot((IWorld)iworld, blockpos, blockstate1), (Direction)Direction.UP)) {
                iworld.func_180501_a(blockpos, blockstate2, 3);
                this.enderman.func_195406_b(null);
            }
        }

        private boolean func_220836_a(IWorldReader p_220836_1_, BlockPos p_220836_2_, BlockState p_220836_3_, BlockState p_220836_4_, BlockState p_220836_5_, BlockPos p_220836_6_) {
            return p_220836_4_.isAir((IBlockReader)p_220836_1_, p_220836_2_) && !p_220836_5_.isAir((IBlockReader)p_220836_1_, p_220836_6_) && p_220836_5_.func_224756_o((IBlockReader)p_220836_1_, p_220836_6_) && p_220836_3_.func_196955_c(p_220836_1_, p_220836_2_);
        }
    }

    static class FindPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        private final ClassicEndermanEntity enderman;
        private PlayerEntity player;
        private int aggroTime;
        private int teleportTime;
        private final EntityPredicate field_220791_m;
        private final EntityPredicate field_220792_n = new EntityPredicate().func_221014_c();

        public FindPlayerGoal(ClassicEndermanEntity p_i45842_1_) {
            super((MobEntity)p_i45842_1_, PlayerEntity.class, false);
            this.enderman = p_i45842_1_;
            this.field_220791_m = new EntityPredicate().func_221013_a(this.func_111175_f()).func_221012_a(p_220790_1_ -> p_i45842_1_.shouldAttackPlayer((PlayerEntity)p_220790_1_));
        }

        public boolean func_75250_a() {
            this.player = this.enderman.field_70170_p.func_217370_a(this.field_220791_m, (LivingEntity)this.enderman);
            return this.player != null;
        }

        public void func_75249_e() {
            this.aggroTime = 5;
            this.teleportTime = 0;
            if (this.player != null && !this.enderman.field_70170_p.field_72995_K) {
                this.player.func_195064_c(new EffectInstance(Effects.field_76431_k, 328));
            }
        }

        public void func_75251_c() {
            this.player = null;
            super.func_75251_c();
        }

        public boolean func_75253_b() {
            if (this.player != null) {
                if (!this.enderman.shouldAttackPlayer(this.player)) {
                    return false;
                }
                this.enderman.func_70625_a((Entity)this.player, 10.0f, 10.0f);
                return true;
            }
            return this.field_75309_a != null && this.field_220792_n.func_221015_a((LivingEntity)this.enderman, this.field_75309_a) ? true : super.func_75253_b();
        }

        public void func_75246_d() {
            if (this.player != null) {
                if (--this.aggroTime <= 0) {
                    this.field_75309_a = this.player;
                    this.player = null;
                    super.func_75249_e();
                }
            } else {
                if (this.field_75309_a != null && !this.enderman.func_184218_aH()) {
                    if (this.enderman.shouldAttackPlayer((PlayerEntity)this.field_75309_a)) {
                        if (this.field_75309_a.func_70068_e((Entity)this.enderman) < 16.0) {
                            this.enderman.teleportRandomly();
                        }
                        this.teleportTime = 0;
                    } else if (this.field_75309_a.func_70068_e((Entity)this.enderman) > 256.0 && this.teleportTime++ >= 30 && this.enderman.teleportToEntity((Entity)this.field_75309_a)) {
                        this.teleportTime = 0;
                    }
                }
                super.func_75246_d();
            }
        }
    }
}

