/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.world.nightfall;

import com.legacy.farlanders.entity.FarlandersEntityTypes;
import com.legacy.farlanders.entity.hostile.boss.EnderColossusEntity;
import com.legacy.farlanders.world.nightfall.NightfallBiomeProvider;
import com.legacy.farlanders.world.nightfall.NightfallSkyRenderer;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.biome.provider.EndBiomeProviderSettings;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.EndGenerationSettings;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IRenderHandler;

public class NightfallDimension
extends Dimension {
    public static final BlockPos SPAWN = new BlockPos(100, 50, 0);
    private static boolean colossusSpawned;

    public NightfallDimension(World worldIn, DimensionType typeIn) {
        super(worldIn, typeIn);
    }

    public ChunkGenerator<?> func_186060_c() {
        EndGenerationSettings endgenerationsettings = (EndGenerationSettings)ChunkGeneratorType.field_206913_d.func_205483_a();
        endgenerationsettings.func_214969_a(Blocks.field_196604_cC.func_176223_P());
        endgenerationsettings.func_214970_b(Blocks.field_150350_a.func_176223_P());
        endgenerationsettings.func_205538_a(this.func_177496_h());
        return ChunkGeneratorType.field_206913_d.create(this.field_76579_a, (BiomeProvider)new NightfallBiomeProvider(((EndBiomeProviderSettings)BiomeProviderType.field_205463_e.func_205458_a()).func_205446_a(this.field_76579_a.func_72905_C())), (GenerationSettings)endgenerationsettings);
    }

    @OnlyIn(value=Dist.CLIENT)
    public IRenderHandler getSkyRenderer() {
        return new NightfallSkyRenderer();
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        return 0.71f;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public float[] func_76560_a(float celestialAngle, float partialTicks) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        float f = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        float f1 = 0.7529412f;
        float f2 = 0.84705883f;
        float f3 = 1.0f;
        f1 *= f * 0.94f + 0.06f;
        f2 *= f * 0.94f + 0.06f;
        f3 *= f * 0.91f + 0.09f;
        return new Vec3d(0.3, 0.3, 0.5);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_76561_g() {
        return false;
    }

    public boolean func_76567_e() {
        return false;
    }

    public boolean func_76569_d() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_76571_f() {
        return -3.0f;
    }

    @Nullable
    public BlockPos func_206920_a(ChunkPos chunkPosIn, boolean checkValid) {
        Random random = new Random(this.field_76579_a.func_72905_C());
        BlockPos blockpos = new BlockPos(chunkPosIn.func_180334_c() + random.nextInt(15), 0, chunkPosIn.func_180330_f() + random.nextInt(15));
        return this.field_76579_a.func_184141_c(blockpos).func_185904_a().func_76230_c() ? blockpos : null;
    }

    public BlockPos func_177496_h() {
        return SPAWN;
    }

    @Nullable
    public BlockPos func_206921_a(int posX, int posZ, boolean checkValid) {
        return this.func_206920_a(new ChunkPos(posX >> 4, posZ >> 4), checkValid);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getStarBrightness(float par1) {
        return 1.0f;
    }

    public MusicTicker.MusicType getMusicType() {
        return null;
    }

    public void func_186057_q() {
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74757_a("ColossusSpawned", colossusSpawned);
        this.field_76579_a.func_72912_H().func_186345_a(this.field_76579_a.func_201675_m().func_186058_p(), compoundnbt);
    }

    public void func_186059_r() {
        if (!colossusSpawned) {
            this.field_76579_a.func_175726_f(new BlockPos(0, 128, 0));
            EnderColossusEntity colossus = (EnderColossusEntity)FarlandersEntityTypes.ENDER_COLOSSUS.func_200721_a(this.field_76579_a);
            colossus.func_70012_b(0.0, 128.0, 0.0, this.field_76579_a.field_73012_v.nextFloat() * 360.0f, 0.0f);
            colossus.setNightfallSpawned(true);
            this.field_76579_a.func_217376_c((Entity)colossus);
            colossusSpawned = true;
        }
    }
}

