/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.world.structure;

import com.legacy.farlanders.FarlandersConfig;
import com.legacy.farlanders.entity.FarlanderEntity;
import com.legacy.farlanders.entity.FarlandersEntityTypes;
import com.legacy.farlanders.entity.hostile.EnderGolemEntity;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class LargeFarlanderHouseFeature
extends Feature<NoFeatureConfig> {
    private BlockState replaceID;

    public LargeFarlanderHouseFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn, BlockState replace) {
        super(configFactoryIn);
        this.replaceID = replace;
    }

    public boolean LocationIsValidSpawn(IWorld world, int i, int j, int k) {
        int distanceToAir = 0;
        BlockState checkID = world.func_180495_p(new BlockPos(i, j, k));
        while (checkID != Blocks.field_150350_a.func_176223_P()) {
            checkID = world.func_180495_p(new BlockPos(i, j + ++distanceToAir, k));
        }
        if (distanceToAir > 2) {
            return false;
        }
        BlockState blockID = world.func_180495_p(new BlockPos(i, j += distanceToAir - 1, k));
        BlockState blockIDAbove = world.func_180495_p(new BlockPos(i, j + 1, k));
        BlockState blockIDBelow = world.func_180495_p(new BlockPos(i, j - 1, k));
        if (blockIDAbove != Blocks.field_150350_a.func_176223_P()) {
            return false;
        }
        if (blockID.func_177230_c() == Blocks.field_150433_aE && blockIDBelow == this.replaceID || blockID.func_177230_c() == Blocks.field_150349_c && blockIDBelow == this.replaceID || blockID == Blocks.field_196606_bd.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_196605_bc.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_196555_aI.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_150434_aF.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_150338_P.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_150337_Q.func_176223_P() && blockIDBelow == this.replaceID) {
            return true;
        }
        return blockID == this.replaceID;
    }

    public boolean AirLocationIsValidSpawn(IWorld world, int i, int j, int k) {
        BlockState blockID = world.func_180495_p(new BlockPos(i, j, k));
        BlockState blockIDAbove = world.func_180495_p(new BlockPos(i, j + 1, k));
        return blockID == Blocks.field_150350_a.func_176223_P() && blockIDAbove == Blocks.field_150350_a.func_176223_P();
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos pos, NoFeatureConfig config) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        BlockState whiteStone = Blocks.field_150377_bs.func_176223_P();
        BlockState glassPane = Blocks.field_150410_aZ.func_176223_P();
        BlockState netherBrick = Blocks.field_196653_dH.func_176223_P();
        BlockState stairs = Blocks.field_150387_bl.func_176223_P();
        BlockState air = Blocks.field_150350_a.func_176223_P();
        if (!(this.LocationIsValidSpawn(world, i - 1, j, k - 1) && this.LocationIsValidSpawn(world, i + 9, j, k - 1) && this.LocationIsValidSpawn(world, i + 9, j, k + 7) && this.LocationIsValidSpawn(world, i - 1, j, k + 7) && this.AirLocationIsValidSpawn(world, i - 1, j + 4, k - 1) && this.AirLocationIsValidSpawn(world, i + 9, j + 4, k - 1) && this.AirLocationIsValidSpawn(world, i + 9, j + 4, k + 7) && this.AirLocationIsValidSpawn(world, i - 1, j + 4, k + 7))) {
            return false;
        }
        if (FarlandersConfig.largeHouseSpawnRate > 1 && random.nextInt(FarlandersConfig.largeHouseSpawnRate) != 0 || FarlandersConfig.largeHouseSpawnRate <= 1) {
            return false;
        }
        world.func_180501_a(new BlockPos(i + 0, j, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j, k + 1), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j, k + 5), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 1), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 5), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 1, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 2, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 1), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 5), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 3, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 1), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 5), air, 3);
        world.func_180501_a(new BlockPos(i + 0, j + 4, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 1, j, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 1, j, k + 1), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 1, j, k + 2), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 1, j, k + 3), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 1, j, k + 4), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 1, j, k + 5), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 1, j, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 1), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 2), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 3), (BlockState)((BlockState)glassPane.func_206870_a((IProperty)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 4), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 5), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 1), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 2), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 3), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 4), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 5), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 1), (BlockState)((BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH)).func_206870_a((IProperty)StairsBlock.field_176310_M, (Comparable)StairsShape.OUTER_LEFT), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 2), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.EAST), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 3), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.EAST), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 4), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.EAST), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 5), (BlockState)((BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.EAST)).func_206870_a((IProperty)StairsBlock.field_176310_M, (Comparable)StairsShape.OUTER_LEFT), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 1), air, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 5), air, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j, k + 1), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 2, j, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j, k + 3), air, 3);
        if (random.nextInt(3) == 2) {
            world.func_180501_a(new BlockPos(i + 2, j, k + 4), Blocks.field_150409_cd.func_176223_P(), 2);
        } else {
            world.func_180501_a(new BlockPos(i + 2, j, k + 4), air, 3);
        }
        world.func_180501_a(new BlockPos(i + 2, j, k + 5), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 2, j, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 1), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 5), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 1), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 5), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 1), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 5), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.NORTH), 2);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 1), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 2), (BlockState)((BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.EAST)).func_206870_a((IProperty)StairsBlock.field_176310_M, (Comparable)StairsShape.OUTER_RIGHT), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 3), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.EAST), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 4), (BlockState)((BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.EAST)).func_206870_a((IProperty)StairsBlock.field_176310_M, (Comparable)StairsShape.OUTER_LEFT), 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 5), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j, k + 1), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 3, j, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j, k + 5), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 3, j, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 1), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 5), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 1), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 5), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 1), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 5), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.NORTH), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 1), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 2), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 3), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 4), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.NORTH), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 5), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j, k + 1), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 4, j, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 1), (BlockState)((BlockState)glassPane.func_206870_a((IProperty)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 1), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 5), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 1), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 5), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.NORTH), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 1), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 2), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 3), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 4), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.NORTH), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 5), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j, k + 1), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 5, j, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j, k + 5), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 5, j, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 1), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 5), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 1), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 5), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 1), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 5), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.NORTH), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 1), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 2), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 3), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 4), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.NORTH), 2);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 5), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j, k + 1), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 6, j, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j, k + 3), air, 3);
        if (random.nextInt(3) == 2) {
            world.func_180501_a(new BlockPos(i + 6, j, k + 4), Blocks.field_196718_eZ.func_176223_P(), 2);
        } else {
            world.func_180501_a(new BlockPos(i + 6, j, k + 4), air, 3);
        }
        world.func_180501_a(new BlockPos(i + 6, j, k + 5), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 6, j, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 1), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 5), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 1), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 5), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 1), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 5), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.NORTH), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 1), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 2), (BlockState)((BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.WEST)).func_206870_a((IProperty)StairsBlock.field_176310_M, (Comparable)StairsShape.OUTER_LEFT), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 3), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.WEST), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 4), (BlockState)((BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.WEST)).func_206870_a((IProperty)StairsBlock.field_176310_M, (Comparable)StairsShape.OUTER_RIGHT), 2);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 5), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 7, j, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 7, j, k + 1), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 7, j, k + 2), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 7, j, k + 3), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 7, j, k + 4), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 7, j, k + 5), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 7, j, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 1), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 2), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 3), (BlockState)((BlockState)glassPane.func_206870_a((IProperty)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 4), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 5), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 1), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 2), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 3), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 4), whiteStone, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 5), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 1), (BlockState)((BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.WEST)).func_206870_a((IProperty)StairsBlock.field_176310_M, (Comparable)StairsShape.OUTER_LEFT), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 2), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.WEST), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 3), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.WEST), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 4), (BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.WEST), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 5), (BlockState)((BlockState)stairs.func_206870_a((IProperty)StairsBlock.field_176309_a, (Comparable)Direction.WEST)).func_206870_a((IProperty)StairsBlock.field_176310_M, (Comparable)StairsShape.OUTER_RIGHT), 2);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 1), air, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 5), air, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j, k + 1), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j, k + 5), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 1), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 5), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 1), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 5), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 0), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 1), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 2), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 3), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 4), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 5), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j, k + 5), Blocks.field_180413_ao.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 5), (BlockState)Blocks.field_180413_ao.func_176223_P().func_206870_a((IProperty)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER), 2);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 3), Blocks.field_150426_aN.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i, j, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 1, j, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 7, j, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i, j + 1, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 1, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 1, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 1, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 1, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 1, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i, j + 2, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 2, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 2, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 2, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 2, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 2, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i, j + 3, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 3, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 3, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 3, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 3, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 3, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 3, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 3, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i, j + 4, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 1, j + 4, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 2, j + 4, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 3, j + 4, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 4, j + 4, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 5, j + 4, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 6, j + 4, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 7, j + 4, k + 6), air, 3);
        world.func_180501_a(new BlockPos(i + 8, j + 4, k + 6), air, 3);
        for (int posX = i; posX <= i + 8; ++posX) {
            for (int posZ = k; posZ <= k + 6; ++posZ) {
                int posY = j - 1;
                boolean isFloorFinished = false;
                while (!isFloorFinished) {
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150350_a.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150349_c.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150434_aF.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_196606_bd.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_196605_bc.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_196555_aI.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150433_aE.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150355_j.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150353_l.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150338_P.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150337_Q.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_196651_dG.func_176223_P()) {
                        world.func_180501_a(new BlockPos(posX, posY, posZ), whiteStone, 2);
                        --posY;
                        continue;
                    }
                    isFloorFinished = true;
                }
            }
        }
        world.func_180501_a(new BlockPos(i + 2, j - 1, k + 2), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 2, j - 1, k + 3), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 2, j - 1, k + 4), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 3, j - 1, k + 2), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 3, j - 1, k + 3), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 3, j - 1, k + 4), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 4, j - 1, k + 2), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 4, j - 1, k + 3), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 4, j - 1, k + 4), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 4, j - 1, k + 5), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 5, j - 1, k + 2), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 5, j - 1, k + 3), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 5, j - 1, k + 4), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 6, j - 1, k + 2), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 6, j - 1, k + 3), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 6, j - 1, k + 4), netherBrick, 3);
        world.func_180501_a(new BlockPos(i + 6, j, k + 2), (BlockState)Blocks.field_196598_aw.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.HEAD), 3);
        world.func_180501_a(new BlockPos(i + 6, j, k + 3), (BlockState)Blocks.field_196598_aw.func_176223_P().func_206870_a((IProperty)BedBlock.field_176472_a, (Comparable)BedPart.FOOT), 3);
        FarlanderEntity var4 = new FarlanderEntity(FarlandersEntityTypes.FARLANDER, world.func_201672_e());
        var4.func_70107_b(i + 4, j + 1, k + 7);
        world.func_217376_c((Entity)var4);
        if (random.nextInt(3) == 0) {
            FarlanderEntity vars = new FarlanderEntity(FarlandersEntityTypes.FARLANDER, world.func_201672_e());
            vars.func_70873_a(-24000);
            vars.func_70107_b(i + 4, j + 1, k + 7);
            world.func_217376_c((Entity)vars);
        } else {
            FarlanderEntity var5 = new FarlanderEntity(FarlandersEntityTypes.FARLANDER, world.func_201672_e());
            var5.func_70107_b(i + 4, j + 1, k + 7);
            world.func_217376_c((Entity)var5);
        }
        EnderGolemEntity var6 = new EnderGolemEntity(FarlandersEntityTypes.ENDER_GOLEM, world.func_201672_e());
        var6.func_70107_b(i + 4, j + 1, k + 7);
        var6.func_110163_bv();
        world.func_217376_c((Entity)var6);
        if (random.nextInt(5) == 1) {
            EnderGolemEntity var7 = new EnderGolemEntity(FarlandersEntityTypes.ENDER_GOLEM, world.func_201672_e());
            var7.func_70107_b(i + 4, j + 1, k + 7);
            var7.func_110163_bv();
            world.func_217376_c((Entity)var7);
        }
        if (random.nextInt(3) == 1) {
            EnderGolemEntity var8 = new EnderGolemEntity(FarlandersEntityTypes.ENDER_GOLEM, world.func_201672_e());
            var8.func_70107_b(i + 4, j + 1, k + 7);
            var8.func_110163_bv();
            world.func_217376_c((Entity)var8);
        }
        return true;
    }
}

