/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders;

import com.legacy.structure_gel.util.ConfigTemplates;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class FarlandersConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Integer> farlanderLootWellSpawnRate;
        public final ForgeConfigSpec.ConfigValue<Integer> obsidianSpireSpawnRate;
        public final ForgeConfigSpec.ConfigValue<Boolean> disableLooterStealing;
        public final ConfigTemplates.StructureConfig smallHouseStructureConfig;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Server and Client side changes.").push("common");
            this.smallHouseStructureConfig = new ConfigTemplates.StructureConfig(builder, "small_house", 1.3, 15, 5);
            this.farlanderLootWellSpawnRate = builder.translation("farlanderLootWellSpawnRate").comment("Farlander Loot Well rarity (higher number = lower spawnrate)").define("farlanderLootWellSpawnRate", (Object)15);
            this.obsidianSpireSpawnRate = builder.translation("obsidianSpireSpawnRate").comment("Obsidian Spire rarity (higher number = lower spawnrate)").define("obsidianSpireSpawnRate", (Object)3);
            this.disableLooterStealing = builder.translation("disableLooterStealing").comment("Disables the Looter's ability to take the player's weapon (This makes them spawn with a random weapon, good and bad)").define("disableLooterStealing", false);
            builder.pop();
        }
    }
}

